/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.resiliency.spi.action;

import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.ActionResult;
import com.liferay.portal.kernel.portlet.PortletContainer;
import com.liferay.portal.kernel.portlet.PortletContainerUtil;
import com.liferay.portal.kernel.resiliency.spi.agent.SPIAgent;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.resiliency.spi.agent.SPIAgentRequest;
import com.liferay.portal.resiliency.spi.agent.SPIAgentResponse;
import com.liferay.portal.struts.Action;
import com.liferay.portal.struts.model.ActionForward;
import com.liferay.portal.struts.model.ActionMapping;
import java.util.List;
import javax.portlet.Event;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class PortalResiliencyAction
implements Action {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActionForward execute(ActionMapping actionMapping, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        SPIAgentRequest spiAgentRequest = (SPIAgentRequest)httpServletRequest.getAttribute("SPI_AGENT_REQUEST");
        HttpSession session = httpServletRequest.getSession();
        spiAgentRequest.populateSessionAttributes(session);
        PrincipalThreadLocal.setPassword((String)session.getAttribute("USER_PASSWORD"));
        try {
            this._execute(httpServletRequest, httpServletResponse);
        }
        finally {
            SPIAgentResponse spiAgentResponse = (SPIAgentResponse)httpServletRequest.getAttribute("SPI_AGENT_RESPONSE");
            spiAgentResponse.captureRequestSessionAttributes(httpServletRequest);
            httpServletRequest.setAttribute("PORTAL_RESILIENCY_ACTION", (Object)Boolean.TRUE);
        }
        return null;
    }

    private void _execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        SPIAgent.Lifecycle lifecycle;
        PortletContainer portletContainer = PortletContainerUtil.getPortletContainer();
        Portlet portlet = (Portlet)httpServletRequest.getAttribute("SPI_AGENT_PORTLET");
        String portletId = ParamUtil.getString(httpServletRequest, "p_p_id");
        if (portletId.equals(portlet.getPortletId())) {
            portletContainer.preparePortlet(httpServletRequest, portlet);
        }
        if ((lifecycle = (SPIAgent.Lifecycle)((Object)httpServletRequest.getAttribute("SPI_AGENT_LIFECYCLE"))) == SPIAgent.Lifecycle.ACTION) {
            Layout requestLayout = (Layout)httpServletRequest.getAttribute("LAYOUT");
            String typeSettings = requestLayout.getTypeSettings();
            ActionResult actionResult = portletContainer.processAction(httpServletRequest, httpServletResponse, portlet);
            String newTypeSettings = requestLayout.getTypeSettings();
            if (!newTypeSettings.equals(typeSettings)) {
                httpServletRequest.setAttribute("SPI_AGENT_LAYOUT_TYPE_SETTINGS", (Object)newTypeSettings);
            }
            httpServletRequest.setAttribute("SPI_AGENT_ACTION_RESULT", (Object)actionResult);
        } else if (lifecycle == SPIAgent.Lifecycle.EVENT) {
            Layout requestLayout = (Layout)httpServletRequest.getAttribute("LAYOUT");
            String typeSettings = requestLayout.getTypeSettings();
            Layout layout = (Layout)httpServletRequest.getAttribute("SPI_AGENT_LAYOUT");
            Event event = (Event)httpServletRequest.getAttribute("SPI_AGENT_EVENT");
            List<Event> events = portletContainer.processEvent(httpServletRequest, httpServletResponse, portlet, layout, event);
            String newTypeSettings = requestLayout.getTypeSettings();
            if (!newTypeSettings.equals(typeSettings)) {
                httpServletRequest.setAttribute("SPI_AGENT_LAYOUT_TYPE_SETTINGS", (Object)newTypeSettings);
            }
            httpServletRequest.setAttribute("SPI_AGENT_EVENT_RESULT", events);
        } else if (lifecycle == SPIAgent.Lifecycle.RENDER) {
            portletContainer.render(httpServletRequest, httpServletResponse, portlet);
        } else if (lifecycle == SPIAgent.Lifecycle.RESOURCE) {
            portletContainer.serveResource(httpServletRequest, httpServletResponse, portlet);
        } else {
            throw new IllegalArgumentException("Unkown lifecycle " + (Object)((Object)lifecycle));
        }
    }
}

