/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.resiliency.spi;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.resiliency.spi.SPI;
import com.liferay.portal.kernel.resiliency.spi.SPIConfiguration;
import com.liferay.portal.kernel.resiliency.spi.SPIRegistry;
import com.liferay.portal.kernel.resiliency.spi.SPIRegistryValidator;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SPIRegistryImpl
implements SPIRegistry {
    private static final Log _log = LogFactoryUtil.getLog(SPIRegistryImpl.class);
    private SPI _errorSPI;
    private final Set<String> _excludedPortletIds = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Lock _lock = new ReentrantLock();
    private final Map<SPI, String[]> _portletIds = new ConcurrentHashMap<SPI, String[]>();
    private final Map<String, SPI> _portletSPIs = new ConcurrentHashMap<String, SPI>();
    private final Map<SPI, String[]> _servletContextNames = new ConcurrentHashMap<SPI, String[]>();
    private final Map<String, SPI> _servletContextSPIs = new ConcurrentHashMap<String, SPI>();
    private SPIRegistryValidator _spiRegistryValidator;

    @Override
    public void addExcludedPortletId(String portletId) {
        this._excludedPortletIds.add(portletId);
    }

    @Override
    public SPI getErrorSPI() {
        return this._errorSPI;
    }

    @Override
    public Set<String> getExcludedPortletIds() {
        return this._excludedPortletIds;
    }

    @Override
    public SPI getPortletSPI(String portletId) {
        if (this._excludedPortletIds.contains(portletId)) {
            return null;
        }
        SPI spi = this._portletSPIs.get(portletId);
        if (this._spiRegistryValidator != null) {
            spi = this._spiRegistryValidator.validatePortletSPI(portletId, spi);
        }
        return spi;
    }

    @Override
    public SPI getServletContextSPI(String servletContextName) {
        SPI spi = this._servletContextSPIs.get(servletContextName);
        if (this._spiRegistryValidator != null) {
            spi = this._spiRegistryValidator.validateServletContextSPI(servletContextName, spi);
        }
        return spi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSPI(SPI spi) throws RemoteException {
        ArrayList<String> portletIds = new ArrayList<String>();
        SPIConfiguration spiConfiguration = spi.getSPIConfiguration();
        for (String portletId : spiConfiguration.getPortletIds()) {
            Portlet portlet = PortletLocalServiceUtil.getPortletById(portletId);
            if (portlet == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn("Skip unknown portlet id " + portletId);
                continue;
            }
            portletIds.add(portletId);
        }
        String[] servletContextNames = spiConfiguration.getServletContextNames();
        for (String string : servletContextNames) {
            PortletApp portletApp = PortletLocalServiceUtil.getPortletApp(string);
            if (portletApp == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn("Skip unknown servlet context name " + string);
                continue;
            }
            List<Portlet> portlets = portletApp.getPortlets();
            for (Portlet portlet : portlets) {
                portletIds.add(portlet.getPortletId());
            }
        }
        this._lock.lock();
        try {
            for (String portletId : portletIds) {
                this._portletSPIs.put(portletId, spi);
            }
            this._portletIds.put(spi, portletIds.toArray(new String[0]));
            for (String string : servletContextNames) {
                this._servletContextSPIs.put(string, spi);
            }
            this._servletContextNames.put(spi, (String[])servletContextNames.clone());
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public void removeExcludedPortletId(String portletId) {
        this._excludedPortletIds.remove(portletId);
    }

    public void setErrorSPI(SPI errorSPI) {
        this._errorSPI = errorSPI;
    }

    @Override
    public void setSPIRegistryValidator(SPIRegistryValidator spiRegistryValidator) {
        this._spiRegistryValidator = spiRegistryValidator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterSPI(SPI spi) {
        this._lock.lock();
        try {
            String[] servletContextNames;
            String[] portletIds = this._portletIds.remove(spi);
            if (portletIds != null) {
                for (String portletId : portletIds) {
                    this._portletSPIs.remove(portletId);
                }
            }
            if ((servletContextNames = this._servletContextNames.remove(spi)) != null) {
                for (String servletContextName : servletContextNames) {
                    this._servletContextSPIs.remove(servletContextName);
                }
            }
        }
        finally {
            this._lock.unlock();
        }
    }
}

