/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.resiliency.service;

import com.liferay.portal.internal.resiliency.service.ServiceMethodProcessCallable;
import com.liferay.portal.kernel.aop.AopMethodInvocation;
import com.liferay.portal.kernel.aop.ChainableMethodAdvice;
import com.liferay.portal.kernel.concurrent.NoticeableFuture;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiServiceInvokerUtil;
import com.liferay.portal.kernel.nio.intraband.rpc.IntrabandRPCUtil;
import com.liferay.portal.kernel.resiliency.spi.SPI;
import com.liferay.portal.kernel.resiliency.spi.SPIRegistryUtil;
import com.liferay.portal.kernel.security.access.control.AccessControlThreadLocal;
import com.liferay.portal.kernel.security.access.control.AccessControlled;
import com.liferay.portal.kernel.servlet.ServletContextClassLoaderPool;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;

public class PortalResiliencyAdvice
extends ChainableMethodAdvice {
    @Override
    public Object createMethodContext(Class<?> targetClass, Method method, Map<Class<? extends Annotation>, Annotation> annotations) {
        Annotation annotation = annotations.get(AccessControlled.class);
        if (annotation == null) {
            return null;
        }
        String servletContextName = ServletContextClassLoaderPool.getServletContextName(targetClass.getClassLoader());
        if (servletContextName == null) {
            return null;
        }
        return SPIRegistryUtil.getServletContextSPI(servletContextName);
    }

    @Override
    protected Object before(AopMethodInvocation aopMethodInvocation, Object[] arguments) throws Throwable {
        boolean remoteAccess = AccessControlThreadLocal.isRemoteAccess();
        if (!remoteAccess) {
            return null;
        }
        SPI spi = (SPI)aopMethodInvocation.getAdviceMethodContext();
        ServiceMethodProcessCallable serviceMethodProcessCallable = new ServiceMethodProcessCallable(IdentifiableOSGiServiceInvokerUtil.createMethodHandler(aopMethodInvocation.getThis(), aopMethodInvocation.getMethod(), arguments));
        NoticeableFuture<Serializable> future = IntrabandRPCUtil.execute(spi.getRegistrationReference(), serviceMethodProcessCallable);
        Object result = future.get();
        Method method = aopMethodInvocation.getMethod();
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE) {
            result = nullResult;
        }
        return result;
    }
}

