/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.resiliency.mpi.portlet;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.ActionResult;
import com.liferay.portal.kernel.portlet.PortletContainer;
import com.liferay.portal.kernel.portlet.PortletContainerException;
import com.liferay.portal.kernel.resiliency.PortalResiliencyException;
import com.liferay.portal.kernel.resiliency.spi.SPI;
import com.liferay.portal.kernel.resiliency.spi.SPIRegistryUtil;
import com.liferay.portal.kernel.resiliency.spi.agent.SPIAgent;
import com.liferay.portal.util.PropsValues;
import java.util.Collections;
import java.util.List;
import javax.portlet.Event;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortalResiliencyPortletContainerWrapper
implements PortletContainer {
    private static final String[] _ACTION_REQUEST_ATTRIBUTE_NAMES = new String[]{"SPI_AGENT_LIFECYCLE", "SPI_AGENT_PORTLET"};
    private static final String[] _EVENT_REQUEST_ATTRIBUTE_NAMES = new String[]{"SPI_AGENT_EVENT", "SPI_AGENT_LAYOUT", "SPI_AGENT_LIFECYCLE", "SPI_AGENT_PORTLET"};
    private static final String[] _RENDER_REQUEST_ATTRIBUTE_NAMES = _ACTION_REQUEST_ATTRIBUTE_NAMES;
    private static final String[] _RESOURCE_REQUEST_ATTRIBUTE_NAMES = _ACTION_REQUEST_ATTRIBUTE_NAMES;
    private static final Log _log = LogFactoryUtil.getLog(PortalResiliencyPortletContainerWrapper.class);
    private final PortletContainer _portletContainer;

    public static PortletContainer createPortalResiliencyPortletContainerWrapper(PortletContainer portletContainer) {
        if (PropsValues.PORTAL_RESILIENCY_ENABLED) {
            portletContainer = new PortalResiliencyPortletContainerWrapper(portletContainer);
        }
        return portletContainer;
    }

    public PortalResiliencyPortletContainerWrapper(PortletContainer portletContainer) {
        this._portletContainer = portletContainer;
    }

    @Override
    public void preparePortlet(HttpServletRequest httpServletRequest, Portlet portlet) throws PortletContainerException {
        this._portletContainer.preparePortlet(httpServletRequest, portlet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActionResult processAction(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet) throws PortletContainerException {
        SPIAgent spiAgent = this.getSPIAgentForPortlet(portlet);
        if (spiAgent == null) {
            return this._portletContainer.processAction(httpServletRequest, httpServletResponse, portlet);
        }
        Object[] requestAttributeValues = this.captureRequestAttibutes(httpServletRequest, _ACTION_REQUEST_ATTRIBUTE_NAMES);
        httpServletRequest.setAttribute("SPI_AGENT_LIFECYCLE", (Object)SPIAgent.Lifecycle.ACTION);
        httpServletRequest.setAttribute("SPI_AGENT_PORTLET", (Object)portlet);
        try {
            spiAgent.service(httpServletRequest, httpServletResponse);
            ActionResult actionResult = (ActionResult)httpServletRequest.getAttribute("SPI_AGENT_ACTION_RESULT");
            return actionResult;
        }
        catch (PortalResiliencyException pre) {
            _log.error(pre, pre);
            ActionResult actionResult = ActionResult.EMPTY_ACTION_RESULT;
            return actionResult;
        }
        finally {
            httpServletRequest.removeAttribute("SPI_AGENT_ACTION_RESULT");
            this.restoreRequestAttibutes(httpServletRequest, _ACTION_REQUEST_ATTRIBUTE_NAMES, requestAttributeValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Event> processEvent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet, Layout layout, Event event) throws PortletContainerException {
        SPIAgent spiAgent = this.getSPIAgentForPortlet(portlet);
        if (spiAgent == null) {
            return this._portletContainer.processEvent(httpServletRequest, httpServletResponse, portlet, layout, event);
        }
        Object[] requestAttributeValues = this.captureRequestAttibutes(httpServletRequest, _EVENT_REQUEST_ATTRIBUTE_NAMES);
        httpServletRequest.setAttribute("SPI_AGENT_EVENT", (Object)event);
        httpServletRequest.setAttribute("SPI_AGENT_LAYOUT", (Object)layout);
        httpServletRequest.setAttribute("SPI_AGENT_LIFECYCLE", (Object)SPIAgent.Lifecycle.EVENT);
        httpServletRequest.setAttribute("SPI_AGENT_PORTLET", (Object)portlet);
        try {
            spiAgent.service(httpServletRequest, httpServletResponse);
            List list = (List)httpServletRequest.getAttribute("SPI_AGENT_EVENT_RESULT");
            return list;
        }
        catch (PortalResiliencyException pre) {
            _log.error(pre, pre);
            List<Event> list = Collections.emptyList();
            return list;
        }
        finally {
            httpServletRequest.removeAttribute("SPI_AGENT_EVENT_RESULT");
            this.restoreRequestAttibutes(httpServletRequest, _EVENT_REQUEST_ATTRIBUTE_NAMES, requestAttributeValues);
        }
    }

    @Override
    public void processPublicRenderParameters(HttpServletRequest httpServletRequest, Layout layout) {
        this._portletContainer.processPublicRenderParameters(httpServletRequest, layout);
    }

    @Override
    public void processPublicRenderParameters(HttpServletRequest httpServletRequest, Layout layout, Portlet portlet) {
        this._portletContainer.processPublicRenderParameters(httpServletRequest, layout, portlet);
    }

    @Override
    public void render(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet) throws PortletContainerException {
        this._render(httpServletRequest, httpServletResponse, portlet, () -> this._portletContainer.render(httpServletRequest, httpServletResponse, portlet));
    }

    @Override
    public void renderHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet) throws PortletContainerException {
        this._render(httpServletRequest, httpServletResponse, portlet, () -> this._portletContainer.renderHeaders(httpServletRequest, httpServletResponse, portlet));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serveResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet) throws PortletContainerException {
        SPIAgent spiAgent = this.getSPIAgentForPortlet(portlet);
        if (spiAgent == null) {
            this._portletContainer.serveResource(httpServletRequest, httpServletResponse, portlet);
            return;
        }
        Object[] requestAttributeValues = this.captureRequestAttibutes(httpServletRequest, _RESOURCE_REQUEST_ATTRIBUTE_NAMES);
        httpServletRequest.setAttribute("SPI_AGENT_LIFECYCLE", (Object)SPIAgent.Lifecycle.RESOURCE);
        httpServletRequest.setAttribute("SPI_AGENT_PORTLET", (Object)portlet);
        try {
            spiAgent.service(httpServletRequest, httpServletResponse);
        }
        catch (PortalResiliencyException pre) {
            _log.error(pre, pre);
        }
        finally {
            this.restoreRequestAttibutes(httpServletRequest, _RESOURCE_REQUEST_ATTRIBUTE_NAMES, requestAttributeValues);
        }
    }

    protected Object[] captureRequestAttibutes(HttpServletRequest httpServletRequest, String ... names) {
        Object[] values = new Object[names.length];
        for (int i = 0; i < names.length; ++i) {
            values[i] = httpServletRequest.getAttribute(names[i]);
        }
        return values;
    }

    protected SPIAgent getSPIAgentForPortlet(Portlet portlet) throws PortletContainerException {
        try {
            SPI spi = SPIRegistryUtil.getPortletSPI(portlet.getRootPortletId());
            if (spi == null) {
                return null;
            }
            if (_log.isDebugEnabled()) {
                _log.debug(StringBundler.concat("Portlet ", portlet, " is registered to SPI ", spi));
            }
            return spi.getSPIAgent();
        }
        catch (Exception e) {
            throw new PortletContainerException(e);
        }
    }

    protected void restoreRequestAttibutes(HttpServletRequest httpServletRequest, String[] names, Object[] values) {
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            Object value = values[i];
            if (value == null) {
                httpServletRequest.removeAttribute(name);
                continue;
            }
            httpServletRequest.setAttribute(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _render(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet, Renderable renderable) throws PortletContainerException {
        SPIAgent spiAgent = this.getSPIAgentForPortlet(portlet);
        if (spiAgent == null) {
            renderable.render();
            return;
        }
        Object[] requestAttributeValues = this.captureRequestAttibutes(httpServletRequest, _RENDER_REQUEST_ATTRIBUTE_NAMES);
        httpServletRequest.setAttribute("SPI_AGENT_LIFECYCLE", (Object)SPIAgent.Lifecycle.RENDER);
        httpServletRequest.setAttribute("SPI_AGENT_PORTLET", (Object)portlet);
        try {
            spiAgent.service(httpServletRequest, httpServletResponse);
        }
        catch (PortalResiliencyException pre) {
            _log.error(pre, pre);
        }
        finally {
            this.restoreRequestAttibutes(httpServletRequest, _RENDER_REQUEST_ATTRIBUTE_NAMES, requestAttributeValues);
        }
    }

    @FunctionalInterface
    private static interface Renderable {
        public void render() throws PortletContainerException;
    }
}

