/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.util;

import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryEntry;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.File;
import java.io.InputStream;
import java.util.List;

public class RepositoryWrapper
implements Repository {
    private volatile Repository _repository;

    public RepositoryWrapper(Repository repository) {
        this.setRepository(repository);
    }

    @Override
    public FileEntry addFileEntry(long userId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, File file, ServiceContext serviceContext) throws PortalException {
        return this._repository.addFileEntry(userId, folderId, sourceFileName, mimeType, title, description, changeLog, file, serviceContext);
    }

    @Override
    public FileEntry addFileEntry(long userId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        return this._repository.addFileEntry(userId, folderId, sourceFileName, mimeType, title, description, changeLog, is, size, serviceContext);
    }

    @Override
    public FileShortcut addFileShortcut(long userId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        return this._repository.addFileShortcut(userId, folderId, toFileEntryId, serviceContext);
    }

    @Override
    public Folder addFolder(long userId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        return this._repository.addFolder(userId, parentFolderId, name, description, serviceContext);
    }

    @Override
    public FileVersion cancelCheckOut(long fileEntryId) throws PortalException {
        return this._repository.cancelCheckOut(fileEntryId);
    }

    @Override
    @Deprecated
    public void checkInFileEntry(long userId, long fileEntryId, boolean majorVersion, String changeLog, ServiceContext serviceContext) throws PortalException {
        this.checkInFileEntry(userId, fileEntryId, DLVersionNumberIncrease.fromMajorVersion(majorVersion), changeLog, serviceContext);
    }

    @Override
    public void checkInFileEntry(long userId, long fileEntryId, DLVersionNumberIncrease dlVersionNumberIncrease, String changeLog, ServiceContext serviceContext) throws PortalException {
        this._repository.checkInFileEntry(userId, fileEntryId, dlVersionNumberIncrease, changeLog, serviceContext);
    }

    @Override
    public void checkInFileEntry(long userId, long fileEntryId, String lockUuid, ServiceContext serviceContext) throws PortalException {
        this._repository.checkInFileEntry(userId, fileEntryId, lockUuid, serviceContext);
    }

    @Override
    public FileEntry checkOutFileEntry(long fileEntryId, ServiceContext serviceContext) throws PortalException {
        return this._repository.checkOutFileEntry(fileEntryId, serviceContext);
    }

    @Override
    public FileEntry checkOutFileEntry(long fileEntryId, String owner, long expirationTime, ServiceContext serviceContext) throws PortalException {
        return this._repository.checkOutFileEntry(fileEntryId, owner, expirationTime, serviceContext);
    }

    @Override
    public FileEntry copyFileEntry(long userId, long groupId, long fileEntryId, long destFolderId, ServiceContext serviceContext) throws PortalException {
        return this._repository.copyFileEntry(userId, groupId, fileEntryId, destFolderId, serviceContext);
    }

    @Override
    public void deleteAll() throws PortalException {
        this._repository.deleteAll();
    }

    @Override
    public void deleteFileEntry(long fileEntryId) throws PortalException {
        this._repository.deleteFileEntry(fileEntryId);
    }

    @Override
    public void deleteFileEntry(long folderId, String title) throws PortalException {
        this._repository.deleteFileEntry(folderId, title);
    }

    @Override
    public void deleteFileShortcut(long fileShortcutId) throws PortalException {
        this._repository.deleteFileShortcut(fileShortcutId);
    }

    @Override
    public void deleteFileShortcuts(long toFileEntryId) throws PortalException {
        this._repository.deleteFileShortcuts(toFileEntryId);
    }

    @Override
    public void deleteFileVersion(long fileVersionId) throws PortalException {
        this._repository.deleteFileVersion(fileVersionId);
    }

    @Override
    public void deleteFileVersion(long fileEntryId, String version) throws PortalException {
        this._repository.deleteFileVersion(fileEntryId, version);
    }

    @Override
    public void deleteFolder(long folderId) throws PortalException {
        this._repository.deleteFolder(folderId);
    }

    @Override
    public void deleteFolder(long parentFolderId, String name) throws PortalException {
        this._repository.deleteFolder(parentFolderId, name);
    }

    @Override
    public <T extends Capability> T getCapability(Class<T> capabilityClass) {
        return this._repository.getCapability(capabilityClass);
    }

    @Override
    public List<FileEntry> getFileEntries(long folderId, int status, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        return this._repository.getFileEntries(folderId, status, start, end, obc);
    }

    @Override
    public List<FileEntry> getFileEntries(long folderId, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        return this._repository.getFileEntries(folderId, start, end, obc);
    }

    @Override
    public List<FileEntry> getFileEntries(long folderId, long fileEntryTypeId, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        return this._repository.getFileEntries(folderId, fileEntryTypeId, start, end, obc);
    }

    @Override
    public List<FileEntry> getFileEntries(long folderId, String[] mimeTypes, int status, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        return this._repository.getFileEntries(folderId, mimeTypes, status, start, end, obc);
    }

    @Override
    public List<FileEntry> getFileEntries(long folderId, String[] mimeTypes, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        return this._repository.getFileEntries(folderId, mimeTypes, start, end, obc);
    }

    @Override
    public List<RepositoryEntry> getFileEntriesAndFileShortcuts(long folderId, int status, int start, int end) throws PortalException {
        return this._repository.getFileEntriesAndFileShortcuts(folderId, status, start, end);
    }

    @Override
    public int getFileEntriesAndFileShortcutsCount(long folderId, int status) throws PortalException {
        return this._repository.getFileEntriesAndFileShortcutsCount(folderId, status);
    }

    @Override
    public int getFileEntriesAndFileShortcutsCount(long folderId, int status, String[] mimeTypes) throws PortalException {
        return this._repository.getFileEntriesAndFileShortcutsCount(folderId, status, mimeTypes);
    }

    @Override
    public int getFileEntriesCount(long folderId) throws PortalException {
        return this._repository.getFileEntriesCount(folderId);
    }

    @Override
    public int getFileEntriesCount(long folderId, int status) throws PortalException {
        return this._repository.getFileEntriesCount(folderId, status);
    }

    @Override
    public int getFileEntriesCount(long folderId, long fileEntryTypeId) throws PortalException {
        return this._repository.getFileEntriesCount(folderId, fileEntryTypeId);
    }

    @Override
    public int getFileEntriesCount(long folderId, String[] mimeTypes) throws PortalException {
        return this._repository.getFileEntriesCount(folderId, mimeTypes);
    }

    @Override
    public int getFileEntriesCount(long folderId, String[] mimeTypes, int status) throws PortalException {
        return this._repository.getFileEntriesCount(folderId, mimeTypes, status);
    }

    @Override
    public FileEntry getFileEntry(long fileEntryId) throws PortalException {
        return this._repository.getFileEntry(fileEntryId);
    }

    @Override
    public FileEntry getFileEntry(long folderId, String title) throws PortalException {
        return this._repository.getFileEntry(folderId, title);
    }

    @Override
    public FileEntry getFileEntryByUuid(String uuid) throws PortalException {
        return this._repository.getFileEntryByUuid(uuid);
    }

    @Override
    public FileShortcut getFileShortcut(long fileShortcutId) throws PortalException {
        return this._repository.getFileShortcut(fileShortcutId);
    }

    @Override
    public FileVersion getFileVersion(long fileVersionId) throws PortalException {
        return this._repository.getFileVersion(fileVersionId);
    }

    @Override
    public Folder getFolder(long folderId) throws PortalException {
        return this._repository.getFolder(folderId);
    }

    @Override
    public Folder getFolder(long parentFolderId, String name) throws PortalException {
        return this._repository.getFolder(parentFolderId, name);
    }

    @Override
    public List<Folder> getFolders(long parentFolderId, boolean includeMountFolders, int start, int end, OrderByComparator<Folder> obc) throws PortalException {
        return this._repository.getFolders(parentFolderId, includeMountFolders, start, end, obc);
    }

    @Override
    public List<Folder> getFolders(long parentFolderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator<Folder> obc) throws PortalException {
        return this._repository.getFolders(parentFolderId, status, includeMountFolders, start, end, obc);
    }

    @Override
    public List<RepositoryEntry> getFoldersAndFileEntriesAndFileShortcuts(long folderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator<?> obc) throws PortalException {
        return this._repository.getFoldersAndFileEntriesAndFileShortcuts(folderId, status, includeMountFolders, start, end, obc);
    }

    @Override
    public List<RepositoryEntry> getFoldersAndFileEntriesAndFileShortcuts(long folderId, int status, String[] mimeTypes, boolean includeMountFolders, boolean includeOwner, int start, int end, OrderByComparator<?> obc) throws PortalException {
        return this._repository.getFoldersAndFileEntriesAndFileShortcuts(folderId, status, mimeTypes, includeMountFolders, includeOwner, start, end, obc);
    }

    @Override
    public List<RepositoryEntry> getFoldersAndFileEntriesAndFileShortcuts(long folderId, int status, String[] mimeTypes, boolean includeMountFolders, int start, int end, OrderByComparator<?> obc) throws PortalException {
        return this._repository.getFoldersAndFileEntriesAndFileShortcuts(folderId, status, mimeTypes, includeMountFolders, start, end, obc);
    }

    @Override
    public int getFoldersAndFileEntriesAndFileShortcutsCount(long folderId, int status, boolean includeMountFolders) throws PortalException {
        return this._repository.getFoldersAndFileEntriesAndFileShortcutsCount(folderId, status, includeMountFolders);
    }

    @Override
    public int getFoldersAndFileEntriesAndFileShortcutsCount(long folderId, int status, String[] mimeTypes, boolean includeMountFolders) throws PortalException {
        return this._repository.getFoldersAndFileEntriesAndFileShortcutsCount(folderId, status, mimeTypes, includeMountFolders);
    }

    @Override
    public int getFoldersAndFileEntriesAndFileShortcutsCount(long folderId, int status, String[] mimeTypes, boolean includeMountFolders, boolean includeOwner) throws PortalException {
        return this._repository.getFoldersAndFileEntriesAndFileShortcutsCount(folderId, status, mimeTypes, includeMountFolders, includeOwner);
    }

    @Override
    public int getFoldersCount(long parentFolderId, boolean includeMountfolders) throws PortalException {
        return this._repository.getFoldersCount(parentFolderId, includeMountfolders);
    }

    @Override
    public int getFoldersCount(long parentFolderId, int status, boolean includeMountfolders) throws PortalException {
        return this._repository.getFoldersCount(parentFolderId, status, includeMountfolders);
    }

    @Override
    public int getFoldersFileEntriesCount(List<Long> folderIds, int status) throws PortalException {
        return this._repository.getFoldersFileEntriesCount(folderIds, status);
    }

    @Override
    public List<Folder> getMountFolders(long parentFolderId, int start, int end, OrderByComparator<Folder> obc) throws PortalException {
        return this._repository.getMountFolders(parentFolderId, start, end, obc);
    }

    @Override
    public int getMountFoldersCount(long parentFolderId) throws PortalException {
        return this._repository.getMountFoldersCount(parentFolderId);
    }

    @Override
    public List<FileEntry> getRepositoryFileEntries(long userId, long rootFolderId, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        return this._repository.getRepositoryFileEntries(userId, rootFolderId, start, end, obc);
    }

    @Override
    public List<FileEntry> getRepositoryFileEntries(long userId, long rootFolderId, String[] mimeTypes, int status, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        return this._repository.getRepositoryFileEntries(userId, rootFolderId, mimeTypes, status, start, end, obc);
    }

    @Override
    public int getRepositoryFileEntriesCount(long userId, long rootFolderId) throws PortalException {
        return this._repository.getRepositoryFileEntriesCount(userId, rootFolderId);
    }

    @Override
    public int getRepositoryFileEntriesCount(long userId, long rootFolderId, String[] mimeTypes, int status) throws PortalException {
        return this._repository.getRepositoryFileEntriesCount(userId, rootFolderId, mimeTypes, status);
    }

    @Override
    public long getRepositoryId() {
        return this._repository.getRepositoryId();
    }

    @Override
    public void getSubfolderIds(List<Long> folderIds, long folderId) throws PortalException {
        this._repository.getSubfolderIds(folderIds, folderId);
    }

    @Override
    public List<Long> getSubfolderIds(long folderId, boolean recurse) throws PortalException {
        return this._repository.getSubfolderIds(folderId, recurse);
    }

    @Override
    public <T extends Capability> boolean isCapabilityProvided(Class<T> capabilityClass) {
        return this._repository.isCapabilityProvided(capabilityClass);
    }

    @Override
    public Lock lockFolder(long folderId) throws PortalException {
        return this._repository.lockFolder(folderId);
    }

    @Override
    public Lock lockFolder(long folderId, String owner, boolean inheritable, long expirationTime) throws PortalException {
        return this._repository.lockFolder(folderId, owner, inheritable, expirationTime);
    }

    @Override
    public FileEntry moveFileEntry(long userId, long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        return this._repository.moveFileEntry(userId, fileEntryId, newFolderId, serviceContext);
    }

    @Override
    public Folder moveFolder(long userId, long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        return this._repository.moveFolder(userId, folderId, parentFolderId, serviceContext);
    }

    @Override
    public Lock refreshFileEntryLock(String lockUuid, long companyId, long expirationTime) throws PortalException {
        return this._repository.refreshFileEntryLock(lockUuid, companyId, expirationTime);
    }

    @Override
    public Lock refreshFolderLock(String lockUuid, long companyId, long expirationTime) throws PortalException {
        return this._repository.refreshFolderLock(lockUuid, companyId, expirationTime);
    }

    @Override
    public void revertFileEntry(long userId, long fileEntryId, String version, ServiceContext serviceContext) throws PortalException {
        this._repository.revertFileEntry(userId, fileEntryId, version, serviceContext);
    }

    @Override
    public Hits search(long creatorUserId, int status, int start, int end) throws PortalException {
        return this._repository.search(creatorUserId, status, start, end);
    }

    @Override
    public Hits search(long creatorUserId, long folderId, String[] mimeTypes, int status, int start, int end) throws PortalException {
        return this._repository.search(creatorUserId, folderId, mimeTypes, status, start, end);
    }

    @Override
    public Hits search(SearchContext searchContext) throws SearchException {
        return this._repository.search(searchContext);
    }

    @Override
    public Hits search(SearchContext searchContext, Query query) throws SearchException {
        return this._repository.search(searchContext, query);
    }

    public void setRepository(Repository repository) {
        this._repository = repository;
    }

    @Override
    public void unlockFolder(long folderId, String lockUuid) throws PortalException {
        this._repository.unlockFolder(folderId, lockUuid);
    }

    @Override
    public void unlockFolder(long parentFolderId, String name, String lockUuid) throws PortalException {
        this._repository.unlockFolder(parentFolderId, name, lockUuid);
    }

    @Override
    @Deprecated
    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, File file, ServiceContext serviceContext) throws PortalException {
        return this.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, DLVersionNumberIncrease.fromMajorVersion(majorVersion), file, serviceContext);
    }

    @Override
    @Deprecated
    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        return this.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, DLVersionNumberIncrease.fromMajorVersion(majorVersion), is, size, serviceContext);
    }

    @Override
    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, File file, ServiceContext serviceContext) throws PortalException {
        return this._repository.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, dlVersionNumberIncrease, file, serviceContext);
    }

    @Override
    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        return this._repository.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, dlVersionNumberIncrease, is, size, serviceContext);
    }

    @Override
    public FileShortcut updateFileShortcut(long userId, long fileShortcutId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        return this._repository.updateFileShortcut(userId, fileShortcutId, folderId, toFileEntryId, serviceContext);
    }

    @Override
    public void updateFileShortcuts(long oldToFileEntryId, long newToFileEntryId) throws PortalException {
        this._repository.updateFileShortcuts(oldToFileEntryId, newToFileEntryId);
    }

    @Override
    public Folder updateFolder(long folderId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        return this._repository.updateFolder(folderId, parentFolderId, name, description, serviceContext);
    }

    @Override
    public Folder updateFolder(long folderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        return this._repository.updateFolder(folderId, name, description, serviceContext);
    }

    @Override
    public boolean verifyFileEntryCheckOut(long fileEntryId, String lockUuid) throws PortalException {
        return this._repository.verifyFileEntryCheckOut(fileEntryId, lockUuid);
    }

    @Override
    public boolean verifyFileEntryLock(long fileEntryId, String lockUuid) throws PortalException {
        return this._repository.verifyFileEntryLock(fileEntryId, lockUuid);
    }

    @Override
    public boolean verifyInheritableLock(long folderId, String lockUuid) throws PortalException {
        return this._repository.verifyInheritableLock(folderId, lockUuid);
    }
}

