/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.util;

import com.liferay.portal.kernel.repository.BaseRepository;
import com.liferay.portal.kernel.repository.RepositoryException;
import com.liferay.portal.repository.util.ExternalRepositoryFactory;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ExternalRepositoryFactoryUtil {
    private static final ConcurrentMap<String, ExternalRepositoryFactory> _externalRepositoryFactories = new ConcurrentHashMap<String, ExternalRepositoryFactory>();

    @Deprecated
    public static String[] getExternalRepositoryClassNames() {
        Set classNames = _externalRepositoryFactories.keySet();
        return classNames.toArray(new String[0]);
    }

    public static BaseRepository getInstance(String className) throws Exception {
        ExternalRepositoryFactory externalRepositoryFactory = (ExternalRepositoryFactory)_externalRepositoryFactories.get(className);
        BaseRepository baseRepository = null;
        if (externalRepositoryFactory != null) {
            baseRepository = externalRepositoryFactory.getInstance();
        }
        if (baseRepository != null) {
            return baseRepository;
        }
        throw new RepositoryException("Repository with class name " + className + " is unavailable");
    }

    public static void registerExternalRepositoryFactory(String className, ExternalRepositoryFactory externalRepositoryFactory) {
        _externalRepositoryFactories.put(className, externalRepositoryFactory);
    }

    public static void unregisterExternalRepositoryFactory(String className) {
        _externalRepositoryFactories.remove(className);
    }
}

