/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.temporaryrepository;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.repository.DocumentRepository;
import com.liferay.portal.kernel.repository.RepositoryFactory;
import com.liferay.portal.kernel.repository.UndeployedExternalRepositoryException;
import com.liferay.portal.kernel.repository.capabilities.BulkOperationCapability;
import com.liferay.portal.kernel.repository.capabilities.PortalCapabilityLocator;
import com.liferay.portal.kernel.repository.capabilities.TemporaryFileEntriesCapability;
import com.liferay.portal.kernel.repository.capabilities.WorkflowCapability;
import com.liferay.portal.kernel.repository.registry.BaseRepositoryDefiner;
import com.liferay.portal.kernel.repository.registry.CapabilityRegistry;
import com.liferay.portal.kernel.repository.registry.RepositoryDefiner;
import com.liferay.portal.kernel.repository.registry.RepositoryFactoryRegistry;
import com.liferay.portal.repository.temporaryrepository.TemporaryFileEntryRepository;
import java.util.function.BiFunction;

public class TemporaryFileEntryRepositoryDefiner
extends BaseRepositoryDefiner {
    public static final String CLASS_NAME = TemporaryFileEntryRepository.class.getName();
    private final PortalCapabilityLocator _portalCapabilityLocator;
    private final RepositoryFactory _repositoryFactory;

    public static BiFunction<PortalCapabilityLocator, RepositoryFactory, RepositoryDefiner> getFactoryBiFunction() {
        return TemporaryFileEntryRepositoryDefiner::new;
    }

    public TemporaryFileEntryRepositoryDefiner(PortalCapabilityLocator portalCapabilityLocator, RepositoryFactory repositoryFactory) {
        this._portalCapabilityLocator = portalCapabilityLocator;
        this._repositoryFactory = repositoryFactory;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public boolean isExternalRepository() {
        return false;
    }

    @Override
    public void registerCapabilities(CapabilityRegistry<DocumentRepository> capabilityRegistry) {
        if (this._portalCapabilityLocator == null) {
            ReflectionUtil.throwException(new UndeployedExternalRepositoryException(StringBundler.concat("Repository definer ", TemporaryFileEntryRepositoryDefiner.class.getName(), " is not initialized")));
        }
        DocumentRepository documentRepository = capabilityRegistry.getTarget();
        capabilityRegistry.addExportedCapability(BulkOperationCapability.class, this._portalCapabilityLocator.getBulkOperationCapability(documentRepository));
        capabilityRegistry.addExportedCapability(TemporaryFileEntriesCapability.class, this._portalCapabilityLocator.getTemporaryFileEntriesCapability(documentRepository));
        capabilityRegistry.addSupportedCapability(WorkflowCapability.class, this._portalCapabilityLocator.getWorkflowCapability(documentRepository, WorkflowCapability.OperationMode.MINIMAL));
    }

    @Override
    public void registerRepositoryFactory(RepositoryFactoryRegistry repositoryFactoryRegistry) {
        repositoryFactoryRegistry.setRepositoryFactory(this._repositoryFactory);
    }
}

