/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.portletrepository;

import com.liferay.portal.kernel.repository.DocumentRepository;
import com.liferay.portal.kernel.repository.RepositoryFactory;
import com.liferay.portal.kernel.repository.capabilities.PortalCapabilityLocator;
import com.liferay.portal.kernel.repository.capabilities.ProcessorCapability;
import com.liferay.portal.kernel.repository.capabilities.RelatedModelCapability;
import com.liferay.portal.kernel.repository.capabilities.TrashCapability;
import com.liferay.portal.kernel.repository.capabilities.WorkflowCapability;
import com.liferay.portal.kernel.repository.registry.BaseRepositoryDefiner;
import com.liferay.portal.kernel.repository.registry.CapabilityRegistry;
import com.liferay.portal.kernel.repository.registry.RepositoryDefiner;
import com.liferay.portal.kernel.repository.registry.RepositoryFactoryRegistry;
import com.liferay.portal.repository.portletrepository.PortletRepository;
import java.util.function.BiFunction;

public class PortletRepositoryDefiner
extends BaseRepositoryDefiner {
    private final PortalCapabilityLocator _portalCapabilityLocator;
    private final RepositoryFactory _repositoryFactory;

    public static BiFunction<PortalCapabilityLocator, RepositoryFactory, RepositoryDefiner> getFactoryBiFunction() {
        return PortletRepositoryDefiner::new;
    }

    public PortletRepositoryDefiner(PortalCapabilityLocator portalCapabilityLocator, RepositoryFactory repositoryFactory) {
        this._portalCapabilityLocator = portalCapabilityLocator;
        this._repositoryFactory = repositoryFactory;
    }

    @Override
    public String getClassName() {
        return PortletRepository.class.getName();
    }

    @Override
    public boolean isExternalRepository() {
        return false;
    }

    @Override
    public void registerCapabilities(CapabilityRegistry<DocumentRepository> capabilityRegistry) {
        DocumentRepository documentRepository = capabilityRegistry.getTarget();
        capabilityRegistry.addExportedCapability(RelatedModelCapability.class, this._portalCapabilityLocator.getRelatedModelCapability(documentRepository));
        capabilityRegistry.addExportedCapability(TrashCapability.class, this._portalCapabilityLocator.getTrashCapability(documentRepository));
        capabilityRegistry.addExportedCapability(WorkflowCapability.class, this._portalCapabilityLocator.getWorkflowCapability(documentRepository, WorkflowCapability.OperationMode.MINIMAL));
        capabilityRegistry.addSupportedCapability(ProcessorCapability.class, this._portalCapabilityLocator.getProcessorCapability(documentRepository, ProcessorCapability.ResourceGenerationStrategy.REUSE));
    }

    @Override
    public void registerRepositoryFactory(RepositoryFactoryRegistry repositoryFactoryRegistry) {
        repositoryFactoryRegistry.setRepositoryFactory(this._repositoryFactory);
    }
}

