/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.liferayrepository.model;

import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.service.DLAppHelperLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLFileEntryLocalServiceUtil;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.RepositoryModelOperation;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayModel;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

public class LiferayFileVersion
extends LiferayModel
implements FileVersion {
    private static final Log _log = LogFactoryUtil.getLog(LiferayFileVersion.class);
    private final DLFileVersion _dlFileVersion;
    private final boolean _escapedModel;

    public LiferayFileVersion(DLFileVersion dlFileVersion) {
        this(dlFileVersion, dlFileVersion.isEscapedModel());
    }

    public LiferayFileVersion(DLFileVersion dlFileVersion, boolean escapedModel) {
        this._dlFileVersion = dlFileVersion;
        this._escapedModel = escapedModel;
    }

    @Override
    public Object clone() {
        return new LiferayFileVersion(this._dlFileVersion);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LiferayFileVersion)) {
            return false;
        }
        LiferayFileVersion liferayFileVersion = (LiferayFileVersion)obj;
        return Objects.equals(this._dlFileVersion, liferayFileVersion._dlFileVersion);
    }

    @Override
    public void execute(RepositoryModelOperation repositoryModelOperation) throws PortalException {
        repositoryModelOperation.execute(this);
    }

    @Override
    public Map<String, Serializable> getAttributes() {
        ExpandoBridge expandoBridge = this._dlFileVersion.getExpandoBridge();
        return expandoBridge.getAttributes();
    }

    @Override
    public String getChangeLog() {
        return this._dlFileVersion.getChangeLog();
    }

    @Override
    public long getCompanyId() {
        return this._dlFileVersion.getCompanyId();
    }

    @Override
    public InputStream getContentStream(boolean incrementCounter) throws PortalException {
        InputStream inputStream = this._dlFileVersion.getContentStream(incrementCounter);
        try {
            DLAppHelperLocalServiceUtil.getFileAsStream(PrincipalThreadLocal.getUserId(), this.getFileEntry(), incrementCounter);
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        return inputStream;
    }

    @Override
    public Date getCreateDate() {
        return this._dlFileVersion.getCreateDate();
    }

    @Override
    public String getDescription() {
        return this._dlFileVersion.getDescription();
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return this._dlFileVersion.getExpandoBridge();
    }

    @Override
    public String getExtension() {
        return this._dlFileVersion.getExtension();
    }

    @Override
    public String getExtraSettings() {
        return this._dlFileVersion.getExtraSettings();
    }

    public File getFile(boolean incrementCounter) throws PortalException {
        return DLFileEntryLocalServiceUtil.getFile(this._dlFileVersion.getFileEntryId(), this._dlFileVersion.getVersion(), incrementCounter);
    }

    @Override
    public FileEntry getFileEntry() throws PortalException {
        return new LiferayFileEntry(this._dlFileVersion.getFileEntry());
    }

    @Override
    public long getFileEntryId() {
        return this._dlFileVersion.getFileEntryId();
    }

    @Override
    public String getFileName() {
        return this._dlFileVersion.getFileName();
    }

    @Override
    public long getFileVersionId() {
        return this._dlFileVersion.getFileVersionId();
    }

    @Override
    public long getGroupId() {
        return this._dlFileVersion.getGroupId();
    }

    @Override
    public String getIcon() {
        return this._dlFileVersion.getIcon();
    }

    @Override
    public Date getLastPublishDate() {
        return this._dlFileVersion.getLastPublishDate();
    }

    @Override
    public String getMimeType() {
        return this._dlFileVersion.getMimeType();
    }

    @Override
    public Object getModel() {
        return this._dlFileVersion;
    }

    @Override
    public Class<?> getModelClass() {
        return LiferayFileVersion.class;
    }

    @Override
    public String getModelClassName() {
        return LiferayFileVersion.class.getName();
    }

    @Override
    public Date getModifiedDate() {
        return this._dlFileVersion.getModifiedDate();
    }

    @Override
    public long getPrimaryKey() {
        return this._dlFileVersion.getPrimaryKey();
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return Long.valueOf(this.getPrimaryKey());
    }

    @Override
    public long getRepositoryId() {
        return this._dlFileVersion.getRepositoryId();
    }

    @Override
    public long getSize() {
        return this._dlFileVersion.getSize();
    }

    @Override
    public StagedModelType getStagedModelType() {
        return new StagedModelType(FileVersion.class);
    }

    @Override
    public int getStatus() {
        return this._dlFileVersion.getStatus();
    }

    @Override
    public long getStatusByUserId() {
        return this._dlFileVersion.getStatusByUserId();
    }

    @Override
    public String getStatusByUserName() {
        return this._dlFileVersion.getStatusByUserName();
    }

    @Override
    public String getStatusByUserUuid() {
        return this._dlFileVersion.getStatusByUserUuid();
    }

    @Override
    public Date getStatusDate() {
        return this._dlFileVersion.getStatusDate();
    }

    @Override
    public String getTitle() {
        return this._dlFileVersion.getTitle();
    }

    @Override
    public long getUserId() {
        return this._dlFileVersion.getUserId();
    }

    @Override
    public String getUserName() {
        return this._dlFileVersion.getUserName();
    }

    @Override
    public String getUserUuid() {
        return this._dlFileVersion.getUserUuid();
    }

    @Override
    public String getUuid() {
        return this._dlFileVersion.getUuid();
    }

    @Override
    public String getVersion() {
        return this._dlFileVersion.getVersion();
    }

    public int hashCode() {
        return this._dlFileVersion.hashCode();
    }

    @Override
    public boolean isApproved() {
        return this._dlFileVersion.isApproved();
    }

    @Override
    public boolean isDefaultRepository() {
        return this._dlFileVersion.getGroupId() == this._dlFileVersion.getRepositoryId();
    }

    @Override
    public boolean isDraft() {
        return this._dlFileVersion.isDraft();
    }

    @Override
    public boolean isEscapedModel() {
        return this._escapedModel;
    }

    @Override
    public boolean isExpired() {
        return this._dlFileVersion.isExpired();
    }

    @Override
    public boolean isPending() {
        return this._dlFileVersion.isPending();
    }

    @Override
    public void setCompanyId(long companyId) {
        this._dlFileVersion.setCompanyId(companyId);
    }

    @Override
    public void setCreateDate(Date createDate) {
        this._dlFileVersion.setCreateDate(createDate);
    }

    @Override
    public void setGroupId(long groupId) {
        this._dlFileVersion.setGroupId(groupId);
    }

    @Override
    public void setLastPublishDate(Date lastPublishDate) {
        this._dlFileVersion.setLastPublishDate(lastPublishDate);
    }

    @Override
    public void setModifiedDate(Date modifiedDate) {
    }

    public void setPrimaryKey(long primaryKey) {
        this._dlFileVersion.setPrimaryKey(primaryKey);
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        this.setPrimaryKey((Long)primaryKeyObj);
    }

    @Override
    public void setUserId(long userId) {
        this._dlFileVersion.setUserId(userId);
    }

    @Override
    public void setUserName(String userName) {
        this._dlFileVersion.setUserName(userName);
    }

    @Override
    public void setUserUuid(String userUuid) {
        this._dlFileVersion.setUserUuid(userUuid);
    }

    @Override
    public void setUuid(String uuid) {
        this._dlFileVersion.setUuid(uuid);
    }

    @Override
    public FileVersion toEscapedModel() {
        if (this.isEscapedModel()) {
            return this;
        }
        return new LiferayFileVersion((DLFileVersion)this._dlFileVersion.toEscapedModel(), true);
    }

    public String toString() {
        return this._dlFileVersion.toString();
    }

    @Override
    public FileVersion toUnescapedModel() {
        if (this.isEscapedModel()) {
            return new LiferayFileVersion((DLFileVersion)this._dlFileVersion.toUnescapedModel(), true);
        }
        return this;
    }
}

