/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.liferayrepository.model;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.service.DLAppHelperLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLFileVersionLocalServiceUtil;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryProviderUtil;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryModelOperation;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portal.repository.liferayrepository.model.LiferayModel;
import com.liferay.portlet.documentlibrary.util.RepositoryModelUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LiferayFileEntry
extends LiferayModel
implements FileEntry {
    private static final Log _log = LogFactoryUtil.getLog(LiferayFileEntry.class);
    private static volatile ModelResourcePermission<DLFileEntry> _dlFileEntryModelResourcePermission = ServiceProxyFactory.newServiceTrackedInstance(ModelResourcePermission.class, LiferayFileEntry.class, "_dlFileEntryModelResourcePermission", "(model.class.name=" + DLFileEntry.class.getName() + ")", true);
    private final DLFileEntry _dlFileEntry;
    private DLFileVersion _dlFileVersion;
    private final boolean _escapedModel;

    public LiferayFileEntry(DLFileEntry dlFileEntry) {
        this(dlFileEntry, dlFileEntry.isEscapedModel());
    }

    public LiferayFileEntry(DLFileEntry fileEntry, boolean escapedModel) {
        this._dlFileEntry = fileEntry;
        this._escapedModel = escapedModel;
    }

    @Override
    public Object clone() {
        return new LiferayFileEntry(this._dlFileEntry);
    }

    @Override
    public boolean containsPermission(PermissionChecker permissionChecker, String actionId) throws PortalException {
        return _dlFileEntryModelResourcePermission.contains(permissionChecker, this._dlFileEntry, actionId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LiferayFileEntry)) {
            return false;
        }
        LiferayFileEntry liferayFileEntry = (LiferayFileEntry)obj;
        return Objects.equals(this._dlFileEntry, liferayFileEntry._dlFileEntry);
    }

    @Override
    public void execute(RepositoryModelOperation repositoryModelOperation) throws PortalException {
        repositoryModelOperation.execute(this);
    }

    @Override
    public Map<String, Serializable> getAttributes() {
        ExpandoBridge expandoBridge = this.getExpandoBridge();
        return expandoBridge.getAttributes();
    }

    public FileVersion getCachedFileVersion() {
        if (this._dlFileVersion == null) {
            return null;
        }
        return new LiferayFileVersion(this._dlFileVersion);
    }

    @Override
    public long getCompanyId() {
        return this._dlFileEntry.getCompanyId();
    }

    @Override
    public InputStream getContentStream() throws PortalException {
        InputStream inputStream = this._dlFileEntry.getContentStream();
        try {
            DLAppHelperLocalServiceUtil.getFileAsStream(PrincipalThreadLocal.getUserId(), this, true);
        }
        catch (Exception e) {
            _log.error("Unable to get content stream", e);
        }
        return inputStream;
    }

    @Override
    public InputStream getContentStream(String version) throws PortalException {
        InputStream inputStream = this._dlFileEntry.getContentStream(version);
        try {
            DLAppHelperLocalServiceUtil.getFileAsStream(PrincipalThreadLocal.getUserId(), this, true);
        }
        catch (Exception e) {
            _log.error("Error getting document stream", e);
        }
        return inputStream;
    }

    @Override
    public Date getCreateDate() {
        return this._dlFileEntry.getCreateDate();
    }

    @Override
    public String getDescription() {
        return this._dlFileEntry.getDescription();
    }

    public DLFileEntry getDLFileEntry() {
        return this._dlFileEntry;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return this._dlFileEntry.getExpandoBridge();
    }

    @Override
    public String getExtension() {
        return this._dlFileEntry.getExtension();
    }

    @Override
    public long getFileEntryId() {
        return this._dlFileEntry.getFileEntryId();
    }

    @Override
    public String getFileName() {
        return this._dlFileEntry.getFileName();
    }

    @Override
    public List<FileShortcut> getFileShortcuts() {
        return RepositoryModelUtil.toFileShortcuts(this._dlFileEntry.getFileShortcuts());
    }

    @Override
    public FileVersion getFileVersion() throws PortalException {
        DLFileVersion dlFileVersion = this._dlFileVersion;
        if (dlFileVersion == null) {
            dlFileVersion = this._dlFileEntry.getFileVersion();
        }
        return new LiferayFileVersion(dlFileVersion);
    }

    @Override
    public FileVersion getFileVersion(String version) throws PortalException {
        return new LiferayFileVersion(this._dlFileEntry.getFileVersion(version));
    }

    @Override
    public List<FileVersion> getFileVersions(int status) {
        return RepositoryModelUtil.toFileVersions(this._dlFileEntry.getFileVersions(status));
    }

    @Override
    public int getFileVersionsCount(int status) {
        return this._dlFileEntry.getFileVersionsCount(status);
    }

    @Override
    public Folder getFolder() {
        try {
            return new LiferayFolder(this._dlFileEntry.getFolder());
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug(e, e);
            }
            return null;
        }
    }

    @Override
    public long getFolderId() {
        return this._dlFileEntry.getFolderId();
    }

    @Override
    public long getGroupId() {
        return this._dlFileEntry.getGroupId();
    }

    @Override
    public String getIcon() {
        return this._dlFileEntry.getIcon();
    }

    @Override
    public String getIconCssClass() {
        return this._dlFileEntry.getIconCssClass();
    }

    @Override
    public Date getLastPublishDate() {
        return this._dlFileEntry.getLastPublishDate();
    }

    @Override
    public FileVersion getLatestFileVersion() throws PortalException {
        return this.getLatestFileVersion(false);
    }

    @Override
    public FileVersion getLatestFileVersion(boolean trusted) throws PortalException {
        return new LiferayFileVersion(this._dlFileEntry.getLatestFileVersion(trusted));
    }

    @Override
    public Lock getLock() {
        return this._dlFileEntry.getLock();
    }

    @Override
    public String getMimeType() {
        return this._dlFileEntry.getMimeType();
    }

    @Override
    public String getMimeType(String version) {
        try {
            DLFileVersion dlFileVersion = DLFileVersionLocalServiceUtil.getFileVersion(this._dlFileEntry.getFileEntryId(), version);
            return dlFileVersion.getMimeType();
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug(e, e);
            }
            return "application/octet-stream";
        }
    }

    @Override
    public Object getModel() {
        return this._dlFileEntry;
    }

    @Override
    public Class<?> getModelClass() {
        return LiferayFileEntry.class;
    }

    @Override
    public String getModelClassName() {
        return LiferayFileEntry.class.getName();
    }

    @Override
    public Date getModifiedDate() {
        return this._dlFileEntry.getModifiedDate();
    }

    @Override
    public long getPrimaryKey() {
        return this._dlFileEntry.getPrimaryKey();
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return Long.valueOf(this.getPrimaryKey());
    }

    @Override
    public int getReadCount() {
        return this._dlFileEntry.getReadCount();
    }

    @Override
    public <T extends Capability> T getRepositoryCapability(Class<T> capabilityClass) {
        Repository repository = this.getRepository();
        return repository.getCapability(capabilityClass);
    }

    @Override
    public long getRepositoryId() {
        return this._dlFileEntry.getRepositoryId();
    }

    @Override
    public long getSize() {
        return this._dlFileEntry.getSize();
    }

    @Override
    public StagedModelType getStagedModelType() {
        return new StagedModelType(DLFileEntryConstants.getClassName());
    }

    @Override
    public String getTitle() {
        return this._dlFileEntry.getTitle();
    }

    @Override
    public long getUserId() {
        return this._dlFileEntry.getUserId();
    }

    @Override
    public String getUserName() {
        return this._dlFileEntry.getUserName();
    }

    @Override
    public String getUserUuid() {
        return this._dlFileEntry.getUserUuid();
    }

    @Override
    public String getUuid() {
        return this._dlFileEntry.getUuid();
    }

    @Override
    public String getVersion() {
        return this._dlFileEntry.getVersion();
    }

    @Override
    @Deprecated
    public long getVersionUserId() {
        long versionUserId = 0L;
        try {
            DLFileVersion dlFileVersion = this._dlFileEntry.getFileVersion();
            versionUserId = dlFileVersion.getUserId();
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        return versionUserId;
    }

    @Override
    @Deprecated
    public String getVersionUserName() {
        String versionUserName = "";
        try {
            DLFileVersion dlFileVersion = this._dlFileEntry.getFileVersion();
            versionUserName = dlFileVersion.getUserName();
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        return versionUserName;
    }

    @Override
    @Deprecated
    public String getVersionUserUuid() {
        String versionUserUuid = "";
        try {
            DLFileVersion dlFileVersion = this._dlFileEntry.getFileVersion();
            versionUserUuid = dlFileVersion.getUserUuid();
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        return versionUserUuid;
    }

    public int hashCode() {
        return this._dlFileEntry.hashCode();
    }

    @Override
    public boolean hasLock() {
        return this._dlFileEntry.hasLock();
    }

    @Override
    public boolean isCheckedOut() {
        return this._dlFileEntry.isCheckedOut();
    }

    @Override
    public boolean isDefaultRepository() {
        return this._dlFileEntry.getGroupId() == this._dlFileEntry.getRepositoryId();
    }

    @Override
    public boolean isEscapedModel() {
        return this._escapedModel;
    }

    @Override
    public boolean isInTrash() {
        return this._dlFileEntry.isInTrash();
    }

    @Override
    public boolean isInTrashContainer() {
        try {
            return this._dlFileEntry.isInTrashContainer();
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug(e, e);
            }
            return false;
        }
    }

    @Override
    public boolean isManualCheckInRequired() {
        return this._dlFileEntry.isManualCheckInRequired();
    }

    @Override
    public <T extends Capability> boolean isRepositoryCapabilityProvided(Class<T> capabilityClass) {
        Repository repository = this.getRepository();
        return repository.isCapabilityProvided(capabilityClass);
    }

    @Override
    public boolean isSupportsLocking() {
        return true;
    }

    @Override
    public boolean isSupportsMetadata() {
        return true;
    }

    @Override
    public boolean isSupportsSocial() {
        return true;
    }

    public void setCachedFileVersion(FileVersion fileVersion) {
        this._dlFileVersion = (DLFileVersion)fileVersion.getModel();
    }

    @Override
    public void setCompanyId(long companyId) {
        this._dlFileEntry.setCompanyId(companyId);
    }

    @Override
    public void setCreateDate(Date createDate) {
        this._dlFileEntry.setCreateDate(createDate);
    }

    @Override
    public void setGroupId(long groupId) {
        this._dlFileEntry.setGroupId(groupId);
    }

    @Override
    public void setLastPublishDate(Date lastPublishDate) {
        this._dlFileEntry.setLastPublishDate(lastPublishDate);
    }

    @Override
    public void setModifiedDate(Date modifiedDate) {
        this._dlFileEntry.setModifiedDate(modifiedDate);
    }

    public void setPrimaryKey(long primaryKey) {
        this._dlFileEntry.setPrimaryKey(primaryKey);
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        this.setPrimaryKey((Long)primaryKeyObj);
    }

    @Override
    public void setUserId(long userId) {
        this._dlFileEntry.setUserId(userId);
    }

    @Override
    public void setUserName(String userName) {
        this._dlFileEntry.setUserName(userName);
    }

    @Override
    public void setUserUuid(String userUuid) {
        this._dlFileEntry.setUserUuid(userUuid);
    }

    @Override
    public void setUuid(String uuid) {
        this._dlFileEntry.setUuid(uuid);
    }

    @Override
    public FileEntry toEscapedModel() {
        if (this.isEscapedModel()) {
            return this;
        }
        return new LiferayFileEntry((DLFileEntry)this._dlFileEntry.toEscapedModel(), true);
    }

    public String toString() {
        return this._dlFileEntry.toString();
    }

    @Override
    public FileEntry toUnescapedModel() {
        if (this.isEscapedModel()) {
            return new LiferayFileEntry((DLFileEntry)this._dlFileEntry.toUnescapedModel(), true);
        }
        return this;
    }

    protected Repository getRepository() {
        try {
            return RepositoryProviderUtil.getRepository(this.getRepositoryId());
        }
        catch (PortalException pe) {
            throw new SystemException("Unable to get repository for file entry " + this.getFileEntryId(), pe);
        }
    }
}

