/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.liferayrepository;

import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.document.library.kernel.service.DLAppHelperLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.repository.capabilities.WorkflowSupport;
import com.liferay.portal.repository.util.LocalRepositoryWrapper;
import java.io.File;
import java.io.InputStream;

public class LiferayWorkflowLocalRepositoryWrapper
extends LocalRepositoryWrapper {
    private final WorkflowSupport _workflowSupport;

    public LiferayWorkflowLocalRepositoryWrapper(LocalRepository localRepository, WorkflowSupport workflowSupport) {
        super(localRepository);
        this._workflowSupport = workflowSupport;
    }

    @Override
    public FileEntry addFileEntry(long userId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, File file, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry = super.addFileEntry(userId, folderId, sourceFileName, mimeType, title, description, changeLog, file, serviceContext);
        DLAppHelperLocalServiceUtil.updateAsset(userId, fileEntry, fileEntry.getFileVersion(), serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        this._workflowSupport.addFileEntry(userId, fileEntry, serviceContext);
        return fileEntry;
    }

    @Override
    public FileEntry addFileEntry(long userId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry = super.addFileEntry(userId, folderId, sourceFileName, mimeType, title, description, changeLog, is, size, serviceContext);
        DLAppHelperLocalServiceUtil.updateAsset(userId, fileEntry, fileEntry.getFileVersion(), serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        this._workflowSupport.addFileEntry(userId, fileEntry, serviceContext);
        return fileEntry;
    }

    @Override
    public void checkInFileEntry(long userId, long fileEntryId, DLVersionNumberIncrease dlVersionNumberIncrease, String changeLog, ServiceContext serviceContext) throws PortalException {
        super.checkInFileEntry(userId, fileEntryId, dlVersionNumberIncrease, changeLog, serviceContext);
        FileEntry fileEntry = super.getFileEntry(fileEntryId);
        this._workflowSupport.checkInFileEntry(userId, fileEntry, dlVersionNumberIncrease, serviceContext);
    }

    @Override
    public void checkInFileEntry(long userId, long fileEntryId, String lockUuid, ServiceContext serviceContext) throws PortalException {
        super.checkInFileEntry(userId, fileEntryId, lockUuid, serviceContext);
        FileEntry fileEntry = super.getFileEntry(fileEntryId);
        this._workflowSupport.checkInFileEntry(userId, fileEntry, DLVersionNumberIncrease.MINOR, serviceContext);
    }

    @Override
    public FileEntry copyFileEntry(long userId, long groupId, long fileEntryId, long destFolderId, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry = super.copyFileEntry(userId, groupId, fileEntryId, destFolderId, serviceContext);
        DLAppHelperLocalServiceUtil.updateAsset(userId, fileEntry, fileEntry.getFileVersion(), serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        this._workflowSupport.addFileEntry(userId, fileEntry, serviceContext);
        return fileEntry;
    }

    @Override
    public void revertFileEntry(long userId, long fileEntryId, String version, ServiceContext serviceContext) throws PortalException {
        super.revertFileEntry(userId, fileEntryId, version, serviceContext);
        FileEntry fileEntry = super.getFileEntry(fileEntryId);
        this._workflowSupport.revertFileEntry(userId, fileEntry, serviceContext);
    }

    @Override
    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, File file, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry = super.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, dlVersionNumberIncrease, file, serviceContext);
        this._workflowSupport.updateFileEntry(userId, fileEntry, dlVersionNumberIncrease, serviceContext);
        return super.getFileEntry(fileEntryId);
    }

    @Override
    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry = super.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, dlVersionNumberIncrease, is, size, serviceContext);
        this._workflowSupport.updateFileEntry(userId, fileEntry, dlVersionNumberIncrease, serviceContext);
        return super.getFileEntry(fileEntryId);
    }
}

