/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.liferayrepository;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.document.library.kernel.service.DLAppHelperLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryService;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService;
import com.liferay.document.library.kernel.service.DLFileShortcutLocalService;
import com.liferay.document.library.kernel.service.DLFileShortcutService;
import com.liferay.document.library.kernel.service.DLFileVersionLocalService;
import com.liferay.document.library.kernel.service.DLFileVersionService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.document.library.kernel.service.DLFolderService;
import com.liferay.dynamic.data.mapping.kernel.DDMFormValues;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryEntry;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.IndexSearcherHelperUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.RepositoryLocalService;
import com.liferay.portal.kernel.service.RepositoryService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.SortedArrayList;
import com.liferay.portal.repository.liferayrepository.LiferayRepositoryBase;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileShortcut;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portlet.documentlibrary.util.DLSearcher;
import com.liferay.portlet.documentlibrary.util.RepositoryModelUtil;
import com.liferay.portlet.documentlibrary.util.comparator.DLFileEntryOrderByComparator;
import com.liferay.portlet.documentlibrary.util.comparator.DLFolderOrderByComparator;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;

public class LiferayRepository
extends LiferayRepositoryBase
implements Repository {
    public LiferayRepository(RepositoryLocalService repositoryLocalService, RepositoryService repositoryService, DLAppHelperLocalService dlAppHelperLocalService, DLFileEntryLocalService dlFileEntryLocalService, DLFileEntryService dlFileEntryService, DLFileEntryTypeLocalService dlFileEntryTypeLocalService, DLFileShortcutLocalService dlFileShortcutLocalService, DLFileShortcutService dlFileShortcutService, DLFileVersionLocalService dlFileVersionLocalService, DLFileVersionService dlFileVersionService, DLFolderLocalService dlFolderLocalService, DLFolderService dlFolderService, ResourceLocalService resourceLocalService, long groupId, long repositoryId, long dlFolderId) {
        super(repositoryLocalService, repositoryService, dlAppHelperLocalService, dlFileEntryLocalService, dlFileEntryService, dlFileEntryTypeLocalService, dlFileShortcutLocalService, dlFileShortcutService, dlFileVersionLocalService, dlFileVersionService, dlFolderLocalService, dlFolderService, resourceLocalService, groupId, repositoryId, dlFolderId);
    }

    @Override
    public FileEntry addFileEntry(long userId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, File file, ServiceContext serviceContext) throws PortalException {
        long fileEntryTypeId = ParamUtil.getLong(serviceContext, "fileEntryTypeId", this.getDefaultFileEntryTypeId(serviceContext, folderId));
        HashMap<String, DDMFormValues> ddmFormValuesMap = this.getDDMFormValuesMap(serviceContext, fileEntryTypeId);
        long size = 0L;
        if (file != null) {
            size = file.length();
        }
        DLFileEntry dlFileEntry = this.dlFileEntryService.addFileEntry(this.getGroupId(), this.getRepositoryId(), this.toFolderId(folderId), sourceFileName, mimeType, title, description, changeLog, fileEntryTypeId, ddmFormValuesMap, file, null, size, serviceContext);
        return new LiferayFileEntry(dlFileEntry);
    }

    @Override
    public FileEntry addFileEntry(long userId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        long fileEntryTypeId = ParamUtil.getLong(serviceContext, "fileEntryTypeId", this.getDefaultFileEntryTypeId(serviceContext, folderId));
        HashMap<String, DDMFormValues> ddmFormValuesMap = this.getDDMFormValuesMap(serviceContext, fileEntryTypeId);
        DLFileEntry dlFileEntry = this.dlFileEntryService.addFileEntry(this.getGroupId(), this.getRepositoryId(), this.toFolderId(folderId), sourceFileName, mimeType, title, description, changeLog, fileEntryTypeId, ddmFormValuesMap, null, is, size, serviceContext);
        return new LiferayFileEntry(dlFileEntry);
    }

    @Override
    public FileShortcut addFileShortcut(long userId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        DLFileShortcut dlFileShortcut = this.dlFileShortcutService.addFileShortcut(this.getGroupId(), this.getRepositoryId(), folderId, toFileEntryId, serviceContext);
        return new LiferayFileShortcut(dlFileShortcut);
    }

    @Override
    public Folder addFolder(long userId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        boolean mountPoint = ParamUtil.getBoolean(serviceContext, "mountPoint");
        DLFolder dlFolder = this.dlFolderService.addFolder(this.getGroupId(), this.getRepositoryId(), mountPoint, this.toFolderId(parentFolderId), name, description, serviceContext);
        return new LiferayFolder(dlFolder);
    }

    @Override
    public FileVersion cancelCheckOut(long fileEntryId) throws PortalException {
        DLFileVersion dlFileVersion = this.dlFileEntryService.cancelCheckOut(fileEntryId);
        if (dlFileVersion != null) {
            return new LiferayFileVersion(dlFileVersion);
        }
        return null;
    }

    @Override
    @Deprecated
    public void checkInFileEntry(long userId, long fileEntryId, boolean majorVersion, String changeLog, ServiceContext serviceContext) throws PortalException {
        this.checkInFileEntry(userId, fileEntryId, DLVersionNumberIncrease.fromMajorVersion(majorVersion), changeLog, serviceContext);
    }

    @Override
    public void checkInFileEntry(long userId, long fileEntryId, DLVersionNumberIncrease dlVersionNumberIncrease, String changeLog, ServiceContext serviceContext) throws PortalException {
        this.dlFileEntryService.checkInFileEntry(fileEntryId, dlVersionNumberIncrease, changeLog, serviceContext);
    }

    @Override
    public void checkInFileEntry(long userId, long fileEntryId, String lockUuid, ServiceContext serviceContext) throws PortalException {
        this.dlFileEntryService.checkInFileEntry(fileEntryId, lockUuid, serviceContext);
    }

    @Override
    public FileEntry checkOutFileEntry(long fileEntryId, ServiceContext serviceContext) throws PortalException {
        DLFileEntry dlFileEntry = this.dlFileEntryService.checkOutFileEntry(fileEntryId, serviceContext);
        return new LiferayFileEntry(dlFileEntry);
    }

    @Override
    public FileEntry checkOutFileEntry(long fileEntryId, String owner, long expirationTime, ServiceContext serviceContext) throws PortalException {
        DLFileEntry dlFileEntry = this.dlFileEntryService.checkOutFileEntry(fileEntryId, owner, expirationTime, serviceContext);
        return new LiferayFileEntry(dlFileEntry);
    }

    @Override
    public FileEntry copyFileEntry(long userId, long groupId, long fileEntryId, long destFolderId, ServiceContext serviceContext) throws PortalException {
        DLFileEntry dlFileEntry = this.dlFileEntryService.copyFileEntry(groupId, this.getRepositoryId(), fileEntryId, destFolderId, serviceContext);
        return new LiferayFileEntry(dlFileEntry);
    }

    @Override
    public void deleteAll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteFileEntry(long fileEntryId) throws PortalException {
        this.dlFileEntryService.deleteFileEntry(fileEntryId);
    }

    @Override
    public void deleteFileEntry(long folderId, String title) throws PortalException {
        this.dlFileEntryService.deleteFileEntry(this.getGroupId(), this.toFolderId(folderId), title);
    }

    @Override
    public void deleteFileShortcut(long fileShortcutId) throws PortalException {
        this.dlFileShortcutService.deleteFileShortcut(fileShortcutId);
    }

    @Override
    public void deleteFileShortcuts(long toFileEntryId) throws PortalException {
        this.dlFileShortcutService.deleteFileShortcut(toFileEntryId);
    }

    @Override
    public void deleteFileVersion(long fileVersionId) throws PortalException {
        this.dlFileVersionLocalService.deleteDLFileVersion(fileVersionId);
    }

    @Override
    public void deleteFileVersion(long fileEntryId, String version) throws PortalException {
        this.dlFileEntryService.deleteFileVersion(fileEntryId, version);
    }

    @Override
    public void deleteFolder(long folderId) throws PortalException {
        this.dlFolderService.deleteFolder(folderId);
    }

    @Override
    public void deleteFolder(long parentFolderId, String name) throws PortalException {
        this.dlFolderService.deleteFolder(this.getGroupId(), this.toFolderId(parentFolderId), name);
    }

    @Override
    public List<FileEntry> getFileEntries(long folderId, int status, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        List<DLFileEntry> dlFileEntries = this.dlFileEntryService.getFileEntries(this.getGroupId(), this.toFolderId(folderId), status, start, end, DLFileEntryOrderByComparator.getOrderByComparator(obc));
        return RepositoryModelUtil.toFileEntries(dlFileEntries);
    }

    @Override
    public List<FileEntry> getFileEntries(long folderId, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        List<DLFileEntry> dlFileEntries = this.dlFileEntryService.getFileEntries(this.getGroupId(), this.toFolderId(folderId), start, end, DLFileEntryOrderByComparator.getOrderByComparator(obc));
        return RepositoryModelUtil.toFileEntries(dlFileEntries);
    }

    @Override
    public List<FileEntry> getFileEntries(long folderId, long fileEntryTypeId, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        List<DLFileEntry> dlFileEntries = this.dlFileEntryService.getFileEntries(this.getGroupId(), this.toFolderId(folderId), fileEntryTypeId, start, end, DLFileEntryOrderByComparator.getOrderByComparator(obc));
        return RepositoryModelUtil.toFileEntries(dlFileEntries);
    }

    @Override
    public List<FileEntry> getFileEntries(long folderId, String[] mimeTypes, int status, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        List<DLFileEntry> dlFileEntries = this.dlFileEntryService.getFileEntries(this.getGroupId(), this.toFolderId(folderId), mimeTypes, status, start, end, DLFileEntryOrderByComparator.getOrderByComparator(obc));
        return RepositoryModelUtil.toFileEntries(dlFileEntries);
    }

    @Override
    public List<FileEntry> getFileEntries(long folderId, String[] mimeTypes, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        List<DLFileEntry> dlFileEntries = this.dlFileEntryService.getFileEntries(this.getGroupId(), this.toFolderId(folderId), mimeTypes, start, end, DLFileEntryOrderByComparator.getOrderByComparator(obc));
        return RepositoryModelUtil.toFileEntries(dlFileEntries);
    }

    @Override
    public List<RepositoryEntry> getFileEntriesAndFileShortcuts(long folderId, int status, int start, int end) throws PortalException {
        List<Object> dlFileEntriesAndFileShortcuts = this.dlFolderService.getFileEntriesAndFileShortcuts(this.getGroupId(), this.toFolderId(folderId), status, start, end);
        return RepositoryModelUtil.toRepositoryEntries(dlFileEntriesAndFileShortcuts);
    }

    @Override
    public int getFileEntriesAndFileShortcutsCount(long folderId, int status) throws PortalException {
        return this.dlFolderService.getFileEntriesAndFileShortcutsCount(this.getGroupId(), this.toFolderId(folderId), status);
    }

    @Override
    public int getFileEntriesAndFileShortcutsCount(long folderId, int status, String[] mimeTypes) throws PortalException {
        return this.dlFolderService.getFileEntriesAndFileShortcutsCount(this.getGroupId(), this.toFolderId(folderId), status, mimeTypes);
    }

    @Override
    public int getFileEntriesCount(long folderId) {
        return this.dlFileEntryService.getFileEntriesCount(this.getGroupId(), this.toFolderId(folderId));
    }

    @Override
    public int getFileEntriesCount(long folderId, int status) {
        return this.dlFileEntryService.getFileEntriesCount(this.getGroupId(), this.toFolderId(folderId), status);
    }

    @Override
    public int getFileEntriesCount(long folderId, long fileEntryTypeId) {
        return this.dlFileEntryService.getFileEntriesCount(this.getGroupId(), this.toFolderId(folderId), fileEntryTypeId);
    }

    @Override
    public int getFileEntriesCount(long folderId, String[] mimeTypes) {
        return this.dlFileEntryService.getFileEntriesCount(this.getGroupId(), folderId, mimeTypes);
    }

    @Override
    public int getFileEntriesCount(long folderId, String[] mimeTypes, int status) throws PortalException {
        return this.dlFileEntryService.getFileEntriesCount(this.getGroupId(), this.toFolderId(folderId), mimeTypes, status);
    }

    @Override
    public FileEntry getFileEntry(long fileEntryId) throws PortalException {
        DLFileEntry dlFileEntry = this.dlFileEntryService.getFileEntry(fileEntryId);
        return new LiferayFileEntry(dlFileEntry);
    }

    @Override
    public FileEntry getFileEntry(long folderId, String title) throws PortalException {
        DLFileEntry dlFileEntry = this.dlFileEntryService.getFileEntry(this.getGroupId(), this.toFolderId(folderId), title);
        return new LiferayFileEntry(dlFileEntry);
    }

    @Override
    public FileEntry getFileEntryByUuid(String uuid) throws PortalException {
        DLFileEntry dlFileEntry = this.dlFileEntryService.getFileEntryByUuidAndGroupId(uuid, this.getGroupId());
        return new LiferayFileEntry(dlFileEntry);
    }

    public Lock getFileEntryLock(long fileEntryId) {
        return this.dlFileEntryService.getFileEntryLock(fileEntryId);
    }

    @Override
    public FileShortcut getFileShortcut(long fileShortcutId) throws PortalException {
        DLFileShortcut dlFileShortcut = this.dlFileShortcutService.getFileShortcut(fileShortcutId);
        return new LiferayFileShortcut(dlFileShortcut);
    }

    @Override
    public FileVersion getFileVersion(long fileVersionId) throws PortalException {
        DLFileVersion dlFileVersion = this.dlFileVersionService.getFileVersion(fileVersionId);
        return new LiferayFileVersion(dlFileVersion);
    }

    @Override
    public Folder getFolder(long folderId) throws PortalException {
        DLFolder dlFolder = this.dlFolderService.getFolder(this.toFolderId(folderId));
        return new LiferayFolder(dlFolder);
    }

    @Override
    public Folder getFolder(long parentFolderId, String name) throws PortalException {
        DLFolder dlFolder = this.dlFolderService.getFolder(this.getGroupId(), this.toFolderId(parentFolderId), name);
        return new LiferayFolder(dlFolder);
    }

    @Override
    public List<Folder> getFolders(long parentFolderId, boolean includeMountfolders, int start, int end, OrderByComparator<Folder> obc) throws PortalException {
        return this.getFolders(parentFolderId, 0, includeMountfolders, start, end, obc);
    }

    @Override
    public List<Folder> getFolders(long parentFolderId, int status, boolean includeMountfolders, int start, int end, OrderByComparator<Folder> obc) throws PortalException {
        List<DLFolder> dlFolders = this.dlFolderService.getFolders(this.getGroupId(), this.toFolderId(parentFolderId), status, includeMountfolders, start, end, DLFolderOrderByComparator.getOrderByComparator(obc));
        return RepositoryModelUtil.toFolders(dlFolders);
    }

    @Override
    public List<RepositoryEntry> getFoldersAndFileEntriesAndFileShortcuts(long folderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator<?> obc) throws PortalException {
        List<Object> dlFoldersAndDLFileEntriesAndDLFileShortcuts = this.dlFolderService.getFoldersAndFileEntriesAndFileShortcuts(this.getGroupId(), this.toFolderId(folderId), status, includeMountFolders, start, end, obc);
        return RepositoryModelUtil.toRepositoryEntries(dlFoldersAndDLFileEntriesAndDLFileShortcuts);
    }

    @Override
    public List<RepositoryEntry> getFoldersAndFileEntriesAndFileShortcuts(long folderId, int status, String[] mimeTypes, boolean includeMountFolders, boolean includeOwner, int start, int end, OrderByComparator<?> obc) throws PortalException {
        long userId = 0L;
        if (includeOwner) {
            userId = PrincipalThreadLocal.getUserId();
        }
        QueryDefinition queryDefinition = new QueryDefinition(status, userId, includeOwner, start, end, obc);
        List<Object> dlFoldersAndDLFileEntriesAndDLFileShortcuts = this.dlFolderService.getFoldersAndFileEntriesAndFileShortcuts(this.getGroupId(), this.toFolderId(folderId), mimeTypes, includeMountFolders, queryDefinition);
        return RepositoryModelUtil.toRepositoryEntries(dlFoldersAndDLFileEntriesAndDLFileShortcuts);
    }

    @Override
    public List<RepositoryEntry> getFoldersAndFileEntriesAndFileShortcuts(long folderId, int status, String[] mimeTypes, boolean includeMountFolders, int start, int end, OrderByComparator<?> obc) throws PortalException {
        return this.getFoldersAndFileEntriesAndFileShortcuts(folderId, status, mimeTypes, includeMountFolders, true, start, end, obc);
    }

    @Override
    public int getFoldersAndFileEntriesAndFileShortcutsCount(long folderId, int status, boolean includeMountFolders) throws PortalException {
        return this.dlFolderService.getFoldersAndFileEntriesAndFileShortcutsCount(this.getGroupId(), this.toFolderId(folderId), status, includeMountFolders);
    }

    @Override
    public int getFoldersAndFileEntriesAndFileShortcutsCount(long folderId, int status, String[] mimeTypes, boolean includeMountFolders) throws PortalException {
        return this.getFoldersAndFileEntriesAndFileShortcutsCount(folderId, status, mimeTypes, includeMountFolders, true);
    }

    @Override
    public int getFoldersAndFileEntriesAndFileShortcutsCount(long folderId, int status, String[] mimeTypes, boolean includeMountFolders, boolean includeOwner) throws PortalException {
        long userId = 0L;
        if (includeOwner) {
            userId = PrincipalThreadLocal.getUserId();
        }
        QueryDefinition queryDefinition = new QueryDefinition(status, userId, includeOwner);
        return this.dlFolderService.getFoldersAndFileEntriesAndFileShortcutsCount(this.getGroupId(), this.toFolderId(folderId), mimeTypes, includeMountFolders, queryDefinition);
    }

    @Override
    public int getFoldersCount(long parentFolderId, boolean includeMountfolders) throws PortalException {
        return this.getFoldersCount(parentFolderId, 0, includeMountfolders);
    }

    @Override
    public int getFoldersCount(long parentFolderId, int status, boolean includeMountfolders) throws PortalException {
        return this.dlFolderService.getFoldersCount(this.getGroupId(), this.toFolderId(parentFolderId), status, includeMountfolders);
    }

    @Override
    public int getFoldersFileEntriesCount(List<Long> folderIds, int status) {
        return this.dlFileEntryService.getFoldersFileEntriesCount(this.getGroupId(), this.toFolderIds(folderIds), status);
    }

    @Override
    public List<Folder> getMountFolders(long parentFolderId, int start, int end, OrderByComparator<Folder> obc) throws PortalException {
        List<DLFolder> dlFolders = this.dlFolderService.getMountFolders(this.getGroupId(), this.toFolderId(parentFolderId), start, end, DLFolderOrderByComparator.getOrderByComparator(obc));
        return RepositoryModelUtil.toFolders(dlFolders);
    }

    @Override
    public int getMountFoldersCount(long parentFolderId) throws PortalException {
        return this.dlFolderService.getMountFoldersCount(this.getGroupId(), this.toFolderId(parentFolderId));
    }

    @Override
    public List<FileEntry> getRepositoryFileEntries(long userId, long rootFolderId, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        List<DLFileEntry> dlFileEntries = this.dlFileEntryService.getGroupFileEntries(this.getGroupId(), userId, this.toFolderId(rootFolderId), start, end, DLFileEntryOrderByComparator.getOrderByComparator(obc));
        return RepositoryModelUtil.toFileEntries(dlFileEntries);
    }

    @Override
    public List<FileEntry> getRepositoryFileEntries(long userId, long rootFolderId, String[] mimeTypes, int status, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        List<DLFileEntry> dlFileEntries = this.dlFileEntryService.getGroupFileEntries(this.getGroupId(), userId, this.getRepositoryId(), this.toFolderId(rootFolderId), mimeTypes, status, start, end, DLFileEntryOrderByComparator.getOrderByComparator(obc));
        return RepositoryModelUtil.toFileEntries(dlFileEntries);
    }

    @Override
    public int getRepositoryFileEntriesCount(long userId, long rootFolderId) throws PortalException {
        return this.dlFileEntryService.getGroupFileEntriesCount(this.getGroupId(), userId, this.toFolderId(rootFolderId));
    }

    @Override
    public int getRepositoryFileEntriesCount(long userId, long rootFolderId, String[] mimeTypes, int status) throws PortalException {
        return this.dlFileEntryService.getGroupFileEntriesCount(this.getGroupId(), userId, this.getRepositoryId(), this.toFolderId(rootFolderId), mimeTypes, status);
    }

    @Override
    public void getSubfolderIds(List<Long> folderIds, long folderId) throws PortalException {
        this.dlFolderService.getSubfolderIds(folderIds, this.getGroupId(), this.toFolderId(folderId), true);
    }

    @Override
    public List<Long> getSubfolderIds(long folderId, boolean recurse) throws PortalException {
        return this.dlFolderService.getSubfolderIds(this.getGroupId(), this.toFolderId(folderId), recurse);
    }

    @Override
    public Lock lockFolder(long folderId) throws PortalException {
        return this.dlFolderService.lockFolder(this.toFolderId(folderId));
    }

    @Override
    public Lock lockFolder(long folderId, String owner, boolean inheritable, long expirationTime) throws PortalException {
        return this.dlFolderService.lockFolder(this.toFolderId(folderId), owner, inheritable, expirationTime);
    }

    @Override
    public FileEntry moveFileEntry(long userId, long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        DLFileEntry dlFileEntry = this.dlFileEntryService.moveFileEntry(fileEntryId, this.toFolderId(newFolderId), serviceContext);
        return new LiferayFileEntry(dlFileEntry);
    }

    @Override
    public Folder moveFolder(long userId, long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        DLFolder dlFolder = this.dlFolderService.moveFolder(this.toFolderId(folderId), this.toFolderId(parentFolderId), serviceContext);
        return new LiferayFolder(dlFolder);
    }

    @Override
    public Lock refreshFileEntryLock(String lockUuid, long companyId, long expirationTime) throws PortalException {
        return this.dlFileEntryService.refreshFileEntryLock(lockUuid, companyId, expirationTime);
    }

    @Override
    public Lock refreshFolderLock(String lockUuid, long companyId, long expirationTime) throws PortalException {
        return this.dlFolderService.refreshFolderLock(lockUuid, companyId, expirationTime);
    }

    @Override
    public void revertFileEntry(long userId, long fileEntryId, String version, ServiceContext serviceContext) throws PortalException {
        this.dlFileEntryService.revertFileEntry(fileEntryId, version, serviceContext);
    }

    @Override
    public Hits search(long creatorUserId, int status, int start, int end) throws PortalException {
        return this.dlFileEntryService.search(this.getGroupId(), creatorUserId, status, start, end);
    }

    @Override
    public Hits search(long creatorUserId, long folderId, String[] mimeTypes, int status, int start, int end) throws PortalException {
        return this.dlFileEntryService.search(this.getGroupId(), creatorUserId, this.toFolderId(folderId), mimeTypes, status, start, end);
    }

    @Override
    public Hits search(SearchContext searchContext) throws SearchException {
        Indexer<Object> indexer = null;
        indexer = searchContext.isIncludeFolders() ? DLSearcher.getInstance() : IndexerRegistryUtil.getIndexer(DLFileEntry.class);
        searchContext.setSearchEngineId(indexer.getSearchEngineId());
        return indexer.search(searchContext);
    }

    @Override
    public Hits search(SearchContext searchContext, Query query) throws SearchException {
        return IndexSearcherHelperUtil.search(searchContext, query);
    }

    @Override
    public void unlockFolder(long folderId, String lockUuid) throws PortalException {
        this.dlFolderService.unlockFolder(this.toFolderId(folderId), lockUuid);
    }

    @Override
    public void unlockFolder(long parentFolderId, String name, String lockUuid) throws PortalException {
        this.dlFolderService.unlockFolder(this.getGroupId(), this.toFolderId(parentFolderId), name, lockUuid);
    }

    @Override
    @Deprecated
    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, File file, ServiceContext serviceContext) throws PortalException {
        return this.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, DLVersionNumberIncrease.fromMajorVersion(majorVersion), file, serviceContext);
    }

    @Override
    @Deprecated
    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        return this.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, DLVersionNumberIncrease.fromMajorVersion(majorVersion), is, size, serviceContext);
    }

    @Override
    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, File file, ServiceContext serviceContext) throws PortalException {
        long fileEntryTypeId = ParamUtil.getLong(serviceContext, "fileEntryTypeId", -1L);
        HashMap<String, DDMFormValues> ddmFormValuesMap = this.getDDMFormValuesMap(serviceContext, fileEntryTypeId);
        long size = 0L;
        if (file != null) {
            size = file.length();
        }
        DLFileEntry dlFileEntry = this.dlFileEntryService.updateFileEntry(fileEntryId, sourceFileName, mimeType, title, description, changeLog, dlVersionNumberIncrease, fileEntryTypeId, ddmFormValuesMap, file, null, size, serviceContext);
        return new LiferayFileEntry(dlFileEntry);
    }

    @Override
    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        long fileEntryTypeId = ParamUtil.getLong(serviceContext, "fileEntryTypeId", -1L);
        HashMap<String, DDMFormValues> ddmFormValuesMap = this.getDDMFormValuesMap(serviceContext, fileEntryTypeId);
        DLFileEntry dlFileEntry = this.dlFileEntryService.updateFileEntry(fileEntryId, sourceFileName, mimeType, title, description, changeLog, dlVersionNumberIncrease, fileEntryTypeId, ddmFormValuesMap, null, is, size, serviceContext);
        return new LiferayFileEntry(dlFileEntry);
    }

    @Override
    public FileShortcut updateFileShortcut(long userId, long fileShortcutId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        DLFileShortcut dlFileShortcut = this.dlFileShortcutService.updateFileShortcut(fileShortcutId, this.getRepositoryId(), folderId, toFileEntryId, serviceContext);
        return new LiferayFileShortcut(dlFileShortcut);
    }

    @Override
    public void updateFileShortcuts(long oldToFileEntryId, long newToFileEntryId) throws PortalException {
        this.dlFileShortcutService.updateFileShortcuts(oldToFileEntryId, newToFileEntryId);
    }

    @Override
    public Folder updateFolder(long folderId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        long defaultFileEntryTypeId = ParamUtil.getLong(serviceContext, "defaultFileEntryTypeId");
        SortedArrayList<Long> fileEntryTypeIds = this.getLongList(serviceContext, "dlFileEntryTypesSearchContainerPrimaryKeys");
        int restrictionType = ParamUtil.getInteger(serviceContext, "restrictionType");
        DLFolder dlFolder = this.dlFolderService.updateFolder(this.toFolderId(folderId), this.toFolderId(parentFolderId), name, description, defaultFileEntryTypeId, fileEntryTypeIds, restrictionType, serviceContext);
        return new LiferayFolder(dlFolder);
    }

    @Override
    public Folder updateFolder(long folderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        long defaultFileEntryTypeId = ParamUtil.getLong(serviceContext, "defaultFileEntryTypeId");
        SortedArrayList<Long> fileEntryTypeIds = this.getLongList(serviceContext, "dlFileEntryTypesSearchContainerPrimaryKeys");
        int restrictionType = ParamUtil.getInteger(serviceContext, "restrictionType");
        DLFolder dlFolder = this.dlFolderService.updateFolder(this.toFolderId(folderId), name, description, defaultFileEntryTypeId, fileEntryTypeIds, restrictionType, serviceContext);
        return new LiferayFolder(dlFolder);
    }

    @Override
    public boolean verifyFileEntryCheckOut(long fileEntryId, String lockUuid) throws PortalException {
        return this.dlFileEntryService.verifyFileEntryCheckOut(fileEntryId, lockUuid);
    }

    @Override
    public boolean verifyFileEntryLock(long fileEntryId, String lockUuid) throws PortalException {
        return this.dlFileEntryService.verifyFileEntryLock(fileEntryId, lockUuid);
    }

    @Override
    public boolean verifyInheritableLock(long folderId, String lockUuid) throws PortalException {
        return this.dlFolderLocalService.verifyInheritableLock(this.toFolderId(folderId), lockUuid);
    }
}

