/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.liferayrepository;

import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.capabilities.ProcessorCapability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.repository.util.LocalRepositoryWrapper;
import java.io.File;
import java.io.InputStream;

public class LiferayProcessorLocalRepositoryWrapper
extends LocalRepositoryWrapper {
    private final ProcessorCapability _processorCapability;

    public LiferayProcessorLocalRepositoryWrapper(LocalRepository localRepository, ProcessorCapability processorCapability) {
        super(localRepository);
        this._processorCapability = processorCapability;
    }

    @Override
    public FileEntry addFileEntry(long userId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, File file, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry = super.addFileEntry(userId, folderId, sourceFileName, mimeType, title, description, changeLog, file, serviceContext);
        this._processorCapability.generateNew(fileEntry);
        return fileEntry;
    }

    @Override
    public FileEntry addFileEntry(long userId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry = super.addFileEntry(userId, folderId, sourceFileName, mimeType, title, description, changeLog, is, size, serviceContext);
        this._processorCapability.generateNew(fileEntry);
        return fileEntry;
    }

    @Override
    public void checkInFileEntry(long userId, long fileEntryId, DLVersionNumberIncrease dlVersionNumberIncrease, String changeLog, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry = this.getFileEntry(fileEntryId);
        this._processorCapability.cleanUp(fileEntry.getLatestFileVersion(true));
        super.checkInFileEntry(userId, fileEntryId, dlVersionNumberIncrease, changeLog, serviceContext);
        this._processorCapability.copy(fileEntry, fileEntry.getFileVersion());
    }

    @Override
    public void checkInFileEntry(long userId, long fileEntryId, String lockUuid, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry = this.getFileEntry(fileEntryId);
        this._processorCapability.cleanUp(fileEntry.getLatestFileVersion(true));
        super.checkInFileEntry(userId, fileEntryId, lockUuid, serviceContext);
        this._processorCapability.copy(fileEntry, fileEntry.getFileVersion());
    }

    @Override
    public void revertFileEntry(long userId, long fileEntryId, String version, ServiceContext serviceContext) throws PortalException {
        super.revertFileEntry(userId, fileEntryId, version, serviceContext);
        FileEntry fileEntry = this.getFileEntry(fileEntryId);
        this._processorCapability.copy(fileEntry, fileEntry.getFileVersion(version));
    }

    @Override
    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, File file, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry = super.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, dlVersionNumberIncrease, file, serviceContext);
        this._processorCapability.cleanUp(fileEntry.getLatestFileVersion(true));
        this._processorCapability.generateNew(fileEntry);
        return fileEntry;
    }

    @Override
    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        FileVersion oldFileVersion = null;
        if (is == null) {
            FileEntry oldFileEntry = this.getFileEntry(fileEntryId);
            oldFileVersion = oldFileEntry.getLatestFileVersion(true);
        }
        FileEntry fileEntry = super.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, dlVersionNumberIncrease, is, size, serviceContext);
        if (is == null) {
            this._processorCapability.copy(fileEntry, oldFileVersion);
        } else {
            this._processorCapability.cleanUp(fileEntry.getLatestFileVersion(true));
            this._processorCapability.generateNew(fileEntry);
        }
        return fileEntry;
    }
}

