/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.reports.engine.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.reports.engine.ReportDesignRetriever;
import com.liferay.portal.reports.engine.ReportEngine;
import com.liferay.portal.reports.engine.ReportGenerationException;
import com.liferay.portal.reports.engine.ReportRequest;
import com.liferay.portal.reports.engine.ReportResultContainer;

public class ReportCompilerRequestMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(ReportCompilerRequestMessageListener.class);
    private ReportEngine _reportEngine;
    private ReportResultContainer _reportResultContainer;

    public ReportCompilerRequestMessageListener() {
    }

    public ReportCompilerRequestMessageListener(ReportEngine reportEngine, ReportResultContainer reportResultContainer) {
        this._reportEngine = reportEngine;
        this._reportResultContainer = reportResultContainer;
    }

    public void setReportEngine(ReportEngine reportEngine) {
        this._reportEngine = reportEngine;
    }

    public void setReportResultContainer(ReportResultContainer reportResultContainer) {
        this._reportResultContainer = reportResultContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doReceive(Message message) throws Exception {
        ReportRequest reportRequest = (ReportRequest)message.getPayload();
        ReportDesignRetriever reportDesignRetriever = reportRequest.getReportDesignRetriever();
        ReportResultContainer reportResultContainer = this._reportResultContainer.clone(reportDesignRetriever.getReportName());
        try {
            this._reportEngine.compile(reportRequest);
        }
        catch (ReportGenerationException rge) {
            _log.error("Unable to compile report", rge);
            reportResultContainer.setReportGenerationException(rge);
        }
        finally {
            Message responseMessage = MessageBusUtil.createResponseMessage(message, reportResultContainer);
            responseMessage.setPayload(reportResultContainer);
            MessageBusUtil.sendMessage(responseMessage.getDestinationName(), responseMessage);
        }
    }
}

