/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.remote.jaxrs.whiteboard.internal.log;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.cxf.common.logging.AbstractDelegatingLogger;

public class LiferayCXFLogger
extends AbstractDelegatingLogger {
    private static final Log _classLog = LogFactoryUtil.getLog(LiferayCXFLogger.class);
    private final Log _log;

    public LiferayCXFLogger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
        this._log = LogFactoryUtil.getLog(name);
    }

    @Override
    public Level getLevel() {
        return Level.ALL;
    }

    @Override
    protected void internalLogFormatted(String msg, LogRecord logRecord) {
        Level level = logRecord.getLevel();
        if (level == null) {
            this._logError(level, msg, logRecord);
            return;
        }
        if (level.equals(Level.CONFIG)) {
            if (this._log.isInfoEnabled()) {
                this._log.info(msg, logRecord.getThrown());
            }
        } else if (level.equals(Level.FINE)) {
            if (this._log.isDebugEnabled()) {
                this._log.debug(msg, logRecord.getThrown());
            }
        } else if (level.equals(Level.FINER)) {
            if (this._log.isDebugEnabled()) {
                this._log.debug(msg, logRecord.getThrown());
            }
        } else if (level.equals(Level.FINEST)) {
            if (this._log.isTraceEnabled()) {
                this._log.trace(msg, logRecord.getThrown());
            }
        } else if (level.equals(Level.INFO)) {
            if (this._log.isInfoEnabled()) {
                this._log.info(msg, logRecord.getThrown());
            }
        } else if (level.equals(Level.SEVERE)) {
            if (this._log.isErrorEnabled()) {
                this._log.error(msg, logRecord.getThrown());
            }
        } else if (level.equals(Level.WARNING)) {
            if (this._log.isWarnEnabled()) {
                this._log.warn(msg, logRecord.getThrown());
            }
        } else {
            this._logError(level, msg, logRecord);
        }
    }

    private void _logError(Level level, String msg, LogRecord logRecord) {
        if (!_classLog.isErrorEnabled()) {
            return;
        }
        if (level == null) {
            _classLog.error("Unable to map Log4j level: null");
        } else {
            _classLog.error("Unable to map Log4j level: " + level.getName());
        }
        _classLog.error("Original message: " + msg, logRecord.getThrown());
    }
}

