/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.remote.axis.extender.internal;

import com.liferay.osgi.util.BundleUtil;
import com.liferay.portal.kernel.bean.ClassLoaderBeanHandler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.servlet.filters.authverifier.AuthVerifierFilter;
import com.liferay.util.axis.AxisServlet;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(immediate=true, service={})
public class AxisExtender {
    private static final Log _log = LogFactoryUtil.getLog(AxisExtender.class);
    private BundleTracker<BundleRegistrationInfo> _bundleTracker;

    @Activate
    protected void activate(ComponentContext componentContext) {
        this._bundleTracker = new BundleTracker(componentContext.getBundleContext(), 32, (BundleTrackerCustomizer)new BundleRegistrationInfoBundleTrackerCustomizer());
        this._bundleTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._bundleTracker.close();
    }

    private class BundleRegistrationInfoBundleTrackerCustomizer
    implements BundleTrackerCustomizer<BundleRegistrationInfo> {
        private BundleRegistrationInfoBundleTrackerCustomizer() {
        }

        public BundleRegistrationInfo addingBundle(final Bundle bundle, BundleEvent bundleEvent) {
            Enumeration enumeration = bundle.findEntries("/WEB-INF", "server-config.wsdd", false);
            if (enumeration == null || !enumeration.hasMoreElements()) {
                return null;
            }
            BundleContext bundleContext = bundle.getBundleContext();
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("osgi.http.whiteboard.context.name", "liferay.axis." + bundle.getSymbolicName());
            ((Dictionary)properties).put("osgi.http.whiteboard.context.path", "/" + bundle.getSymbolicName());
            ServiceRegistration bundleServletContextHelperServiceRegistration = bundleContext.registerService(ServletContextHelper.class, (Object)new ServletContextHelper(bundle){

                public URL getResource(String name) {
                    if (name.startsWith("/")) {
                        name = name.substring(1);
                    }
                    return BundleUtil.getResourceInBundleOrFragments(bundle, name);
                }
            }, properties);
            properties = new Hashtable();
            ((Dictionary)properties).put("osgi.http.whiteboard.context.select", "liferay.axis." + bundle.getSymbolicName());
            ((Dictionary)properties).put("osgi.http.whiteboard.filter.name", AuthVerifierFilter.class.getName());
            ((Dictionary)properties).put("osgi.http.whiteboard.filter.pattern", "/api/axis/*");
            ServiceRegistration authVerifierFilterServiceRegistration = bundleContext.registerService(Filter.class, (Object)new AuthVerifierFilter(), properties);
            properties = new Hashtable();
            ((Dictionary)properties).put("osgi.http.whiteboard.context.select", "liferay.axis." + bundle.getSymbolicName());
            ((Dictionary)properties).put("osgi.http.whiteboard.servlet.name", AxisServlet.class.getName());
            ((Dictionary)properties).put("osgi.http.whiteboard.servlet.pattern", "/api/axis/*");
            ((Dictionary)properties).put("servlet.init.axis.servicesPath", "/api/axis/");
            ((Dictionary)properties).put("servlet.init.httpMethods", "GET,POST,HEAD");
            Bundle bundleContextBundle = bundleContext.getBundle();
            BundleWiring bundleContextBundleBundleWiring = (BundleWiring)bundleContextBundle.adapt(BundleWiring.class);
            BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            ClassLoader aggregateClassLoader = AggregateClassLoader.getAggregateClassLoader(bundleContextBundleBundleWiring.getClassLoader(), bundleWiring.getClassLoader());
            Servlet servlet = (Servlet)ProxyUtil.newProxyInstance(aggregateClassLoader, new Class[]{Servlet.class}, new ClassLoaderBeanHandler((Object)new AxisServlet(), aggregateClassLoader));
            ServiceRegistration axisServletServiceRegistration = bundleContext.registerService(Servlet.class, (Object)servlet, properties);
            return new BundleRegistrationInfo((ServiceRegistration<Filter>)authVerifierFilterServiceRegistration, (ServiceRegistration<Servlet>)axisServletServiceRegistration, (ServiceRegistration<ServletContextHelper>)bundleServletContextHelperServiceRegistration);
        }

        public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, BundleRegistrationInfo bundleRegistrationInfo) {
        }

        public void removedBundle(Bundle bundle, BundleEvent bundleEvent, BundleRegistrationInfo bundleRegistrationInfo) {
            ServiceRegistration<Servlet> axisServletServiceRegistration = bundleRegistrationInfo.getAxisServletServiceRegistration();
            try {
                axisServletServiceRegistration.unregister();
            }
            catch (Exception e) {
                _log.error(e, e);
            }
            ServiceRegistration<Filter> authVerifierFilterServiceRegistration = bundleRegistrationInfo.getAuthVerifierFilterServiceRegistration();
            try {
                authVerifierFilterServiceRegistration.unregister();
            }
            catch (Exception e) {
                _log.error(e, e);
            }
            ServiceRegistration<ServletContextHelper> bundleServletContextHelperServiceRegistration = bundleRegistrationInfo.getBundleServletContextHelperServiceRegistration();
            try {
                bundleServletContextHelperServiceRegistration.unregister();
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
    }

    private static class BundleRegistrationInfo {
        private final ServiceRegistration<Filter> _authVerifierFilterServiceRegistration;
        private final ServiceRegistration<Servlet> _axisServletServiceRegistration;
        private final ServiceRegistration<ServletContextHelper> _bundleServletContextHelperServiceRegistration;

        public BundleRegistrationInfo(ServiceRegistration<Filter> authVerifierFilterServiceRegistration, ServiceRegistration<Servlet> axisServletServiceRegistration, ServiceRegistration<ServletContextHelper> bundleServletContextServiceRegistration) {
            this._authVerifierFilterServiceRegistration = authVerifierFilterServiceRegistration;
            this._axisServletServiceRegistration = axisServletServiceRegistration;
            this._bundleServletContextHelperServiceRegistration = bundleServletContextServiceRegistration;
        }

        public ServiceRegistration<Filter> getAuthVerifierFilterServiceRegistration() {
            return this._authVerifierFilterServiceRegistration;
        }

        public ServiceRegistration<Servlet> getAxisServletServiceRegistration() {
            return this._axisServletServiceRegistration;
        }

        public ServiceRegistration<ServletContextHelper> getBundleServletContextHelperServiceRegistration() {
            return this._bundleServletContextHelperServiceRegistration;
        }
    }
}

