/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.portletfilerepository;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLTrashLocalServiceUtil;
import com.liferay.document.library.kernel.util.DLAppHelperThreadLocal;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.RepositoryProviderUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.RepositoryLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntryThreadLocal;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.repository.portletrepository.PortletRepository;
import com.liferay.trash.kernel.util.TrashUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;

public class PortletFileRepositoryImpl
implements PortletFileRepository {
    private static final Log _log = LogFactoryUtil.getLog(PortletFileRepositoryImpl.class);

    @Override
    public void addPortletFileEntries(long groupId, long userId, String className, long classPK, String portletId, long folderId, List<ObjectValuePair<String, InputStream>> inputStreamOVPs) throws PortalException {
        for (ObjectValuePair<String, InputStream> inputStreamOVP : inputStreamOVPs) {
            InputStream inputStream = inputStreamOVP.getValue();
            String fileName = inputStreamOVP.getKey();
            this.addPortletFileEntry(groupId, userId, className, classPK, portletId, folderId, inputStream, fileName, "", true);
        }
    }

    @Override
    public FileEntry addPortletFileEntry(long groupId, long userId, String className, long classPK, String portletId, long folderId, byte[] bytes, String fileName, String mimeType, boolean indexingEnabled) throws PortalException {
        if (bytes == null) {
            return null;
        }
        File file = null;
        try {
            file = FileUtil.createTempFile(bytes);
            FileEntry fileEntry = this.addPortletFileEntry(groupId, userId, className, classPK, portletId, folderId, file, fileName, mimeType, indexingEnabled);
            return fileEntry;
        }
        catch (IOException ioe) {
            throw new SystemException("Unable to write temporary file", ioe);
        }
        finally {
            FileUtil.delete(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileEntry addPortletFileEntry(long groupId, long userId, String className, long classPK, String portletId, long folderId, File file, String fileName, String mimeType, boolean indexingEnabled) throws PortalException {
        if (Validator.isNull(fileName)) {
            return null;
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        Repository repository = this.addPortletRepository(groupId, portletId, serviceContext);
        if (Validator.isNotNull(className) && classPK > 0L) {
            serviceContext.setAttribute("className", (Serializable)((Object)className));
            serviceContext.setAttribute("classPK", (Serializable)((Object)String.valueOf(classPK)));
        }
        serviceContext.setIndexingEnabled(indexingEnabled);
        if (Validator.isNull(mimeType) || mimeType.equals("application/octet-stream")) {
            mimeType = MimeTypesUtil.getContentType(file, fileName);
        }
        boolean dlAppHelperEnabled = DLAppHelperThreadLocal.isEnabled();
        try {
            DLAppHelperThreadLocal.setEnabled(false);
            LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository(repository.getRepositoryId());
            FileEntry fileEntry = localRepository.addFileEntry(userId, folderId, fileName, mimeType, fileName, "", "", file, serviceContext);
            return fileEntry;
        }
        finally {
            DLAppHelperThreadLocal.setEnabled(dlAppHelperEnabled);
        }
    }

    @Override
    public FileEntry addPortletFileEntry(long groupId, long userId, String className, long classPK, String portletId, long folderId, InputStream inputStream, String fileName, String mimeType, boolean indexingEnabled) throws PortalException {
        if (inputStream == null) {
            return null;
        }
        File file = null;
        try {
            file = FileUtil.createTempFile(inputStream);
            FileEntry fileEntry = this.addPortletFileEntry(groupId, userId, className, classPK, portletId, folderId, file, fileName, mimeType, indexingEnabled);
            return fileEntry;
        }
        catch (IOException ioe) {
            throw new SystemException("Unable to write temporary file", ioe);
        }
        finally {
            FileUtil.delete(file);
        }
    }

    @Override
    public Folder addPortletFolder(long userId, long repositoryId, long parentFolderId, String folderName, ServiceContext serviceContext) throws PortalException {
        return this._run(() -> {
            LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository(repositoryId);
            try {
                DLAppHelperThreadLocal.setEnabled(false);
                return localRepository.getFolder(parentFolderId, folderName);
            }
            catch (NoSuchFolderException nsfe) {
                if (_log.isDebugEnabled()) {
                    _log.debug(nsfe, nsfe);
                }
                return localRepository.addFolder(userId, parentFolderId, folderName, "", serviceContext);
            }
        });
    }

    @Override
    public Folder addPortletFolder(long groupId, long userId, String portletId, long parentFolderId, String folderName, ServiceContext serviceContext) throws PortalException {
        Repository repository = this.addPortletRepository(groupId, portletId, serviceContext);
        return this.addPortletFolder(userId, repository.getRepositoryId(), parentFolderId, folderName, serviceContext);
    }

    @Override
    public Repository addPortletRepository(long groupId, String portletId, ServiceContext serviceContext) throws PortalException {
        Repository repository = RepositoryLocalServiceUtil.fetchRepository(groupId, portletId);
        if (repository != null) {
            return repository;
        }
        Group group = GroupLocalServiceUtil.getGroup(groupId);
        User user = UserLocalServiceUtil.getDefaultUser(group.getCompanyId());
        long classNameId = PortalUtil.getClassNameId(PortletRepository.class.getName());
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        return this._run(() -> RepositoryLocalServiceUtil.addRepository(user.getUserId(), groupId, classNameId, 0L, portletId, "", portletId, typeSettingsProperties, true, serviceContext));
    }

    @Override
    public void deletePortletFileEntries(long groupId, long folderId) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository(groupId);
        List<FileEntry> fileEntries = localRepository.getFileEntries(folderId, -1, -1, null);
        for (FileEntry fileEntry : fileEntries) {
            this.deletePortletFileEntry(fileEntry.getFileEntryId());
        }
    }

    @Override
    public void deletePortletFileEntries(long groupId, long folderId, int status) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository(groupId);
        List<FileEntry> fileEntries = localRepository.getFileEntries(folderId, status, -1, -1, null);
        for (FileEntry fileEntry : fileEntries) {
            this.deletePortletFileEntry(fileEntry.getFileEntryId());
        }
    }

    @Override
    public void deletePortletFileEntry(long fileEntryId) throws PortalException {
        block4: {
            try {
                LocalRepository localRepository = RepositoryProviderUtil.getFileEntryLocalRepository(fileEntryId);
                FileEntry fileEntry = localRepository.getFileEntry(fileEntryId);
                if (this._isAttachment(fileEntry)) {
                    this._run(FileEntry.class, () -> {
                        localRepository.deleteFileEntry(fileEntryId);
                        return null;
                    });
                } else {
                    this._run(() -> {
                        localRepository.deleteFileEntry(fileEntryId);
                        return null;
                    });
                }
            }
            catch (NoSuchFileEntryException nsfee) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn(nsfee, nsfee);
            }
        }
    }

    @Override
    public void deletePortletFileEntry(long groupId, long folderId, String fileName) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository(groupId);
        FileEntry fileEntry = localRepository.getFileEntry(folderId, fileName);
        this.deletePortletFileEntry(fileEntry.getFileEntryId());
    }

    @Override
    public void deletePortletFolder(long folderId) throws PortalException {
        this._run(Folder.class, () -> {
            block2: {
                try {
                    LocalRepository localRepository = RepositoryProviderUtil.getFolderLocalRepository(folderId);
                    localRepository.deleteFolder(folderId);
                }
                catch (NoSuchFolderException nsfe) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn(nsfe, nsfe);
                }
            }
            return null;
        });
    }

    @Override
    public void deletePortletRepository(long groupId, String portletId) throws PortalException {
        Repository repository = RepositoryLocalServiceUtil.fetchRepository(groupId, portletId);
        if (repository != null) {
            RepositoryLocalServiceUtil.deleteRepository(repository.getRepositoryId());
        }
    }

    @Override
    public FileEntry fetchPortletFileEntry(long groupId, long folderId, String fileName) {
        try {
            return this.getPortletFileEntry(groupId, folderId, fileName);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug(pe, pe);
            }
            return null;
        }
    }

    @Override
    public Repository fetchPortletRepository(long groupId, String portletId) {
        return RepositoryLocalServiceUtil.fetchRepository(groupId, portletId);
    }

    @Override
    public String getDownloadPortletFileEntryURL(ThemeDisplay themeDisplay, FileEntry fileEntry, String queryString) {
        return this.getDownloadPortletFileEntryURL(themeDisplay, fileEntry, queryString, true);
    }

    @Override
    public String getDownloadPortletFileEntryURL(ThemeDisplay themeDisplay, FileEntry fileEntry, String queryString, boolean absoluteURL) {
        String portletFileEntryURL = this.getPortletFileEntryURL(themeDisplay, fileEntry, queryString, absoluteURL);
        return HttpUtil.addParameter(portletFileEntryURL, "download", true);
    }

    @Override
    public List<FileEntry> getPortletFileEntries(long groupId, long folderId) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository(groupId);
        return localRepository.getFileEntries(folderId, -1, -1, null);
    }

    @Override
    public List<FileEntry> getPortletFileEntries(long groupId, long folderId, int status) throws PortalException {
        return this.getPortletFileEntries(groupId, folderId, status, -1, -1, null);
    }

    @Override
    public List<FileEntry> getPortletFileEntries(long groupId, long folderId, int status, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository(groupId);
        return localRepository.getFileEntries(folderId, status, start, end, obc);
    }

    @Override
    public List<FileEntry> getPortletFileEntries(long groupId, long folderId, OrderByComparator<FileEntry> obc) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository(groupId);
        return localRepository.getFileEntries(folderId, -1, -1, obc);
    }

    @Override
    public List<FileEntry> getPortletFileEntries(long groupId, long folderId, String[] mimeTypes, int status, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository(groupId);
        return localRepository.getFileEntries(folderId, mimeTypes, status, start, end, obc);
    }

    @Override
    public int getPortletFileEntriesCount(long groupId, long folderId) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository(groupId);
        return localRepository.getFileEntriesCount(folderId);
    }

    @Override
    public int getPortletFileEntriesCount(long groupId, long folderId, int status) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository(groupId);
        return localRepository.getFileEntriesCount(folderId, status);
    }

    @Override
    public int getPortletFileEntriesCount(long groupId, long folderId, String[] mimeTypes, int status) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository(groupId);
        return localRepository.getFileEntriesCount(folderId, mimeTypes, status);
    }

    @Override
    public FileEntry getPortletFileEntry(long fileEntryId) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getFileEntryLocalRepository(fileEntryId);
        return localRepository.getFileEntry(fileEntryId);
    }

    @Override
    public FileEntry getPortletFileEntry(long groupId, long folderId, String fileName) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository(groupId);
        return localRepository.getFileEntry(folderId, fileName);
    }

    @Override
    public FileEntry getPortletFileEntry(String uuid, long groupId) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository(groupId);
        return localRepository.getFileEntryByUuid(uuid);
    }

    @Override
    public String getPortletFileEntryURL(ThemeDisplay themeDisplay, FileEntry fileEntry, String queryString) {
        return this.getPortletFileEntryURL(themeDisplay, fileEntry, queryString, true);
    }

    @Override
    public String getPortletFileEntryURL(ThemeDisplay themeDisplay, FileEntry fileEntry, String queryString, boolean absoluteURL) {
        StringBundler sb = new StringBundler(12);
        if (themeDisplay != null && absoluteURL) {
            sb.append(themeDisplay.getPortalURL());
        }
        sb.append(PortalUtil.getPathContext());
        sb.append("/documents/");
        sb.append("portlet_file_entry");
        sb.append("/");
        sb.append(fileEntry.getGroupId());
        sb.append("/");
        String fileName = fileEntry.getFileName();
        if (fileEntry.isInTrash()) {
            fileName = TrashUtil.getOriginalTitle(fileEntry.getTitle());
        }
        sb.append(URLCodec.encodeURL(HtmlUtil.unescape(fileName)));
        sb.append("/");
        sb.append(URLCodec.encodeURL(fileEntry.getUuid()));
        if (Validator.isNotNull(queryString)) {
            sb.append("?");
            if (queryString.startsWith("&")) {
                sb.append(queryString.substring(1));
            } else {
                sb.append(queryString);
            }
        }
        String portletFileEntryURL = sb.toString();
        if (themeDisplay != null && themeDisplay.isAddSessionIdToURL()) {
            return PortalUtil.getURLWithSessionId(portletFileEntryURL, themeDisplay.getSessionId());
        }
        return portletFileEntryURL;
    }

    @Override
    public Folder getPortletFolder(long folderId) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getFolderLocalRepository(folderId);
        return localRepository.getFolder(folderId);
    }

    @Override
    public Folder getPortletFolder(long repositoryId, long parentFolderId, String folderName) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository(repositoryId);
        return localRepository.getFolder(parentFolderId, folderName);
    }

    @Override
    public Repository getPortletRepository(long groupId, String portletId) throws PortalException {
        return RepositoryLocalServiceUtil.getRepository(groupId, portletId);
    }

    @Override
    public String getUniqueFileName(long groupId, long folderId, String fileName) {
        String uniqueFileName = fileName;
        int i = 1;
        while (true) {
            try {
                this.getPortletFileEntry(groupId, folderId, uniqueFileName);
                uniqueFileName = FileUtil.appendParentheticalSuffix(fileName, String.valueOf(i));
            }
            catch (Exception e) {
                break;
            }
            ++i;
        }
        return uniqueFileName;
    }

    @Override
    public FileEntry movePortletFileEntryToTrash(long userId, long fileEntryId) throws PortalException {
        return this._run(() -> {
            LocalRepository localRepository = RepositoryProviderUtil.getFileEntryLocalRepository(fileEntryId);
            return DLTrashLocalServiceUtil.moveFileEntryToTrash(userId, localRepository.getRepositoryId(), fileEntryId);
        });
    }

    @Override
    public FileEntry movePortletFileEntryToTrash(long groupId, long userId, long folderId, String fileName) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository(groupId);
        FileEntry fileEntry = localRepository.getFileEntry(folderId, fileName);
        return this.movePortletFileEntryToTrash(userId, fileEntry.getFileEntryId());
    }

    @Override
    public Folder movePortletFolder(long groupId, long userId, long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        return this._run(() -> {
            LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository(groupId);
            return localRepository.moveFolder(userId, folderId, parentFolderId, serviceContext);
        });
    }

    @Override
    public void restorePortletFileEntryFromTrash(long userId, long fileEntryId) throws PortalException {
        this._run(() -> {
            LocalRepository localRepository = RepositoryProviderUtil.getFileEntryLocalRepository(fileEntryId);
            DLTrashLocalServiceUtil.restoreFileEntryFromTrash(userId, localRepository.getRepositoryId(), fileEntryId);
            return null;
        });
    }

    @Override
    public void restorePortletFileEntryFromTrash(long groupId, long userId, long folderId, String fileName) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository(groupId);
        FileEntry fileEntry = localRepository.getFileEntry(folderId, fileName);
        this.restorePortletFileEntryFromTrash(userId, fileEntry.getFileEntryId());
    }

    @Override
    public Hits searchPortletFileEntries(long repositoryId, SearchContext searchContext) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = RepositoryProviderUtil.getRepository(repositoryId);
        return repository.search(searchContext);
    }

    private boolean _isAttachment(FileEntry fileEntry) {
        if (!(fileEntry.getModel() instanceof DLFileEntry)) {
            return false;
        }
        DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
        return dlFileEntry.getClassNameId() != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, E extends Throwable> T _run(Class<?> clazz, UnsafeSupplier<T, E> unsafeSupplier) throws E {
        boolean dlAppHelperEnabled = DLAppHelperThreadLocal.isEnabled();
        try {
            DLAppHelperThreadLocal.setEnabled(false);
            if (clazz != null) {
                SystemEventHierarchyEntryThreadLocal.push(clazz);
            }
            T t = unsafeSupplier.get();
            return t;
        }
        finally {
            if (clazz != null) {
                SystemEventHierarchyEntryThreadLocal.pop(clazz);
            }
            DLAppHelperThreadLocal.setEnabled(dlAppHelperEnabled);
        }
    }

    private <T, E extends Throwable> T _run(UnsafeSupplier<T, E> unsafeSupplier) throws E {
        return this._run(null, unsafeSupplier);
    }
}

