/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.poller.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.poller.PollerException;
import com.liferay.portal.kernel.poller.PollerProcessor;
import com.liferay.portal.kernel.poller.PollerRequest;
import com.liferay.portal.kernel.poller.PollerResponse;
import com.liferay.portal.poller.PollerProcessorUtil;

public class PollerRequestMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(PollerRequestMessageListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doReceive(Message message) throws Exception {
        PollerRequest pollerRequest = (PollerRequest)message.getPayload();
        String portletId = pollerRequest.getPortletId();
        PollerProcessor pollerProcessor = PollerProcessorUtil.getPollerProcessor(portletId);
        if (pollerRequest.isReceiveRequest()) {
            PollerResponse pollerResponse = null;
            try {
                pollerResponse = pollerProcessor.receive(pollerRequest);
            }
            catch (PollerException pe) {
                _log.error("Unable to receive poller request " + pollerRequest, pe);
                pollerResponse = pollerRequest.createPollerResponse();
                pollerResponse.setParameter("pollerException", pe.getMessage());
            }
            finally {
                if (pollerResponse == null) {
                    pollerResponse = pollerRequest.createPollerResponse();
                }
                pollerResponse.close(message, pollerRequest.getPollerHeader(), pollerRequest.getPortletId(), pollerRequest.getChunkId());
            }
        } else {
            try {
                pollerProcessor.send(pollerRequest);
            }
            catch (PollerException pe) {
                _log.error("Unable to send poller request " + pollerRequest, pe);
            }
        }
    }
}

