/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.poller.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.notifications.ChannelHubManagerUtil;
import com.liferay.portal.kernel.notifications.NotificationEvent;
import com.liferay.portal.kernel.notifications.NotificationEventFactoryUtil;
import com.liferay.portal.kernel.notifications.UnknownChannelException;
import com.liferay.portal.kernel.poller.PollerHeader;
import com.liferay.portal.kernel.poller.PollerResponse;

public class PollerNotificationsBridgeMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(PollerNotificationsBridgeMessageListener.class);

    @Override
    protected void doReceive(Message message) throws Exception {
        block5: {
            Object messagePayload = message.getPayload();
            if (!(messagePayload instanceof PollerResponse)) {
                if (_log.isWarnEnabled()) {
                    _log.warn("Received message with payload not of type PollerResponse");
                }
                return;
            }
            PollerResponse pollerResponse = (PollerResponse)messagePayload;
            if (pollerResponse.isEmpty()) {
                return;
            }
            PollerHeader pollerHeader = pollerResponse.getPollerHeader();
            NotificationEvent notificationEvent = NotificationEventFactoryUtil.createNotificationEvent(System.currentTimeMillis(), PollerNotificationsBridgeMessageListener.class.getName(), pollerResponse.toJSONObject());
            try {
                ChannelHubManagerUtil.sendNotificationEvent(pollerHeader.getCompanyId(), pollerHeader.getUserId(), notificationEvent);
            }
            catch (UnknownChannelException uce) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug("Unable to complete processing because user session ended", uce);
            }
        }
    }
}

