/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.poller.comet;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.notifications.ChannelHubManagerUtil;
import com.liferay.portal.kernel.notifications.ChannelListener;
import com.liferay.portal.kernel.notifications.UnknownChannelException;
import com.liferay.portal.kernel.poller.comet.BaseCometHandler;
import com.liferay.portal.kernel.poller.comet.CometHandler;
import com.liferay.portal.kernel.poller.comet.CometRequest;
import com.liferay.portal.kernel.poller.comet.CometSession;
import com.liferay.portal.poller.PollerRequestHandlerUtil;
import com.liferay.portal.poller.comet.PollerCometChannelListener;

public class PollerCometHandler
extends BaseCometHandler {
    private static final Log _log = LogFactoryUtil.getLog(PollerCometHandler.class);
    private ChannelListener _channelListener;
    private long _companyId;
    private long _userId;

    @Override
    public CometHandler clone() {
        return new PollerCometHandler();
    }

    @Override
    public void receiveData(String data) {
    }

    @Override
    protected void doDestroy() throws Exception {
        block3: {
            if (this._channelListener != null) {
                try {
                    ChannelHubManagerUtil.unregisterChannelListener(this._companyId, this._userId, this._channelListener);
                }
                catch (UnknownChannelException uce) {
                    if (!_log.isDebugEnabled()) break block3;
                    _log.debug(uce, uce);
                }
            }
        }
    }

    @Override
    protected void doInit(CometSession cometSession) throws Exception {
        CometRequest cometRequest = cometSession.getCometRequest();
        this._companyId = cometRequest.getCompanyId();
        this._userId = cometRequest.getUserId();
        String pollerRequestString = cometRequest.getParameter("pollerRequest");
        JSONObject pollerResponseHeaderJSONObject = PollerRequestHandlerUtil.processRequest(cometRequest.getRequest(), pollerRequestString);
        if (pollerResponseHeaderJSONObject != null) {
            this._channelListener = new PollerCometChannelListener(cometSession, pollerResponseHeaderJSONObject);
            try {
                ChannelHubManagerUtil.registerChannelListener(this._companyId, this._userId, this._channelListener);
            }
            catch (UnknownChannelException uce) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Terminating request for " + this._userId + " because user session ended", uce);
                }
                cometSession.close();
            }
        } else {
            cometSession.close();
        }
    }
}

