/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.poller.comet;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.notifications.ChannelHubManagerUtil;
import com.liferay.portal.kernel.notifications.NotificationEvent;
import com.liferay.portal.kernel.notifications.UnknownChannelException;
import com.liferay.portal.kernel.poller.comet.CometRequest;
import com.liferay.portal.kernel.poller.comet.CometResponse;
import com.liferay.portal.kernel.poller.comet.CometSession;
import java.util.List;

public class PollerCometDelayedTask {
    private static final Log _log = LogFactoryUtil.getLog(PollerCometDelayedTask.class);
    private final CometSession _cometSession;
    private final JSONObject _pollerResponseHeaderJSONObject;

    public PollerCometDelayedTask(CometSession cometSession, JSONObject pollerResponseHeaderJSONObject) {
        this._cometSession = cometSession;
        this._pollerResponseHeaderJSONObject = pollerResponseHeaderJSONObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask() throws Exception {
        CometRequest cometRequest = this._cometSession.getCometRequest();
        try {
            List<NotificationEvent> notificationEvents = ChannelHubManagerUtil.getNotificationEvents(cometRequest.getCompanyId(), cometRequest.getUserId(), false);
            JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
            if (this._pollerResponseHeaderJSONObject != null) {
                jsonArray.put(this._pollerResponseHeaderJSONObject);
            }
            for (NotificationEvent notificationEvent : notificationEvents) {
                jsonArray.put(notificationEvent.toJSONObject());
            }
            CometResponse cometResponse = this._cometSession.getCometResponse();
            cometResponse.writeData(jsonArray.toString());
            ChannelHubManagerUtil.removeTransientNotificationEvents(cometRequest.getCompanyId(), cometRequest.getUserId(), notificationEvents);
        }
        catch (UnknownChannelException uce) {
            if (_log.isDebugEnabled()) {
                _log.debug("Unable to complete processing because user session ended", uce);
            }
        }
        finally {
            this._cometSession.close();
        }
    }
}

