/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.poller.comet;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.notifications.ChannelException;
import com.liferay.portal.kernel.notifications.ChannelHubManagerUtil;
import com.liferay.portal.kernel.notifications.ChannelListener;
import com.liferay.portal.kernel.notifications.UnknownChannelException;
import com.liferay.portal.kernel.poller.comet.CometRequest;
import com.liferay.portal.kernel.poller.comet.CometSession;
import com.liferay.portal.poller.comet.PollerCometDelayedJobUtil;
import com.liferay.portal.poller.comet.PollerCometDelayedTask;

public class PollerCometChannelListener
implements ChannelListener {
    private static final Log _log = LogFactoryUtil.getLog(PollerCometChannelListener.class);
    private final CometSession _cometSession;
    private final JSONObject _pollerResponseHeaderJSONObject;

    public PollerCometChannelListener(CometSession cometSession, JSONObject pollerResponseHeaderJSONObject) {
        this._cometSession = cometSession;
        this._pollerResponseHeaderJSONObject = pollerResponseHeaderJSONObject;
    }

    @Override
    public void channelListenerRemoved(long channelId) {
    }

    @Override
    public void notificationEventsAvailable(long channelId) {
        this.sendProcessMessage();
    }

    protected void sendProcessMessage() {
        block4: {
            CometRequest cometRequest = this._cometSession.getCometRequest();
            try {
                ChannelHubManagerUtil.unregisterChannelListener(cometRequest.getCompanyId(), cometRequest.getUserId(), this);
            }
            catch (UnknownChannelException uce) {
                if (_log.isDebugEnabled()) {
                    _log.debug(uce, uce);
                }
            }
            catch (ChannelException ce) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn("Unable to unregister channel listener", ce);
            }
        }
        PollerCometDelayedTask pollerCometDelayedTask = new PollerCometDelayedTask(this._cometSession, this._pollerResponseHeaderJSONObject);
        PollerCometDelayedJobUtil.addPollerCometDelayedTask(pollerCometDelayedTask);
    }
}

