/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.poller;

import com.liferay.portal.kernel.poller.PollerRequest;
import java.util.HashMap;
import java.util.Map;

public class PollerSession {
    private final Map<String, String> _pendingResponseIds = new HashMap<String, String>();
    private final Map<String, PollerRequest> _pollerRequests = new HashMap<String, PollerRequest>();
    private final String _pollerSessionId;

    public PollerSession(String pollerSessionId) {
        this._pollerSessionId = pollerSessionId;
    }

    public synchronized boolean beginPortletProcessing(PollerRequest pollerRequest, String responseId) {
        String portletId = pollerRequest.getPortletId();
        if (this._pendingResponseIds.containsKey(portletId)) {
            return false;
        }
        this._pendingResponseIds.put(portletId, responseId);
        this._pollerRequests.put(portletId, pollerRequest);
        return true;
    }

    public synchronized boolean completePortletProcessing(String portletId, String responseId) {
        String pendingResponseId = this._pendingResponseIds.get(portletId);
        if (responseId.equals(pendingResponseId)) {
            this._pendingResponseIds.remove(portletId);
            this._pollerRequests.remove(portletId);
        }
        return this._pendingResponseIds.isEmpty();
    }

    public String getPollerSessionId() {
        return this._pollerSessionId;
    }
}

