/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.poller;

import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.notifications.ChannelException;
import com.liferay.portal.kernel.notifications.ChannelHubManagerUtil;
import com.liferay.portal.kernel.notifications.ChannelListener;
import com.liferay.portal.kernel.notifications.NotificationEvent;
import com.liferay.portal.kernel.poller.PollerHeader;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.poller.PollerRequestHandlerUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PollerServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(PollerServlet.class);

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            String content = this.getContent(httpServletRequest);
            if (content == null) {
                PortalUtil.sendError(404, (Exception)new NoSuchLayoutException(), httpServletRequest, httpServletResponse);
            } else {
                httpServletResponse.setContentType("text/plain; charset=UTF-8");
                ServletResponseUtil.write(httpServletResponse, content.getBytes("UTF-8"));
            }
        }
        catch (Exception e) {
            _log.error(e.getMessage());
            PortalUtil.sendError(500, e, httpServletRequest, httpServletResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getContent(HttpServletRequest httpServletRequest) throws Exception {
        long userId = PortalUtil.getUserId(httpServletRequest);
        if (userId == 0L) {
            return "";
        }
        String pollerRequestString = ParamUtil.getString(httpServletRequest, "pollerRequest");
        PollerHeader pollerHeader = PollerRequestHandlerUtil.getPollerHeader(pollerRequestString);
        if (pollerHeader == null) {
            return "";
        }
        if (userId != pollerHeader.getUserId()) {
            return "";
        }
        SynchronousPollerChannelListener synchronousPollerChannelListener = new SynchronousPollerChannelListener();
        long companyId = PortalUtil.getCompanyId(httpServletRequest);
        ChannelHubManagerUtil.getChannel(companyId, userId, true);
        ChannelHubManagerUtil.registerChannelListener(companyId, userId, synchronousPollerChannelListener);
        try {
            JSONObject pollerResponseHeaderJSONObject = PollerRequestHandlerUtil.processRequest(httpServletRequest, pollerRequestString);
            if (pollerResponseHeaderJSONObject == null) {
                String string = "";
                return string;
            }
            String string = synchronousPollerChannelListener.getNotificationEvents(companyId, userId, pollerResponseHeaderJSONObject, PropsValues.POLLER_REQUEST_TIMEOUT);
            return string;
        }
        finally {
            ChannelHubManagerUtil.unregisterChannelListener(companyId, userId, synchronousPollerChannelListener);
        }
    }

    private static class SynchronousPollerChannelListener
    implements ChannelListener {
        private final CountDownLatch _countDownLatch = new CountDownLatch(1);

        private SynchronousPollerChannelListener() {
        }

        @Override
        public void channelListenerRemoved(long channelId) {
            this._countDownLatch.countDown();
        }

        public String getNotificationEvents(long companyId, long userId, JSONObject pollerResponseHeaderJSONObject, long timeout) throws ChannelException {
            try {
                this._countDownLatch.await(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            List<NotificationEvent> notificationEvents = ChannelHubManagerUtil.fetchNotificationEvents(companyId, userId, true);
            JSONArray jsonArray = JSONUtil.put((Object)pollerResponseHeaderJSONObject);
            for (NotificationEvent notificationEvent : notificationEvents) {
                jsonArray.put(notificationEvent.toJSONObject());
            }
            return jsonArray.toString();
        }

        @Override
        public void notificationEventsAvailable(long channelId) {
            this._countDownLatch.countDown();
        }
    }
}

