/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.plugin;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.plugin.Version;
import java.io.Serializable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;

public class ModuleId
implements Serializable {
    private static final Map<String, ModuleId> _moduleIds = new ConcurrentHashMap<String, ModuleId>();
    private final String _artifactId;
    private final String _groupId;
    private final Version _pluginVersion;
    private final String _type;

    public static ModuleId getInstance(String moduleId) {
        ModuleId moduleIdObj = _moduleIds.get(moduleId);
        if (moduleIdObj == null) {
            moduleIdObj = new ModuleId(moduleId);
            _moduleIds.put(moduleId, moduleIdObj);
        }
        return moduleIdObj;
    }

    public static String toString(String groupId, String artifactId, String version, String type) {
        return StringBundler.concat(groupId, "/", artifactId, "/", version, "/", type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ModuleId)) {
            return false;
        }
        ModuleId moduleId = (ModuleId)obj;
        return this.toString().equals(moduleId.toString());
    }

    public String getArtifactId() {
        return this._artifactId;
    }

    public String getArtifactPath() {
        return StringBundler.concat("/", this._groupId, "/", this._artifactId, "/", this._pluginVersion, "/", this.getArtifactWARName());
    }

    public String getArtifactWARName() {
        return StringBundler.concat(this._artifactId, "-", this._pluginVersion, ".", this._type);
    }

    public String getGroupId() {
        return this._groupId;
    }

    public String getPackageId() {
        return this._groupId + "/" + this._artifactId;
    }

    public String getType() {
        return this._type;
    }

    public String getVersion() {
        return this._pluginVersion.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isLaterVersionThan(String version) {
        return this._pluginVersion.isLaterVersionThan(version);
    }

    public boolean isPreviousVersionThan(String version) {
        return this._pluginVersion.isPreviousVersionThan(version);
    }

    public boolean isSameVersionAs(String version) {
        return this._pluginVersion.isSameVersionAs(version);
    }

    public String toString() {
        return ModuleId.toString(this._groupId, this._artifactId, this._pluginVersion.toString(), this._type);
    }

    protected ModuleId(String moduleId) {
        StringTokenizer st = new StringTokenizer(moduleId, "/");
        if (st.countTokens() < 4) {
            throw new RuntimeException("The moduleId " + moduleId + " is not correct");
        }
        this._groupId = st.nextToken();
        this._artifactId = st.nextToken();
        this._pluginVersion = Version.getInstance(st.nextToken());
        this._type = st.nextToken();
    }

    protected ModuleId(String groupId, String artifactId, Version pluginVersion, String type) {
        this._groupId = groupId;
        this._artifactId = artifactId;
        this._pluginVersion = pluginVersion;
        this._type = type;
    }
}

