/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.patcher;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.patcher.PatchInconsistencyException;
import com.liferay.portal.kernel.patcher.Patcher;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;

public class PatcherImpl
implements Patcher {
    private static final Log _log = LogFactoryUtil.getLog(PatcherImpl.class);
    private boolean _configured;
    private final String[] _fixedIssueKeys;
    private boolean _inconsistentPatchLevels;
    private final String[] _installedPatchNames;
    private final int _patchingToolVersion;
    private final String _patchingToolVersionDisplayName;
    private final String[] _patchLevels;
    private final Properties _properties = this._getProperties("patcher.properties");
    private final boolean _separated;
    private final String _separationId;

    public PatcherImpl() {
        this._fixedIssueKeys = StringUtil.split(this._properties.getProperty("fixed.issues"));
        this._installedPatchNames = StringUtil.split(this._properties.getProperty("installed.patches"));
        this._patchLevels = StringUtil.split(this._properties.getProperty("patch.levels"));
        this._patchingToolVersion = GetterUtil.getInteger(this._properties.get("patching.tool.version"));
        this._patchingToolVersionDisplayName = this.getPatchingToolVersionDisplayName();
        this._separated = GetterUtil.getBoolean(this._properties.getProperty("separated"));
        this._separationId = this._properties.getProperty("separation.id");
    }

    @Override
    public boolean applyPatch(File patchFile) {
        File patchDirectory = this.getPatchDirectory();
        if (patchDirectory == null) {
            return false;
        }
        try {
            FileUtil.copyFile(patchFile, new File(patchDirectory + "/" + patchFile.getName()));
            return true;
        }
        catch (Exception e) {
            _log.error(StringBundler.concat("Unable to copy ", patchFile.getAbsolutePath(), " to ", patchDirectory.getAbsolutePath()));
            return false;
        }
    }

    @Override
    public String[] getFixedIssues() {
        return this._fixedIssueKeys;
    }

    @Override
    public String[] getInstalledPatches() {
        return this._installedPatchNames;
    }

    @Override
    public File getPatchDirectory() {
        String patchDirectoryName = this._properties.getProperty("patch.directory");
        File patchDirectory = null;
        if (Validator.isNotNull(patchDirectoryName)) {
            patchDirectory = new File(patchDirectoryName);
            if (!patchDirectory.exists()) {
                _log.error("The patch directory does not exist");
                this._configured = false;
            } else {
                this._configured = true;
            }
        } else {
            if (_log.isDebugEnabled()) {
                _log.debug("The patch directory is not specified");
            }
            this._configured = false;
        }
        return patchDirectory;
    }

    @Override
    public int getPatchingToolVersion() {
        return this._patchingToolVersion;
    }

    @Override
    public String getPatchingToolVersionDisplayName() {
        if (this._patchingToolVersionDisplayName != null) {
            return this._patchingToolVersionDisplayName;
        }
        String patchingToolVersionDisplayName = "1.0." + this.getPatchingToolVersion();
        if (this._properties.containsKey("patching.tool.version.display.name")) {
            patchingToolVersionDisplayName = this._properties.getProperty("patching.tool.version.display.name");
        }
        return patchingToolVersionDisplayName;
    }

    @Override
    public String[] getPatchLevels() {
        return this._patchLevels;
    }

    @Override
    public Properties getProperties() {
        return this._properties;
    }

    @Override
    public String getSeparationId() {
        return this._separationId;
    }

    @Override
    public boolean hasInconsistentPatchLevels() {
        return this._inconsistentPatchLevels;
    }

    @Override
    public boolean isConfigured() {
        this.getPatchDirectory();
        return this._configured;
    }

    @Override
    public boolean isSeparated() {
        return this._separated;
    }

    @Override
    public void verifyPatchLevels() throws PatchInconsistencyException {
        Properties portalKernelJARProperties = this._getProperties("patcher-service.properties");
        Object[] kernelJARPatches = this._getInstalledPatches(portalKernelJARProperties);
        Arrays.sort(kernelJARPatches);
        Properties portalImplJARProperties = this._getProperties("patcher.properties");
        Object[] portalImplJARPatches = this._getInstalledPatches(portalImplJARProperties);
        Arrays.sort(portalImplJARPatches);
        if (!Arrays.equals(portalImplJARPatches, kernelJARPatches)) {
            _log.error("Inconsistent patch level detected");
            if (_log.isWarnEnabled()) {
                if (ArrayUtil.isEmpty(portalImplJARPatches)) {
                    _log.warn("There are no patches installed on portal-impl.jar");
                } else {
                    _log.warn("Patch level on portal-impl.jar: " + Arrays.toString(portalImplJARPatches));
                }
                if (ArrayUtil.isEmpty(kernelJARPatches)) {
                    _log.warn("There are no patches installed on portal-kernel.jar");
                } else {
                    _log.warn("Patch level on portal-kernel.jar: " + Arrays.toString(kernelJARPatches));
                }
            }
            this._inconsistentPatchLevels = true;
            throw new PatchInconsistencyException();
        }
    }

    private String[] _getInstalledPatches(Properties properties) {
        if (properties == null) {
            properties = this.getProperties();
        }
        return StringUtil.split(properties.getProperty("installed.patches"));
    }

    private Properties _getProperties(String fileName) {
        Properties properties;
        block19: {
            if (Validator.isNull(fileName)) {
                fileName = "patcher.properties";
            }
            properties = new Properties();
            Class<?> clazz = this.getClass();
            if (Objects.equals(fileName, "patcher-service.properties")) {
                clazz = clazz.getInterfaces()[0];
            }
            ClassLoader classLoader = clazz.getClassLoader();
            try (InputStream inputStream = classLoader.getResourceAsStream(fileName);){
                if (inputStream == null) {
                    if (_log.isDebugEnabled()) {
                        _log.debug("Unable to load " + fileName);
                    }
                } else {
                    properties.load(inputStream);
                }
            }
            catch (IOException ioe) {
                if (!_log.isWarnEnabled()) break block19;
                _log.warn(ioe, ioe);
            }
        }
        return properties;
    }
}

