/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.servlet.context.helper.order;

import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.Arrays;
import java.util.EnumMap;

public class Order {
    public static final String OTHERS = Order.class.getName() + "#OTHERS";
    private EnumMap<Path, String[]> _routes = new EnumMap(Path.class);

    public Order() {
        this._routes.put(Path.BEFORE, new String[0]);
        this._routes.put(Path.AFTER, new String[0]);
    }

    public EnumMap<Path, String[]> getRoutes() {
        return this._routes;
    }

    public boolean isAfter(String name) {
        return Arrays.binarySearch(this._routes.get((Object)Path.AFTER), name) >= 0;
    }

    public boolean isAfterOthers() {
        boolean value = false;
        if (this._routes.get((Object)Path.AFTER) != null && Arrays.binarySearch(this._routes.get((Object)Path.AFTER), OTHERS) >= 0) {
            value = true;
        }
        return value;
    }

    public boolean isBefore(String name) {
        return Arrays.binarySearch(this._routes.get((Object)Path.BEFORE), name) >= 0;
    }

    public boolean isBeforeOthers() {
        boolean value = false;
        if (this._routes.get((Object)Path.BEFORE) != null && Arrays.binarySearch(this._routes.get((Object)Path.BEFORE), OTHERS) >= 0) {
            value = true;
        }
        return value;
    }

    public boolean isOrdered() {
        return ArrayUtil.isNotEmpty(this._routes.get((Object)Path.AFTER)) || ArrayUtil.isNotEmpty(this._routes.get((Object)Path.BEFORE));
    }

    public void setRoutes(EnumMap<Path, String[]> routes) {
        this._routes = routes;
    }

    public static enum Path {
        AFTER,
        BEFORE;

    }
}

