/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.odata.entity;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.odata.entity.EntityField;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ComplexEntityField
extends EntityField {
    private final Map<String, EntityField> _entityFieldsMap;

    public ComplexEntityField(String name, List<EntityField> entityFields) {
        super(name, EntityField.Type.COMPLEX, locale -> name, locale -> name, fieldValue -> String.valueOf(fieldValue));
        if (entityFields == null) {
            this._entityFieldsMap = Collections.emptyMap();
        } else {
            Stream stream = entityFields.stream();
            this._entityFieldsMap = stream.map(entityField -> new AbstractMap.SimpleEntry<String, EntityField>(entityField.getName(), (EntityField)entityField)).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (EntityField)entry.getValue()));
        }
    }

    public Map<String, EntityField> getEntityFieldsMap() {
        return this._entityFieldsMap;
    }

    @Override
    public String toString() {
        EntityField.Type type = this.getType();
        return StringBundler.concat("{entityFields: ", this._entityFieldsMap.toString(), ", name: ", this.getName(), ", type: ", type.name(), "}");
    }
}

