/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.notifications;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.UserNotificationEvent;
import com.liferay.portal.kernel.notifications.BaseChannelImpl;
import com.liferay.portal.kernel.notifications.ChannelException;
import com.liferay.portal.kernel.notifications.NotificationEvent;
import com.liferay.portal.kernel.notifications.NotificationEventComparator;
import com.liferay.portal.kernel.notifications.NotificationEventFactoryUtil;
import com.liferay.portal.kernel.service.UserNotificationEventLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ChannelImpl
extends BaseChannelImpl {
    private static final Log _log = LogFactoryUtil.getLog(ChannelImpl.class);
    private static final Comparator<NotificationEvent> _comparator = new NotificationEventComparator();
    private TreeSet<NotificationEvent> _notificationEvents;
    private Map<String, NotificationEvent> _unconfirmedNotificationEvents;

    public ChannelImpl() {
        this(0L, 0L);
    }

    public ChannelImpl(long companyId, long usedId) {
        super(companyId, usedId);
    }

    @Override
    public void confirmDelivery(Collection<String> notificationEventUuids) throws ChannelException {
        this.confirmDelivery(notificationEventUuids, false);
    }

    @Override
    public void confirmDelivery(Collection<String> notificationEventUuids, boolean archive) throws ChannelException {
        this.lock.lock();
        try {
            if (PropsValues.USER_NOTIFICATION_EVENT_CONFIRMATION_ENABLED) {
                if (archive) {
                    UserNotificationEventLocalServiceUtil.updateUserNotificationEvents(notificationEventUuids, this.getCompanyId(), archive);
                } else {
                    UserNotificationEventLocalServiceUtil.deleteUserNotificationEvents(notificationEventUuids, this.getCompanyId());
                }
            }
            for (String notificationEventUuid : notificationEventUuids) {
                Map<String, NotificationEvent> unconfirmedNotificationEvents = this._getUnconfirmedNotificationEvents();
                unconfirmedNotificationEvents.remove(notificationEventUuid);
            }
        }
        catch (Exception e) {
            throw new ChannelException("Unable to confirm delivery for user " + this.getUserId(), e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void confirmDelivery(String notificationEventUuid) throws ChannelException {
        this.confirmDelivery(notificationEventUuid, false);
    }

    @Override
    public void confirmDelivery(String notificationEventUuid, boolean archive) throws ChannelException {
        this.lock.lock();
        try {
            if (PropsValues.USER_NOTIFICATION_EVENT_CONFIRMATION_ENABLED) {
                if (archive) {
                    UserNotificationEventLocalServiceUtil.updateUserNotificationEvent(notificationEventUuid, this.getCompanyId(), archive);
                } else {
                    UserNotificationEventLocalServiceUtil.deleteUserNotificationEvent(notificationEventUuid, this.getCompanyId());
                }
            }
            Map<String, NotificationEvent> unconfirmedNotificationEvents = this._getUnconfirmedNotificationEvents();
            unconfirmedNotificationEvents.remove(notificationEventUuid);
        }
        catch (Exception e) {
            throw new ChannelException("Unable to confirm delivery for " + notificationEventUuid, e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void deleteUserNotificiationEvent(String notificationEventUuid) throws ChannelException {
        this.lock.lock();
        try {
            UserNotificationEventLocalServiceUtil.deleteUserNotificationEvent(notificationEventUuid, this.getCompanyId());
            Map<String, NotificationEvent> unconfirmedNotificationEvents = this._getUnconfirmedNotificationEvents();
            unconfirmedNotificationEvents.remove(notificationEventUuid);
        }
        catch (Exception e) {
            throw new ChannelException("Unable to delete event " + notificationEventUuid, e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void deleteUserNotificiationEvents(Collection<String> notificationEventUuids) throws ChannelException {
        this.lock.lock();
        try {
            UserNotificationEventLocalServiceUtil.deleteUserNotificationEvents(notificationEventUuids, this.getCompanyId());
            for (String notificationEventUuid : notificationEventUuids) {
                Map<String, NotificationEvent> unconfirmedNotificationEvents = this._getUnconfirmedNotificationEvents();
                unconfirmedNotificationEvents.remove(notificationEventUuid);
            }
        }
        catch (Exception e) {
            throw new ChannelException("Unable to delete events for user " + this.getUserId(), e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void flush() {
        this.lock.lock();
        try {
            if (this._notificationEvents != null) {
                this._notificationEvents.clear();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(long timestamp) {
        this.lock.lock();
        try {
            if (this._notificationEvents == null) {
                return;
            }
            Iterator<NotificationEvent> itr = this._notificationEvents.iterator();
            while (itr.hasNext()) {
                NotificationEvent notificationEvent = itr.next();
                if (notificationEvent.getTimestamp() >= timestamp) continue;
                itr.remove();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<NotificationEvent> getNotificationEvents(boolean flush) throws ChannelException {
        this.lock.lock();
        try {
            List<NotificationEvent> list = this.doGetNotificationEvents(flush);
            return list;
        }
        catch (ChannelException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ChannelException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void init() throws ChannelException {
        this.lock.lock();
        try {
            this.doInit();
        }
        catch (SystemException se) {
            throw new ChannelException("Unable to init channel " + this.getUserId(), se);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void removeTransientNotificationEvents(Collection<NotificationEvent> notificationEvents) {
        this.lock.lock();
        try {
            if (this._notificationEvents != null) {
                this._notificationEvents.removeAll(notificationEvents);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTransientNotificationEventsByUuid(Collection<String> notificationEventUuids) {
        HashSet<String> notificationEventUuidsSet = new HashSet<String>(notificationEventUuids);
        this.lock.lock();
        try {
            if (this._notificationEvents == null) {
                return;
            }
            Iterator<NotificationEvent> itr = this._notificationEvents.iterator();
            while (itr.hasNext()) {
                NotificationEvent notificationEvent = itr.next();
                if (!notificationEventUuidsSet.contains(notificationEvent.getUuid())) continue;
                itr.remove();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void sendNotificationEvent(NotificationEvent notificationEvent) throws ChannelException {
        this.lock.lock();
        try {
            long currentTime = System.currentTimeMillis();
            this.doStoreNotificationEvent(notificationEvent, currentTime);
            if (PropsValues.USER_NOTIFICATION_EVENT_CONFIRMATION_ENABLED && notificationEvent.isDeliveryRequired()) {
                UserNotificationEventLocalServiceUtil.addUserNotificationEvent(this.getUserId(), notificationEvent);
            }
            this.notifyChannelListeners();
        }
        catch (Exception e) {
            throw new ChannelException("Unable to send event", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void sendNotificationEvents(Collection<NotificationEvent> notificationEvents) throws ChannelException {
        this.lock.lock();
        try {
            long currentTime = System.currentTimeMillis();
            ArrayList<NotificationEvent> persistedNotificationEvents = new ArrayList<NotificationEvent>(notificationEvents.size());
            for (NotificationEvent notificationEvent : notificationEvents) {
                this.doStoreNotificationEvent(notificationEvent, currentTime);
                if (!PropsValues.USER_NOTIFICATION_EVENT_CONFIRMATION_ENABLED || !notificationEvent.isDeliveryRequired()) continue;
                persistedNotificationEvents.add(notificationEvent);
            }
            if (PropsValues.USER_NOTIFICATION_EVENT_CONFIRMATION_ENABLED && !persistedNotificationEvents.isEmpty()) {
                UserNotificationEventLocalServiceUtil.addUserNotificationEvents(this.getUserId(), persistedNotificationEvents);
            }
            this.notifyChannelListeners();
        }
        catch (Exception e) {
            throw new ChannelException("Unable to send event", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeNotificationEvent(NotificationEvent notificationEvent, long currentTime) {
        this.lock.lock();
        try {
            this.doStoreNotificationEvent(notificationEvent, currentTime);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected void doCleanUp() throws Exception {
        this.lock.lock();
        try {
            long currentTime = System.currentTimeMillis();
            TreeSet<NotificationEvent> notificationEvents = this._getNotificationEvents();
            Iterator<NotificationEvent> itr1 = notificationEvents.iterator();
            while (itr1.hasNext()) {
                NotificationEvent notificationEvent = itr1.next();
                if (!this.isRemoveNotificationEvent(notificationEvent, currentTime)) continue;
                itr1.remove();
            }
            Map<String, NotificationEvent> unconfirmedNotificationEvents = this._getUnconfirmedNotificationEvents();
            ArrayList<String> invalidNotificationEventUuids = new ArrayList<String>(unconfirmedNotificationEvents.size());
            Set<Map.Entry<String, NotificationEvent>> unconfirmedNotificationEventsSet = unconfirmedNotificationEvents.entrySet();
            Iterator<Map.Entry<String, NotificationEvent>> itr2 = unconfirmedNotificationEventsSet.iterator();
            while (itr2.hasNext()) {
                Map.Entry<String, NotificationEvent> entry = itr2.next();
                NotificationEvent notificationEvent = entry.getValue();
                if (!this.isRemoveNotificationEvent(notificationEvent, currentTime)) continue;
                invalidNotificationEventUuids.add(entry.getKey());
                itr2.remove();
            }
            if (PropsValues.USER_NOTIFICATION_EVENT_CONFIRMATION_ENABLED && !invalidNotificationEventUuids.isEmpty()) {
                UserNotificationEventLocalServiceUtil.deleteUserNotificationEvents(invalidNotificationEventUuids, this.getCompanyId());
            }
        }
        catch (Exception e) {
            throw new ChannelException("Unable to clean up channel " + this.getUserId(), e);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected List<NotificationEvent> doGetNotificationEvents(boolean flush) throws Exception {
        long currentTime = System.currentTimeMillis();
        TreeSet<NotificationEvent> notificationEventsSet = this._getNotificationEvents();
        Map<String, NotificationEvent> unconfirmedNotificationEvents = this._getUnconfirmedNotificationEvents();
        ArrayList<NotificationEvent> notificationEvents = new ArrayList<NotificationEvent>(notificationEventsSet.size() + unconfirmedNotificationEvents.size());
        for (NotificationEvent notificationEvent : notificationEventsSet) {
            if (this.isRemoveNotificationEvent(notificationEvent, currentTime)) break;
            notificationEvents.add(notificationEvent);
        }
        if (flush) {
            notificationEventsSet.clear();
        } else if (notificationEventsSet.size() != notificationEvents.size()) {
            notificationEventsSet.retainAll(notificationEvents);
        }
        ArrayList<String> invalidNotificationEventUuids = new ArrayList<String>(unconfirmedNotificationEvents.size());
        Set<Map.Entry<String, NotificationEvent>> unconfirmedNotificationEventsSet = unconfirmedNotificationEvents.entrySet();
        Iterator<Map.Entry<String, NotificationEvent>> itr = unconfirmedNotificationEventsSet.iterator();
        while (itr.hasNext()) {
            Map.Entry<String, NotificationEvent> entry = itr.next();
            NotificationEvent notificationEvent = entry.getValue();
            if (this.isRemoveNotificationEvent(notificationEvent, currentTime) && !notificationEvent.isArchived()) {
                invalidNotificationEventUuids.add(notificationEvent.getUuid());
                itr.remove();
                continue;
            }
            notificationEvents.add(entry.getValue());
        }
        if (PropsValues.USER_NOTIFICATION_EVENT_CONFIRMATION_ENABLED && !invalidNotificationEventUuids.isEmpty()) {
            UserNotificationEventLocalServiceUtil.deleteUserNotificationEvents(invalidNotificationEventUuids, this.getCompanyId());
        }
        return notificationEvents;
    }

    protected void doInit() {
        if (!PropsValues.USER_NOTIFICATION_EVENT_CONFIRMATION_ENABLED) {
            return;
        }
        List<UserNotificationEvent> userNotificationEvents = UserNotificationEventLocalServiceUtil.getDeliveredUserNotificationEvents(this.getUserId(), false);
        Map<String, NotificationEvent> unconfirmedNotificationEvents = this._getUnconfirmedNotificationEvents();
        ArrayList<String> invalidNotificationEventUuids = new ArrayList<String>(unconfirmedNotificationEvents.size());
        long currentTime = System.currentTimeMillis();
        for (UserNotificationEvent persistedNotificationEvent : userNotificationEvents) {
            try {
                JSONObject payloadJSONObject = JSONFactoryUtil.createJSONObject(persistedNotificationEvent.getPayload());
                NotificationEvent notificationEvent = NotificationEventFactoryUtil.createNotificationEvent(persistedNotificationEvent.getTimestamp(), persistedNotificationEvent.getType(), payloadJSONObject);
                notificationEvent.setDeliveryRequired(persistedNotificationEvent.getDeliverBy());
                notificationEvent.setUuid(persistedNotificationEvent.getUuid());
                if (this.isRemoveNotificationEvent(notificationEvent, currentTime)) {
                    invalidNotificationEventUuids.add(notificationEvent.getUuid());
                    continue;
                }
                unconfirmedNotificationEvents.put(notificationEvent.getUuid(), notificationEvent);
            }
            catch (JSONException jsone) {
                _log.error(jsone, jsone);
                invalidNotificationEventUuids.add(persistedNotificationEvent.getUuid());
            }
        }
        if (!invalidNotificationEventUuids.isEmpty()) {
            UserNotificationEventLocalServiceUtil.deleteUserNotificationEvents(invalidNotificationEventUuids, this.getCompanyId());
        }
    }

    protected void doStoreNotificationEvent(NotificationEvent notificationEvent, long currentTime) {
        if (this.isRemoveNotificationEvent(notificationEvent, currentTime)) {
            return;
        }
        if (PropsValues.USER_NOTIFICATION_EVENT_CONFIRMATION_ENABLED && notificationEvent.isDeliveryRequired()) {
            Map<String, NotificationEvent> unconfirmedNotificationEvents = this._getUnconfirmedNotificationEvents();
            unconfirmedNotificationEvents.put(notificationEvent.getUuid(), notificationEvent);
        } else {
            TreeSet<NotificationEvent> notificationEvents = this._getNotificationEvents();
            notificationEvents.add(notificationEvent);
            if (notificationEvents.size() > PropsValues.NOTIFICATIONS_MAX_EVENTS) {
                NotificationEvent firstNotificationEvent = notificationEvents.first();
                notificationEvents.remove(firstNotificationEvent);
            }
        }
    }

    protected boolean isRemoveNotificationEvent(NotificationEvent notificationEvent, long currentTime) {
        return notificationEvent.getDeliverBy() != 0L && notificationEvent.getDeliverBy() <= currentTime;
    }

    private TreeSet<NotificationEvent> _getNotificationEvents() {
        if (this._notificationEvents == null) {
            this._notificationEvents = new TreeSet<NotificationEvent>(_comparator);
        }
        return this._notificationEvents;
    }

    private Map<String, NotificationEvent> _getUnconfirmedNotificationEvents() {
        if (this._unconfirmedNotificationEvents == null) {
            this._unconfirmedNotificationEvents = new LinkedHashMap<String, NotificationEvent>();
        }
        return this._unconfirmedNotificationEvents;
    }
}

