/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.nio.intraband.cache;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.nio.intraband.proxy.IntrabandProxyUtil;
import com.liferay.portal.nio.intraband.proxy.WarnLogExceptionHandler;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class BaseIntrabandPortalCacheManager<K extends Serializable, V extends Serializable>
implements PortalCacheManager<K, V> {
    private static final Class<? extends PortalCache<?, ?>> _STUB_CLASS = IntrabandProxyUtil.getStubClass(PortalCache.class, PortalCache.class.getName());
    private final Map<String, PortalCache<K, V>> _portalCaches = new ConcurrentHashMap<String, PortalCache<K, V>>();
    private final RegistrationReference _registrationReference = null;

    public static Class<? extends PortalCache<?, ?>> getPortalCacheStubClass() {
        return _STUB_CLASS;
    }

    @Override
    public void destroy() {
        this._portalCaches.clear();
    }

    @Override
    public PortalCache<K, V> fetchPortalCache(String portalCacheName) {
        return this._portalCaches.get(portalCacheName);
    }

    @Override
    public PortalCache<K, V> getPortalCache(String portalCacheName) {
        return this.getPortalCache(portalCacheName, false);
    }

    @Override
    public PortalCache<K, V> getPortalCache(String portalCacheName, boolean blocking) {
        PortalCache<Object, Object> portalCache = this._portalCaches.get(portalCacheName);
        if (portalCache == null) {
            portalCache = IntrabandProxyUtil.newStubInstance(_STUB_CLASS, portalCacheName, this._registrationReference, WarnLogExceptionHandler.INSTANCE);
            this._portalCaches.put(portalCacheName, portalCache);
        }
        return portalCache;
    }

    @Override
    public void removePortalCache(String portalCacheName) {
        this._portalCaches.remove(portalCacheName);
    }
}

