/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.module.framework;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.module.framework.ModuleFrameworkClassLoader;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ModuleFrameworkAdapterHelper {
    private static final Log _log = LogFactoryUtil.getLog(ModuleFrameworkAdapterHelper.class);
    private static ClassLoader _classLoader;
    private static final Map<MethodKey, Method> _methods;
    private final Object _adaptedObject;

    public static ClassLoader getClassLoader() {
        if (_classLoader != null) {
            return _classLoader;
        }
        try {
            File coreDir;
            File[] files;
            if (FileUtil.getFile() == null) {
                FileUtil fileUtil = new FileUtil();
                fileUtil.setFile(new FileImpl());
            }
            if ((files = (coreDir = new File(PropsValues.MODULE_FRAMEWORK_BASE_DIR, "core")).listFiles()) == null) {
                throw new IllegalStateException("Missing " + coreDir.getCanonicalPath());
            }
            URL[] urls = new URL[files.length];
            Object[] packageNames = new String[files.length + 4];
            for (int i = 0; i < urls.length; ++i) {
                File file = files[i];
                URI uri = file.toURI();
                urls[i] = uri.toURL();
                String name = file.getName();
                if (name.endsWith(".jar")) {
                    name = name.substring(0, name.length() - 3);
                }
                if (name.endsWith(".api.")) {
                    name = name.substring(0, name.length() - 4);
                }
                if (name.endsWith(".impl.")) {
                    name = name.substring(0, name.length() - 5);
                    name = name.concat("internal.");
                }
                packageNames[i] = name;
            }
            packageNames[files.length] = "org.apache.felix.resolver.";
            packageNames[files.length + 1] = "org.eclipse.core.";
            packageNames[files.length + 2] = "org.eclipse.equinox.";
            packageNames[files.length + 3] = "org.osgi.";
            Arrays.sort(packageNames);
            _classLoader = new ModuleFrameworkClassLoader(urls, PortalClassLoaderUtil.getClassLoader(), (String[])packageNames);
            return _classLoader;
        }
        catch (IOException ioe) {
            _log.error("Unable to configure the class loader for the module framework", ioe);
            return (ClassLoader)ReflectionUtil.throwException(ioe);
        }
    }

    public ModuleFrameworkAdapterHelper(String className) {
        try {
            this._adaptedObject = InstanceFactory.newInstance(ModuleFrameworkAdapterHelper.getClassLoader(), className);
        }
        catch (Exception e) {
            _log.error("Unable to load the module framework");
            throw new RuntimeException(e);
        }
    }

    public Object exec(String methodName, Class<?>[] parameterTypes, Object ... parameters) {
        try {
            Method method = this.searchMethod(methodName, parameterTypes);
            return method.invoke(this._adaptedObject, parameters);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public Object execute(String methodName, Object ... parameters) {
        if (parameters == null) {
            return this.exec(methodName, null, parameters);
        }
        Class[] parameterTypes = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameterTypes[i] = parameters[i] == null ? null : (parameters[i] instanceof Boolean ? Boolean.TYPE : (parameters[i] instanceof Byte ? Byte.TYPE : (parameters[i] instanceof Character ? Character.TYPE : (parameters[i] instanceof Double ? Double.TYPE : (parameters[i] instanceof Float ? Float.TYPE : (parameters[i] instanceof Integer ? Integer.TYPE : (parameters[i] instanceof Long ? Long.TYPE : (parameters[i] instanceof Short ? Short.TYPE : parameters[i].getClass()))))))));
        }
        return this.exec(methodName, parameterTypes, parameters);
    }

    protected Method searchMethod(String methodName, Class<?>[] parameterTypes) throws Exception {
        MethodKey methodKey = new MethodKey(this._adaptedObject.getClass(), methodName, parameterTypes);
        if (_methods.containsKey(methodKey)) {
            return _methods.get(methodKey);
        }
        Method method = ReflectionUtil.getDeclaredMethod(this._adaptedObject.getClass(), methodName, parameterTypes);
        _methods.put(methodKey, method);
        return method;
    }

    static {
        _methods = new HashMap<MethodKey, Method>();
    }
}

