/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Namespace;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.impl.WebDAVPropsBaseImpl;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class WebDAVPropsImpl
extends WebDAVPropsBaseImpl {
    private static final String _PROPS = "<properties />";
    private Document _document;

    @Override
    public void addProp(String name, String prefix, String uri) throws Exception {
        Namespace namespace = WebDAVUtil.createNamespace(prefix, uri);
        QName qName = SAXReaderUtil.createQName(name, namespace);
        Element root = this._removeExisting(qName);
        root.addElement(qName);
    }

    @Override
    public void addProp(String name, String prefix, String uri, String text) throws Exception {
        Namespace namespace = WebDAVUtil.createNamespace(prefix, uri);
        QName qName = SAXReaderUtil.createQName(name, namespace);
        Element root = this._removeExisting(qName);
        Element element = root.addElement(qName);
        element.addText(text);
    }

    @Override
    public String getProps() {
        String props = super.getProps();
        if (Validator.isNull(props)) {
            return _PROPS;
        }
        return props;
    }

    @Override
    public Set<QName> getPropsSet() throws Exception {
        HashSet<QName> propsSet = new HashSet<QName>();
        Document doc = this._getPropsDocument();
        Element root = doc.getRootElement();
        for (Element el : root.elements()) {
            String prefix = el.getNamespacePrefix();
            String uri = el.getNamespaceURI();
            Namespace namespace = WebDAVUtil.createNamespace(prefix, uri);
            propsSet.add(SAXReaderUtil.createQName(el.getName(), namespace));
        }
        return propsSet;
    }

    @Override
    public String getText(String name, String prefix, String uri) throws Exception {
        Namespace namespace = WebDAVUtil.createNamespace(prefix, uri);
        QName qName = SAXReaderUtil.createQName(name, namespace);
        Document doc = this._getPropsDocument();
        Element root = doc.getRootElement();
        Element prop = root.element(qName);
        return prop.getText();
    }

    @Override
    public void removeProp(String name, String prefix, String uri) throws Exception {
        Namespace namespace = WebDAVUtil.createNamespace(prefix, uri);
        QName qName = SAXReaderUtil.createQName(name, namespace);
        this._removeExisting(qName);
    }

    @Override
    public void store() throws Exception {
        if (this._document != null) {
            String xml = this._document.formattedString("    ");
            this.setProps(xml);
            this._document = null;
        }
    }

    private Document _getPropsDocument() throws DocumentException {
        if (this._document == null) {
            this._document = SAXReaderUtil.read(this.getProps());
        }
        return this._document;
    }

    private Element _removeExisting(QName qName) throws Exception {
        Document doc = this._getPropsDocument();
        Element root = doc.getRootElement();
        List<Element> elementsList = root.elements(qName);
        for (Element el : elementsList) {
            root.remove(el);
        }
        return root;
    }
}

