/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.model.impl.VirtualHostImpl;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class VirtualHostCacheModel
implements CacheModel<VirtualHost>,
Externalizable,
MVCCModel {
    public long mvccVersion;
    public long virtualHostId;
    public long companyId;
    public long layoutSetId;
    public String hostname;

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VirtualHostCacheModel)) {
            return false;
        }
        VirtualHostCacheModel virtualHostCacheModel = (VirtualHostCacheModel)obj;
        return this.virtualHostId == virtualHostCacheModel.virtualHostId && this.mvccVersion == virtualHostCacheModel.mvccVersion;
    }

    public int hashCode() {
        int hashCode = HashUtil.hash(0, this.virtualHostId);
        return HashUtil.hash(hashCode, this.mvccVersion);
    }

    @Override
    public long getMvccVersion() {
        return this.mvccVersion;
    }

    @Override
    public void setMvccVersion(long mvccVersion) {
        this.mvccVersion = mvccVersion;
    }

    public String toString() {
        StringBundler sb = new StringBundler(11);
        sb.append("{mvccVersion=");
        sb.append(this.mvccVersion);
        sb.append(", virtualHostId=");
        sb.append(this.virtualHostId);
        sb.append(", companyId=");
        sb.append(this.companyId);
        sb.append(", layoutSetId=");
        sb.append(this.layoutSetId);
        sb.append(", hostname=");
        sb.append(this.hostname);
        sb.append("}");
        return sb.toString();
    }

    @Override
    public VirtualHost toEntityModel() {
        VirtualHostImpl virtualHostImpl = new VirtualHostImpl();
        virtualHostImpl.setMvccVersion(this.mvccVersion);
        virtualHostImpl.setVirtualHostId(this.virtualHostId);
        virtualHostImpl.setCompanyId(this.companyId);
        virtualHostImpl.setLayoutSetId(this.layoutSetId);
        if (this.hostname == null) {
            virtualHostImpl.setHostname("");
        } else {
            virtualHostImpl.setHostname(this.hostname);
        }
        virtualHostImpl.resetOriginalValues();
        return virtualHostImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.mvccVersion = objectInput.readLong();
        this.virtualHostId = objectInput.readLong();
        this.companyId = objectInput.readLong();
        this.layoutSetId = objectInput.readLong();
        this.hostname = objectInput.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.mvccVersion);
        objectOutput.writeLong(this.virtualHostId);
        objectOutput.writeLong(this.companyId);
        objectOutput.writeLong(this.layoutSetId);
        if (this.hostname == null) {
            objectOutput.writeUTF("");
        } else {
            objectOutput.writeUTF(this.hostname);
        }
    }
}

