/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.EmailAddress;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.kernel.model.Phone;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.model.UserConstants;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.Website;
import com.liferay.portal.kernel.security.auth.EmailAddressGenerator;
import com.liferay.portal.kernel.security.auth.FullNameGenerator;
import com.liferay.portal.kernel.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.AddressLocalServiceUtil;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.ContactLocalServiceUtil;
import com.liferay.portal.kernel.service.EmailAddressLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.PasswordPolicyLocalServiceUtil;
import com.liferay.portal.kernel.service.PhoneLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.TeamLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.WebsiteLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.RemotePreference;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.ContactImpl;
import com.liferay.portal.model.impl.UserBaseImpl;
import com.liferay.portal.security.auth.EmailAddressGeneratorFactory;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.users.admin.kernel.util.UserInitialsGeneratorUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;

public class UserImpl
extends UserBaseImpl {
    private static final boolean _HAS_USERS_PROFILE_FRIENDLY_URL = Validator.isNotNull(PropsValues.USERS_PROFILE_FRIENDLY_URL);
    private static final Contact _NULL_CONTACT = new ContactImpl();
    private static final Log _log = LogFactoryUtil.getLog(UserImpl.class);
    private Contact _contact;
    private Locale _locale;
    private boolean _passwordModified;
    private PasswordPolicy _passwordPolicy;
    private String _passwordUnencrypted;
    private final transient Map<String, RemotePreference> _remotePreferences = new HashMap<String, RemotePreference>();
    private TimeZone _timeZone;

    @Override
    public void addRemotePreference(RemotePreference remotePreference) {
        this._remotePreferences.put(remotePreference.getName(), remotePreference);
    }

    @Override
    public Contact fetchContact() {
        if (this._contact == _NULL_CONTACT) {
            return null;
        }
        if (this._contact == null) {
            Contact contact = ContactLocalServiceUtil.fetchContact(this.getContactId());
            this._contact = contact == null ? _NULL_CONTACT : contact;
        }
        return this._contact;
    }

    @Override
    public String fetchPortraitURL(ThemeDisplay themeDisplay) {
        Contact contact = this.fetchContact();
        if (contact == null) {
            return "";
        }
        return UserConstants.getPortraitURL(themeDisplay.getPathImage(), contact.isMale(), this.getPortraitId(), this.getUserUuid());
    }

    @Override
    public List<Address> getAddresses() {
        return AddressLocalServiceUtil.getAddresses(this.getCompanyId(), Contact.class.getName(), this.getContactId());
    }

    @Override
    public Date getBirthday() throws PortalException {
        return this.getContact().getBirthday();
    }

    @Override
    public String getCompanyMx() throws PortalException {
        Company company = CompanyLocalServiceUtil.getCompanyById(this.getCompanyId());
        return company.getMx();
    }

    @Override
    public Contact getContact() throws PortalException {
        if (this._contact == null || this._contact == _NULL_CONTACT) {
            this._contact = ContactLocalServiceUtil.getContact(this.getContactId());
        }
        return this._contact;
    }

    @Override
    public String getDigest() {
        String digest = super.getDigest();
        if (Validator.isNull(digest) && !this.isPasswordEncrypted()) {
            digest = this.getDigest(this.getPassword());
        }
        return digest;
    }

    @Override
    public String getDigest(String password) {
        if (Validator.isNull(this.getScreenName())) {
            throw new IllegalStateException("Screen name is null");
        }
        if (Validator.isNull(this.getEmailAddress())) {
            throw new IllegalStateException("Email address is null");
        }
        StringBundler sb = new StringBundler(5);
        String digest1 = DigesterUtil.digestHex("MD5", this.getEmailAddress(), "PortalRealm", password);
        sb.append(digest1);
        sb.append(",");
        String digest2 = DigesterUtil.digestHex("MD5", this.getScreenName(), "PortalRealm", password);
        sb.append(digest2);
        sb.append(",");
        String digest3 = DigesterUtil.digestHex("MD5", String.valueOf(this.getUserId()), "PortalRealm", password);
        sb.append(digest3);
        return sb.toString();
    }

    @Override
    public String getDisplayEmailAddress() {
        String emailAddress = super.getEmailAddress();
        EmailAddressGenerator emailAddressGenerator = EmailAddressGeneratorFactory.getInstance();
        if (emailAddressGenerator.isFake(emailAddress)) {
            emailAddress = "";
        }
        return emailAddress;
    }

    @Override
    public String getDisplayURL(ThemeDisplay themeDisplay) throws PortalException {
        return this.getDisplayURL(themeDisplay, false);
    }

    @Override
    public String getDisplayURL(ThemeDisplay themeDisplay, boolean privateLayout) throws PortalException {
        if (this.isDefaultUser() || themeDisplay == null) {
            return "";
        }
        String profileFriendlyURL = this.getProfileFriendlyURL();
        if (profileFriendlyURL != null) {
            String portalURL = themeDisplay.getPortalURL();
            return PortalUtil.addPreservedParameters(themeDisplay, portalURL.concat(PortalUtil.getPathContext()).concat(profileFriendlyURL));
        }
        Group group = this.getGroup();
        return group.getDisplayURL(themeDisplay, privateLayout);
    }

    @Override
    public List<EmailAddress> getEmailAddresses() {
        return EmailAddressLocalServiceUtil.getEmailAddresses(this.getCompanyId(), Contact.class.getName(), this.getContactId());
    }

    @Override
    public boolean getFemale() throws PortalException {
        return !this.getMale();
    }

    @Override
    @AutoEscape
    public String getFullName() {
        return this.getFullName(false, false);
    }

    @Override
    @AutoEscape
    public String getFullName(boolean usePrefix, boolean useSuffix) {
        Contact contact;
        Contact contact2;
        FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
        long prefixId = 0L;
        if (usePrefix && (contact2 = this.fetchContact()) != null) {
            prefixId = contact2.getPrefixId();
        }
        long suffixId = 0L;
        if (useSuffix && (contact = this.fetchContact()) != null) {
            suffixId = contact.getSuffixId();
        }
        return fullNameGenerator.getLocalizedFullName(this.getFirstName(), this.getMiddleName(), this.getLastName(), this.getLocale(), prefixId, suffixId);
    }

    @Override
    public Group getGroup() {
        return GroupLocalServiceUtil.fetchUserGroup(this.getCompanyId(), this.getUserId());
    }

    @Override
    public long getGroupId() {
        Group group = this.getGroup();
        return group.getGroupId();
    }

    @Override
    public long[] getGroupIds() {
        return UserLocalServiceUtil.getGroupPrimaryKeys(this.getUserId());
    }

    @Override
    public List<Group> getGroups() {
        return GroupLocalServiceUtil.getUserGroups(this.getUserId());
    }

    @Override
    public String getInitials() {
        String initials = UserInitialsGeneratorUtil.getInitials(this);
        if (initials == null) {
            String firstInitial = StringUtil.shorten(this.getFirstName(), 1);
            String lastInitial = StringUtil.shorten(this.getLastName(), 1);
            initials = StringUtil.toUpperCase(firstInitial.concat(lastInitial));
        }
        return initials;
    }

    @Override
    public Locale getLocale() {
        return this._locale;
    }

    @Override
    public String getLogin() throws PortalException {
        String login = null;
        Company company = CompanyLocalServiceUtil.getCompanyById(this.getCompanyId());
        String authType = company.getAuthType();
        if (authType.equals("emailAddress")) {
            login = this.getEmailAddress();
        } else if (authType.equals("screenName")) {
            login = this.getScreenName();
        } else if (authType.equals("userId")) {
            login = String.valueOf(this.getUserId());
        }
        return login;
    }

    @Override
    public boolean getMale() throws PortalException {
        return this.getContact().getMale();
    }

    @Override
    public List<Group> getMySiteGroups() throws PortalException {
        return this.getMySiteGroups(null, -1);
    }

    @Override
    public List<Group> getMySiteGroups(int max) throws PortalException {
        return this.getMySiteGroups(null, max);
    }

    @Override
    public List<Group> getMySiteGroups(String[] classNames, int max) throws PortalException {
        return GroupServiceUtil.getUserSitesGroups(this.getUserId(), classNames, max);
    }

    @Override
    public long[] getOrganizationIds() throws PortalException {
        return this.getOrganizationIds(false);
    }

    @Override
    public long[] getOrganizationIds(boolean includeAdministrative) throws PortalException {
        return OrganizationLocalServiceUtil.getUserOrganizationIds(this.getUserId(), includeAdministrative);
    }

    @Override
    public List<Organization> getOrganizations() throws PortalException {
        return this.getOrganizations(false);
    }

    @Override
    public List<Organization> getOrganizations(boolean includeAdministrative) throws PortalException {
        return OrganizationLocalServiceUtil.getUserOrganizations(this.getUserId(), includeAdministrative);
    }

    @Override
    public String getOriginalEmailAddress() {
        return super.getOriginalEmailAddress();
    }

    @Override
    public boolean getPasswordModified() {
        return this._passwordModified;
    }

    @Override
    public PasswordPolicy getPasswordPolicy() throws PortalException {
        if (this._passwordPolicy == null) {
            this._passwordPolicy = PasswordPolicyLocalServiceUtil.getPasswordPolicyByUser(this);
        }
        return this._passwordPolicy;
    }

    @Override
    public String getPasswordUnencrypted() {
        return this._passwordUnencrypted;
    }

    @Override
    public List<Phone> getPhones() {
        return PhoneLocalServiceUtil.getPhones(this.getCompanyId(), Contact.class.getName(), this.getContactId());
    }

    @Override
    public String getPortraitURL(ThemeDisplay themeDisplay) throws PortalException {
        return UserConstants.getPortraitURL(themeDisplay.getPathImage(), this.isMale(), this.getPortraitId(), this.getUserUuid());
    }

    @Override
    public int getPrivateLayoutsPageCount() throws PortalException {
        return LayoutLocalServiceUtil.getLayoutsCount(this, true);
    }

    @Override
    public int getPublicLayoutsPageCount() throws PortalException {
        return LayoutLocalServiceUtil.getLayoutsCount(this, false);
    }

    @Override
    public Set<String> getReminderQueryQuestions() throws PortalException {
        TreeSet<String> questions = new TreeSet<String>();
        List<Organization> organizations = OrganizationLocalServiceUtil.getUserOrganizations(this.getUserId());
        for (Organization organization : organizations) {
            Set<String> organizationQuestions = organization.getReminderQueryQuestions(this.getLanguageId());
            if (organizationQuestions.isEmpty()) {
                for (Organization parentOrganization = organization.getParentOrganization(); organizationQuestions.isEmpty() && parentOrganization != null; parentOrganization = parentOrganization.getParentOrganization()) {
                    organizationQuestions = parentOrganization.getReminderQueryQuestions(this.getLanguageId());
                }
            }
            questions.addAll(organizationQuestions);
        }
        if (questions.isEmpty()) {
            Set<String> defaultQuestions = SetUtil.fromArray(PropsUtil.getArray("users.reminder.queries.questions"));
            questions.addAll(defaultQuestions);
        }
        return questions;
    }

    @Override
    public RemotePreference getRemotePreference(String name) {
        return this._remotePreferences.get(name);
    }

    @Override
    public Iterable<RemotePreference> getRemotePreferences() {
        Collection<RemotePreference> values = this._remotePreferences.values();
        return Collections.unmodifiableCollection(values);
    }

    @Override
    public long[] getRoleIds() {
        return UserLocalServiceUtil.getRolePrimaryKeys(this.getUserId());
    }

    @Override
    public List<Role> getRoles() {
        return RoleLocalServiceUtil.getUserRoles(this.getUserId());
    }

    @Override
    public List<Group> getSiteGroups() throws PortalException {
        return this.getSiteGroups(false);
    }

    @Override
    public List<Group> getSiteGroups(boolean includeAdministrative) throws PortalException {
        return GroupLocalServiceUtil.getUserSitesGroups(this.getUserId(), includeAdministrative);
    }

    @Override
    public long[] getTeamIds() {
        return UserLocalServiceUtil.getTeamPrimaryKeys(this.getUserId());
    }

    @Override
    public List<Team> getTeams() {
        return TeamLocalServiceUtil.getUserTeams(this.getUserId());
    }

    @Override
    public TimeZone getTimeZone() {
        return this._timeZone;
    }

    @Override
    public Date getUnlockDate() throws PortalException {
        return this.getUnlockDate(this.getPasswordPolicy());
    }

    @Override
    public Date getUnlockDate(PasswordPolicy passwordPolicy) {
        Date lockoutDate = this.getLockoutDate();
        return new Date(lockoutDate.getTime() + passwordPolicy.getLockoutDuration() * 1000L);
    }

    @Override
    public long[] getUserGroupIds() {
        return UserLocalServiceUtil.getUserGroupPrimaryKeys(this.getUserId());
    }

    @Override
    public List<UserGroup> getUserGroups() {
        return UserGroupLocalServiceUtil.getUserUserGroups(this.getUserId());
    }

    @Override
    public List<Website> getWebsites() {
        return WebsiteLocalServiceUtil.getWebsites(this.getCompanyId(), Contact.class.getName(), this.getContactId());
    }

    @Override
    public boolean hasCompanyMx() throws PortalException {
        return this.hasCompanyMx(this.getEmailAddress());
    }

    @Override
    public boolean hasCompanyMx(String emailAddress) throws PortalException {
        if (Validator.isNull(emailAddress)) {
            return false;
        }
        Company company = CompanyLocalServiceUtil.getCompanyById(this.getCompanyId());
        return company.hasCompanyMx(emailAddress);
    }

    @Override
    public boolean hasMySites() throws PortalException {
        if (this.isDefaultUser()) {
            return false;
        }
        if ((PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_ENABLED || PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_ENABLED) && this.getUserId() == PrincipalThreadLocal.getUserId()) {
            return true;
        }
        List<Group> groups = this.getMySiteGroups(1);
        return !groups.isEmpty();
    }

    @Override
    public boolean hasOrganization() {
        return OrganizationLocalServiceUtil.hasUserOrganizations(this.getUserId());
    }

    @Override
    public boolean hasPrivateLayouts() throws PortalException {
        return LayoutLocalServiceUtil.hasLayouts(this, true);
    }

    @Override
    public boolean hasPublicLayouts() throws PortalException {
        return LayoutLocalServiceUtil.hasLayouts(this, false);
    }

    @Override
    public boolean hasReminderQuery() {
        return Validator.isNotNull(this.getReminderQueryQuestion()) && Validator.isNotNull(this.getReminderQueryAnswer());
    }

    @Override
    public boolean isActive() {
        return this.getStatus() == 0;
    }

    @Override
    public boolean isEmailAddressComplete() {
        if (this.isDefaultUser()) {
            return true;
        }
        return !Validator.isNull(this.getEmailAddress()) && (!PropsValues.USERS_EMAIL_ADDRESS_REQUIRED || !Validator.isNull(this.getDisplayEmailAddress()));
    }

    @Override
    public boolean isEmailAddressVerificationComplete() {
        if (this.isDefaultUser() || this.isEmailAddressVerified()) {
            return true;
        }
        boolean emailAddressVerificationRequired = false;
        try {
            Company company = CompanyLocalServiceUtil.getCompany(this.getCompanyId());
            emailAddressVerificationRequired = company.isStrangersVerify();
        }
        catch (PortalException pe) {
            _log.error(pe, pe);
        }
        return !emailAddressVerificationRequired;
    }

    @Override
    public boolean isFemale() throws PortalException {
        return this.getFemale();
    }

    @Override
    public boolean isMale() throws PortalException {
        return this.getMale();
    }

    @Override
    public boolean isPasswordModified() {
        return this._passwordModified;
    }

    @Override
    public boolean isReminderQueryComplete() {
        if (this.isDefaultUser()) {
            return true;
        }
        return !PropsValues.USERS_REMINDER_QUERIES_ENABLED || !Validator.isNull(this.getReminderQueryQuestion()) && !Validator.isNull(this.getReminderQueryAnswer());
    }

    @Override
    public boolean isSetupComplete() {
        if (this.isDefaultUser()) {
            return true;
        }
        return this.isEmailAddressComplete() && this.isEmailAddressVerificationComplete() && !this._isRequirePasswordReset() && this.isReminderQueryComplete() && this.isTermsOfUseComplete();
    }

    @Override
    public boolean isTermsOfUseComplete() {
        if (this.isDefaultUser() || this.isAgreedToTermsOfUse()) {
            return true;
        }
        boolean termsOfUseRequired = PrefsPropsUtil.getBoolean(this.getCompanyId(), "terms.of.use.required", PropsValues.TERMS_OF_USE_REQUIRED);
        return !termsOfUseRequired;
    }

    @Override
    public void setLanguageId(String languageId) {
        this._locale = LocaleUtil.fromLanguageId(languageId);
        super.setLanguageId(LocaleUtil.toLanguageId(this._locale));
    }

    @Override
    public void setPasswordModified(boolean passwordModified) {
        this._passwordModified = passwordModified;
    }

    @Override
    public void setPasswordUnencrypted(String passwordUnencrypted) {
        this._passwordUnencrypted = passwordUnencrypted;
    }

    @Override
    public void setTimeZoneId(String timeZoneId) {
        if (Validator.isNull(timeZoneId)) {
            TimeZone defaultTimeZone = TimeZoneUtil.getDefault();
            timeZoneId = defaultTimeZone.getID();
        }
        this._timeZone = TimeZoneUtil.getTimeZone(timeZoneId);
        super.setTimeZoneId(timeZoneId);
    }

    protected String getProfileFriendlyURL() {
        if (!_HAS_USERS_PROFILE_FRIENDLY_URL) {
            return null;
        }
        String normalizedScreenName = FriendlyURLNormalizerUtil.normalize(this.getScreenName());
        return StringUtil.replace(PropsValues.USERS_PROFILE_FRIENDLY_URL, new String[]{"${liferay:screenName}", "${liferay:userId}"}, new String[]{HtmlUtil.escapeURL(normalizedScreenName), String.valueOf(this.getUserId())});
    }

    private boolean _isRequirePasswordReset() {
        return this.isPasswordReset() && (this._passwordPolicy == null || this._passwordPolicy.isChangeable());
    }
}

