/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.model.UserGroupRoleModel;
import com.liferay.portal.kernel.model.UserGroupRoleSoap;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.persistence.UserGroupRolePK;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.model.impl.UserGroupRoleCacheModel;
import com.liferay.portal.model.impl.UserGroupRoleImpl;
import com.liferay.portal.util.PropsUtil;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.osgi.annotation.versioning.ProviderType;

@JSON(strict=true)
@ProviderType
public class UserGroupRoleModelImpl
extends BaseModelImpl<UserGroupRole>
implements UserGroupRoleModel {
    public static final String TABLE_NAME = "UserGroupRole";
    public static final Object[][] TABLE_COLUMNS = new Object[][]{{"mvccVersion", -5}, {"userId", -5}, {"groupId", -5}, {"roleId", -5}, {"companyId", -5}};
    public static final Map<String, Integer> TABLE_COLUMNS_MAP = new HashMap<String, Integer>();
    public static final String TABLE_SQL_CREATE = "create table UserGroupRole (mvccVersion LONG default 0 not null,userId LONG not null,groupId LONG not null,roleId LONG not null,companyId LONG,primary key (userId, groupId, roleId))";
    public static final String TABLE_SQL_DROP = "drop table UserGroupRole";
    public static final String ORDER_BY_JPQL = " ORDER BY userGroupRole.id.userId ASC, userGroupRole.id.groupId ASC, userGroupRole.id.roleId ASC";
    public static final String ORDER_BY_SQL = " ORDER BY UserGroupRole.userId ASC, UserGroupRole.groupId ASC, UserGroupRole.roleId ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED;
    public static final boolean FINDER_CACHE_ENABLED;
    public static final boolean COLUMN_BITMASK_ENABLED;
    public static final long GROUPID_COLUMN_BITMASK = 1L;
    public static final long ROLEID_COLUMN_BITMASK = 2L;
    public static final long USERID_COLUMN_BITMASK = 4L;
    public static final long LOCK_EXPIRATION_TIME;
    private static final Map<String, Function<UserGroupRole, Object>> _attributeGetterFunctions;
    private static final Map<String, BiConsumer<UserGroupRole, Object>> _attributeSetterBiConsumers;
    private static final Function<InvocationHandler, UserGroupRole> _escapedModelProxyProviderFunction;
    private long _mvccVersion;
    private long _userId;
    private long _originalUserId;
    private boolean _setOriginalUserId;
    private long _groupId;
    private long _originalGroupId;
    private boolean _setOriginalGroupId;
    private long _roleId;
    private long _originalRoleId;
    private boolean _setOriginalRoleId;
    private long _companyId;
    private long _columnBitmask;
    private UserGroupRole _escapedModel;

    public static UserGroupRole toModel(UserGroupRoleSoap soapModel) {
        if (soapModel == null) {
            return null;
        }
        UserGroupRoleImpl model = new UserGroupRoleImpl();
        model.setMvccVersion(soapModel.getMvccVersion());
        model.setUserId(soapModel.getUserId());
        model.setGroupId(soapModel.getGroupId());
        model.setRoleId(soapModel.getRoleId());
        model.setCompanyId(soapModel.getCompanyId());
        return model;
    }

    public static List<UserGroupRole> toModels(UserGroupRoleSoap[] soapModels) {
        if (soapModels == null) {
            return null;
        }
        ArrayList<UserGroupRole> models = new ArrayList<UserGroupRole>(soapModels.length);
        for (UserGroupRoleSoap soapModel : soapModels) {
            models.add(UserGroupRoleModelImpl.toModel(soapModel));
        }
        return models;
    }

    @Override
    public UserGroupRolePK getPrimaryKey() {
        return new UserGroupRolePK(this._userId, this._groupId, this._roleId);
    }

    @Override
    public void setPrimaryKey(UserGroupRolePK primaryKey) {
        this.setUserId(primaryKey.userId);
        this.setGroupId(primaryKey.groupId);
        this.setRoleId(primaryKey.roleId);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return new UserGroupRolePK(this._userId, this._groupId, this._roleId);
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        this.setPrimaryKey((UserGroupRolePK)primaryKeyObj);
    }

    @Override
    public Class<?> getModelClass() {
        return UserGroupRole.class;
    }

    @Override
    public String getModelClassName() {
        return UserGroupRole.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Map<String, Function<UserGroupRole, Object>> attributeGetterFunctions = this.getAttributeGetterFunctions();
        for (Map.Entry<String, Function<UserGroupRole, Object>> entry : attributeGetterFunctions.entrySet()) {
            String attributeName = entry.getKey();
            Function<UserGroupRole, Object> attributeGetterFunction = entry.getValue();
            attributes.put(attributeName, attributeGetterFunction.apply((UserGroupRole)((Object)this)));
        }
        attributes.put("entityCacheEnabled", this.isEntityCacheEnabled());
        attributes.put("finderCacheEnabled", this.isFinderCacheEnabled());
        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Map<String, BiConsumer<UserGroupRole, Object>> attributeSetterBiConsumers = this.getAttributeSetterBiConsumers();
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            String attributeName = entry.getKey();
            BiConsumer<UserGroupRole, Object> attributeSetterBiConsumer = attributeSetterBiConsumers.get(attributeName);
            if (attributeSetterBiConsumer == null) continue;
            attributeSetterBiConsumer.accept((UserGroupRole)((Object)this), entry.getValue());
        }
    }

    public Map<String, Function<UserGroupRole, Object>> getAttributeGetterFunctions() {
        return _attributeGetterFunctions;
    }

    public Map<String, BiConsumer<UserGroupRole, Object>> getAttributeSetterBiConsumers() {
        return _attributeSetterBiConsumers;
    }

    private static Function<InvocationHandler, UserGroupRole> _getProxyProviderFunction() {
        Class<?> proxyClass = ProxyUtil.getProxyClass(UserGroupRole.class.getClassLoader(), UserGroupRole.class, ModelWrapper.class);
        try {
            Constructor<?> constructor = proxyClass.getConstructor(InvocationHandler.class);
            return invocationHandler -> {
                try {
                    return (UserGroupRole)constructor.newInstance(invocationHandler);
                }
                catch (ReflectiveOperationException roe) {
                    throw new InternalError(roe);
                }
            };
        }
        catch (NoSuchMethodException nsme) {
            throw new InternalError(nsme);
        }
    }

    @Override
    @JSON
    public long getMvccVersion() {
        return this._mvccVersion;
    }

    @Override
    public void setMvccVersion(long mvccVersion) {
        this._mvccVersion = mvccVersion;
    }

    @Override
    @JSON
    public long getUserId() {
        return this._userId;
    }

    @Override
    public void setUserId(long userId) {
        this._columnBitmask |= 4L;
        if (!this._setOriginalUserId) {
            this._setOriginalUserId = true;
            this._originalUserId = this._userId;
        }
        this._userId = userId;
    }

    @Override
    public String getUserUuid() {
        try {
            User user = UserLocalServiceUtil.getUserById(this.getUserId());
            return user.getUuid();
        }
        catch (PortalException pe) {
            return "";
        }
    }

    @Override
    public void setUserUuid(String userUuid) {
    }

    public long getOriginalUserId() {
        return this._originalUserId;
    }

    @Override
    @JSON
    public long getGroupId() {
        return this._groupId;
    }

    @Override
    public void setGroupId(long groupId) {
        this._columnBitmask |= 1L;
        if (!this._setOriginalGroupId) {
            this._setOriginalGroupId = true;
            this._originalGroupId = this._groupId;
        }
        this._groupId = groupId;
    }

    public long getOriginalGroupId() {
        return this._originalGroupId;
    }

    @Override
    @JSON
    public long getRoleId() {
        return this._roleId;
    }

    @Override
    public void setRoleId(long roleId) {
        this._columnBitmask |= 2L;
        if (!this._setOriginalRoleId) {
            this._setOriginalRoleId = true;
            this._originalRoleId = this._roleId;
        }
        this._roleId = roleId;
    }

    public long getOriginalRoleId() {
        return this._originalRoleId;
    }

    @Override
    @JSON
    public long getCompanyId() {
        return this._companyId;
    }

    @Override
    public void setCompanyId(long companyId) {
        this._companyId = companyId;
    }

    public long getColumnBitmask() {
        return this._columnBitmask;
    }

    @Override
    public UserGroupRole toEscapedModel() {
        if (this._escapedModel == null) {
            this._escapedModel = _escapedModelProxyProviderFunction.apply(new AutoEscapeBeanHandler(this));
        }
        return this._escapedModel;
    }

    @Override
    public Object clone() {
        UserGroupRoleImpl userGroupRoleImpl = new UserGroupRoleImpl();
        userGroupRoleImpl.setMvccVersion(this.getMvccVersion());
        userGroupRoleImpl.setUserId(this.getUserId());
        userGroupRoleImpl.setGroupId(this.getGroupId());
        userGroupRoleImpl.setRoleId(this.getRoleId());
        userGroupRoleImpl.setCompanyId(this.getCompanyId());
        userGroupRoleImpl.resetOriginalValues();
        return userGroupRoleImpl;
    }

    @Override
    public int compareTo(UserGroupRole userGroupRole) {
        UserGroupRolePK primaryKey = userGroupRole.getPrimaryKey();
        return this.getPrimaryKey().compareTo(primaryKey);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UserGroupRole)) {
            return false;
        }
        UserGroupRole userGroupRole = (UserGroupRole)obj;
        UserGroupRolePK primaryKey = userGroupRole.getPrimaryKey();
        return this.getPrimaryKey().equals(primaryKey);
    }

    public int hashCode() {
        return this.getPrimaryKey().hashCode();
    }

    @Override
    public boolean isEntityCacheEnabled() {
        return ENTITY_CACHE_ENABLED;
    }

    @Override
    public boolean isFinderCacheEnabled() {
        return FINDER_CACHE_ENABLED;
    }

    @Override
    public void resetOriginalValues() {
        UserGroupRoleModelImpl userGroupRoleModelImpl = this;
        userGroupRoleModelImpl._originalUserId = userGroupRoleModelImpl._userId;
        userGroupRoleModelImpl._setOriginalUserId = false;
        userGroupRoleModelImpl._originalGroupId = userGroupRoleModelImpl._groupId;
        userGroupRoleModelImpl._setOriginalGroupId = false;
        userGroupRoleModelImpl._originalRoleId = userGroupRoleModelImpl._roleId;
        userGroupRoleModelImpl._setOriginalRoleId = false;
        userGroupRoleModelImpl._columnBitmask = 0L;
    }

    @Override
    public CacheModel<UserGroupRole> toCacheModel() {
        UserGroupRoleCacheModel userGroupRoleCacheModel = new UserGroupRoleCacheModel();
        userGroupRoleCacheModel.userGroupRolePK = this.getPrimaryKey();
        userGroupRoleCacheModel.mvccVersion = this.getMvccVersion();
        userGroupRoleCacheModel.userId = this.getUserId();
        userGroupRoleCacheModel.groupId = this.getGroupId();
        userGroupRoleCacheModel.roleId = this.getRoleId();
        userGroupRoleCacheModel.companyId = this.getCompanyId();
        return userGroupRoleCacheModel;
    }

    public String toString() {
        Map<String, Function<UserGroupRole, Object>> attributeGetterFunctions = this.getAttributeGetterFunctions();
        StringBundler sb = new StringBundler(4 * attributeGetterFunctions.size() + 2);
        sb.append("{");
        for (Map.Entry<String, Function<UserGroupRole, Object>> entry : attributeGetterFunctions.entrySet()) {
            String attributeName = entry.getKey();
            Function<UserGroupRole, Object> attributeGetterFunction = entry.getValue();
            sb.append(attributeName);
            sb.append("=");
            sb.append(attributeGetterFunction.apply((UserGroupRole)((Object)this)));
            sb.append(", ");
        }
        if (sb.index() > 1) {
            sb.setIndex(sb.index() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public String toXmlString() {
        Map<String, Function<UserGroupRole, Object>> attributeGetterFunctions = this.getAttributeGetterFunctions();
        StringBundler sb = new StringBundler(5 * attributeGetterFunctions.size() + 4);
        sb.append("<model><model-name>");
        sb.append(this.getModelClassName());
        sb.append("</model-name>");
        for (Map.Entry<String, Function<UserGroupRole, Object>> entry : attributeGetterFunctions.entrySet()) {
            String attributeName = entry.getKey();
            Function<UserGroupRole, Object> attributeGetterFunction = entry.getValue();
            sb.append("<column><column-name>");
            sb.append(attributeName);
            sb.append("</column-name><column-value><![CDATA[");
            sb.append(attributeGetterFunction.apply((UserGroupRole)((Object)this)));
            sb.append("]]></column-value></column>");
        }
        sb.append("</model>");
        return sb.toString();
    }

    static {
        TABLE_COLUMNS_MAP.put("mvccVersion", -5);
        TABLE_COLUMNS_MAP.put("userId", -5);
        TABLE_COLUMNS_MAP.put("groupId", -5);
        TABLE_COLUMNS_MAP.put("roleId", -5);
        TABLE_COLUMNS_MAP.put("companyId", -5);
        ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(PropsUtil.get("value.object.entity.cache.enabled.com.liferay.portal.kernel.model.UserGroupRole"), true);
        FINDER_CACHE_ENABLED = GetterUtil.getBoolean(PropsUtil.get("value.object.finder.cache.enabled.com.liferay.portal.kernel.model.UserGroupRole"), true);
        COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(PropsUtil.get("value.object.column.bitmask.enabled.com.liferay.portal.kernel.model.UserGroupRole"), true);
        LOCK_EXPIRATION_TIME = GetterUtil.getLong(PropsUtil.get("lock.expiration.time.com.liferay.portal.kernel.model.UserGroupRole"));
        LinkedHashMap<String, Function<UserGroupRole, Object>> attributeGetterFunctions = new LinkedHashMap<String, Function<UserGroupRole, Object>>();
        LinkedHashMap<String, BiConsumer<UserGroupRole, Long>> attributeSetterBiConsumers = new LinkedHashMap<String, BiConsumer<UserGroupRole, Long>>();
        attributeGetterFunctions.put("mvccVersion", UserGroupRoleModel::getMvccVersion);
        attributeSetterBiConsumers.put("mvccVersion", UserGroupRoleModel::setMvccVersion);
        attributeGetterFunctions.put("userId", UserGroupRoleModel::getUserId);
        attributeSetterBiConsumers.put("userId", UserGroupRoleModel::setUserId);
        attributeGetterFunctions.put("groupId", UserGroupRoleModel::getGroupId);
        attributeSetterBiConsumers.put("groupId", UserGroupRoleModel::setGroupId);
        attributeGetterFunctions.put("roleId", UserGroupRoleModel::getRoleId);
        attributeSetterBiConsumers.put("roleId", UserGroupRoleModel::setRoleId);
        attributeGetterFunctions.put("companyId", UserGroupRoleModel::getCompanyId);
        attributeSetterBiConsumers.put("companyId", UserGroupRoleModel::setCompanyId);
        _attributeGetterFunctions = Collections.unmodifiableMap(attributeGetterFunctions);
        _attributeSetterBiConsumers = Collections.unmodifiableMap(attributeSetterBiConsumers);
        _escapedModelProxyProviderFunction = UserGroupRoleModelImpl._getProxyProviderFunction();
    }
}

