/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.PortletDecorator;
import com.liferay.portal.kernel.model.SpriteImage;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.ThemeSetting;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.servlet.PortalWebResourcesUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.template.TemplateResourceLoaderUtil;
import com.liferay.portal.kernel.theme.PortletDecoratorFactoryUtil;
import com.liferay.portal.kernel.theme.ThemeCompanyId;
import com.liferay.portal.kernel.theme.ThemeCompanyLimit;
import com.liferay.portal.kernel.theme.ThemeGroupLimit;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.PluginBaseImpl;
import com.liferay.portal.model.impl.ThemeSettingImpl;
import com.liferay.portal.util.PropsValues;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;

public class ThemeImpl
extends PluginBaseImpl
implements Theme {
    private static final Log _log = LogFactoryUtil.getLog(ThemeImpl.class);
    private final Map<String, ColorScheme> _colorSchemesMap = new HashMap<String, ColorScheme>();
    private boolean _controlPanelTheme;
    private String _cssPath = "${root-path}/css";
    private PortletDecorator _defaultPortletDecorator;
    private String _imagesPath = "${root-path}/images";
    private String _javaScriptPath = "${root-path}/js";
    private boolean _loadFromServletContext;
    private String _name;
    private boolean _pageTheme;
    private final Map<String, PortletDecorator> _portletDecoratorsMap = new HashMap<String, PortletDecorator>();
    private final Map<String, Boolean> _resourceExistsMap = new ConcurrentHashMap<String, Boolean>();
    private final Map<String, String> _resourcePathsMap = new ConcurrentHashMap<String, String>();
    private String _rootPath = "/";
    private String _servletContextName = "";
    private final Map<String, SpriteImage> _spriteImagesMap = new HashMap<String, SpriteImage>();
    private String _templateExtension = "ftl";
    private String _templatesPath = "${root-path}/templates";
    private ThemeCompanyLimit _themeCompanyLimit;
    private ThemeGroupLimit _themeGroupLimit;
    private final String _themeId;
    private final Map<String, ThemeSetting> _themeSettingsMap = new LinkedHashMap<String, ThemeSetting>();
    private long _timestamp;
    private String _virtualPath = "";
    private boolean _warFile;

    public ThemeImpl() {
        this(null);
    }

    public ThemeImpl(String themeId) {
        this(themeId, null);
    }

    public ThemeImpl(String themeId, String name) {
        this._themeId = themeId;
        this._name = name;
    }

    @Override
    public void addSetting(String key, String value, boolean configurable, String type, String[] options, String script) {
        ThemeSettingImpl themeSetting = new ThemeSettingImpl(configurable, options, script, type, value);
        this._themeSettingsMap.put(key, themeSetting);
    }

    @Override
    public int compareTo(Theme theme) {
        return this.getName().compareTo(theme.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Theme)) {
            return false;
        }
        Theme theme = (Theme)obj;
        String themeId = theme.getThemeId();
        return this.getThemeId().equals(themeId);
    }

    @Override
    public List<ColorScheme> getColorSchemes() {
        List<ColorScheme> colorSchemes = ListUtil.fromMapValues(this._colorSchemesMap);
        return ListUtil.sort(colorSchemes);
    }

    @Override
    public Map<String, ColorScheme> getColorSchemesMap() {
        return this._colorSchemesMap;
    }

    @Override
    public Map<String, ThemeSetting> getConfigurableSettings() {
        LinkedHashMap<String, ThemeSetting> configurableSettings = new LinkedHashMap<String, ThemeSetting>();
        for (Map.Entry<String, ThemeSetting> entry : this._themeSettingsMap.entrySet()) {
            ThemeSetting themeSetting = entry.getValue();
            if (!themeSetting.isConfigurable()) continue;
            configurableSettings.put(entry.getKey(), entry.getValue());
        }
        return configurableSettings;
    }

    @Override
    public String getContextPath() {
        if (!this.isWARFile()) {
            return PortalUtil.getPathContext();
        }
        String servletContextName = this.getServletContextName();
        if (ServletContextPool.containsKey(servletContextName)) {
            ServletContext servletContext = ServletContextPool.get(servletContextName);
            String proxyPath = PortalUtil.getPathProxy();
            return proxyPath.concat(servletContext.getContextPath());
        }
        String portalPathContext = PortalUtil.getPathContext();
        return portalPathContext.concat("/".concat(servletContextName));
    }

    @Override
    public String getCssPath() {
        return this._cssPath;
    }

    public PortletDecorator getDefaultPortletDecorator() {
        if (this._defaultPortletDecorator == null) {
            List<PortletDecorator> portletDecorators = this.getPortletDecorators();
            for (int i = portletDecorators.size() - 1; i >= 0; --i) {
                PortletDecorator portletDecorator = portletDecorators.get(i);
                if (!portletDecorator.isDefaultPortletDecorator()) continue;
                this._defaultPortletDecorator = portletDecorator;
                break;
            }
            if (this._defaultPortletDecorator == null) {
                this._defaultPortletDecorator = PortletDecoratorFactoryUtil.getDefaultPortletDecorator();
            }
        }
        return this._defaultPortletDecorator;
    }

    @Override
    public String getDevice() {
        return "regular";
    }

    @Override
    public String getFreeMarkerTemplateLoader() {
        if (this._loadFromServletContext) {
            return "_SERVLET_CONTEXT_";
        }
        return "_THEME_LOADER_CONTEXT_";
    }

    @Override
    public String getImagesPath() {
        return this._imagesPath;
    }

    @Override
    public String getJavaScriptPath() {
        return this._javaScriptPath;
    }

    @Override
    public boolean getLoadFromServletContext() {
        return this._loadFromServletContext;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getPluginId() {
        return this.getThemeId();
    }

    @Override
    public String getPluginType() {
        return "theme";
    }

    @Override
    public List<PortletDecorator> getPortletDecorators() {
        List<PortletDecorator> portletDecorators = ListUtil.fromMapValues(this._portletDecoratorsMap);
        return ListUtil.sort(portletDecorators);
    }

    @Override
    public Map<String, PortletDecorator> getPortletDecoratorsMap() {
        return this._portletDecoratorsMap;
    }

    @Override
    public String getResourcePath(ServletContext servletContext, String portletId, String path) {
        String resourcePath;
        if (!PropsValues.LAYOUT_TEMPLATE_CACHE_ENABLED) {
            return this._getResourcePath(servletContext, portletId, path);
        }
        String key = path;
        if (Validator.isNotNull(portletId)) {
            key = path.concat("#").concat(portletId);
        }
        if ((resourcePath = this._resourcePathsMap.get(key)) != null) {
            return resourcePath;
        }
        resourcePath = this._getResourcePath(servletContext, portletId, path);
        this._resourcePathsMap.put(key, resourcePath);
        return resourcePath;
    }

    @Override
    public String getRootPath() {
        return this._rootPath;
    }

    @Override
    public String getServletContextName() {
        return this._servletContextName;
    }

    @Override
    public String getSetting(String key) {
        String value = null;
        ThemeSetting themeSetting = this._themeSettingsMap.get(key);
        if (themeSetting != null) {
            value = themeSetting.getValue();
        }
        return value;
    }

    @Override
    public String[] getSettingOptions(String key) {
        String[] options = null;
        ThemeSetting themeSetting = this._themeSettingsMap.get(key);
        if (themeSetting != null) {
            options = themeSetting.getOptions();
        }
        return options;
    }

    @Override
    public Map<String, ThemeSetting> getSettings() {
        return this._themeSettingsMap;
    }

    @Override
    public Properties getSettingsProperties() {
        Properties properties = new Properties();
        for (Map.Entry<String, ThemeSetting> entry : this._themeSettingsMap.entrySet()) {
            ThemeSetting setting = entry.getValue();
            if (setting == null) continue;
            properties.setProperty(entry.getKey(), setting.getValue());
        }
        return properties;
    }

    @Override
    public SpriteImage getSpriteImage(String fileName) {
        return this._spriteImagesMap.get(fileName);
    }

    @Override
    public String getStaticResourcePath() {
        String proxyPath = PortalUtil.getPathProxy();
        String virtualPath = this.getVirtualPath();
        if (Validator.isNotNull(virtualPath)) {
            return proxyPath.concat(virtualPath);
        }
        if (this.isWARFile()) {
            return this.getContextPath();
        }
        String contextPath = null;
        if (this._themeId.equals("admin")) {
            contextPath = PortalWebResourcesUtil.getModuleContextPath("theme_admin");
        } else if (this._themeId.equals("classic")) {
            contextPath = PortalWebResourcesUtil.getModuleContextPath("theme_classic");
        }
        if (Validator.isNull(contextPath)) {
            return proxyPath;
        }
        return proxyPath.concat(contextPath);
    }

    @Override
    public String getTemplateExtension() {
        return this._templateExtension;
    }

    @Override
    public String getTemplatesPath() {
        return this._templatesPath;
    }

    @Override
    public ThemeCompanyLimit getThemeCompanyLimit() {
        return this._themeCompanyLimit;
    }

    @Override
    public ThemeGroupLimit getThemeGroupLimit() {
        return this._themeGroupLimit;
    }

    @Override
    public String getThemeId() {
        return this._themeId;
    }

    @Override
    public long getTimestamp() {
        return this._timestamp;
    }

    @Override
    public String getVelocityResourceListener() {
        if (this._loadFromServletContext) {
            return "_SERVLET_CONTEXT_";
        }
        return "_THEME_LOADER_CONTEXT_";
    }

    @Override
    public String getVirtualPath() {
        return this._virtualPath;
    }

    @Override
    public boolean getWARFile() {
        return this._warFile;
    }

    @Override
    public boolean hasColorSchemes() {
        return !this._colorSchemesMap.isEmpty();
    }

    public int hashCode() {
        return this._themeId.hashCode();
    }

    @Override
    public boolean isCompanyAvailable(long companyId) {
        return this.isAvailable(this.getThemeCompanyLimit(), companyId);
    }

    @Override
    public boolean isControlPanelTheme() {
        return this._controlPanelTheme;
    }

    @Override
    public boolean isGroupAvailable(long groupId) {
        return this.isAvailable(this.getThemeGroupLimit(), groupId);
    }

    @Override
    public boolean isLoadFromServletContext() {
        return this._loadFromServletContext;
    }

    @Override
    public boolean isPageTheme() {
        return this._pageTheme;
    }

    @Override
    public boolean isWARFile() {
        return this._warFile;
    }

    @Override
    public boolean resourceExists(ServletContext servletContext, String portletId, String path) throws Exception {
        Boolean resourceExists;
        if (!PropsValues.LAYOUT_TEMPLATE_CACHE_ENABLED) {
            return this._resourceExists(servletContext, portletId, path);
        }
        if (Validator.isNull(path)) {
            return false;
        }
        String key = path;
        if (Validator.isNotNull(portletId)) {
            key = path.concat("#").concat(portletId);
        }
        if ((resourceExists = this._resourceExistsMap.get(key)) != null) {
            return resourceExists;
        }
        resourceExists = this._resourceExists(servletContext, portletId, path);
        this._resourceExistsMap.put(key, resourceExists);
        return resourceExists;
    }

    @Override
    public void setControlPanelTheme(boolean controlPanelTheme) {
        this._controlPanelTheme = controlPanelTheme;
    }

    @Override
    public void setCssPath(String cssPath) {
        this._cssPath = cssPath;
    }

    @Override
    public void setImagesPath(String imagesPath) {
        this._imagesPath = imagesPath;
    }

    @Override
    public void setJavaScriptPath(String javaScriptPath) {
        this._javaScriptPath = javaScriptPath;
    }

    @Override
    public void setLoadFromServletContext(boolean loadFromServletContext) {
        this._loadFromServletContext = loadFromServletContext;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public void setPageTheme(boolean pageTheme) {
        this._pageTheme = pageTheme;
    }

    @Override
    public void setRootPath(String rootPath) {
        this._rootPath = rootPath;
    }

    @Override
    public void setServletContextName(String servletContextName) {
        this._servletContextName = servletContextName;
        this._warFile = Validator.isNotNull(this._servletContextName);
    }

    @Override
    public void setSetting(String key, String value) {
        ThemeSetting themeSetting = this._themeSettingsMap.get(key);
        if (themeSetting != null) {
            themeSetting.setValue(value);
        } else {
            this.addSetting(key, value, false, null, null, null);
        }
    }

    @Override
    public void setSpriteImages(String spriteFileName, Properties spriteProperties) {
        for (Map.Entry<Object, Object> entry : spriteProperties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            int[] values = StringUtil.split(value, 0);
            int offset = values[0];
            int height = values[1];
            int width = values[2];
            SpriteImage spriteImage = new SpriteImage(spriteFileName, key, offset, height, width);
            this._spriteImagesMap.put(key, spriteImage);
        }
    }

    @Override
    public void setTemplateExtension(String templateExtension) {
        this._templateExtension = templateExtension;
    }

    @Override
    public void setTemplatesPath(String templatesPath) {
        this._templatesPath = templatesPath;
    }

    @Override
    public void setThemeCompanyLimit(ThemeCompanyLimit themeCompanyLimit) {
        this._themeCompanyLimit = themeCompanyLimit;
    }

    @Override
    public void setThemeGroupLimit(ThemeGroupLimit themeGroupLimit) {
        this._themeGroupLimit = themeGroupLimit;
    }

    @Override
    public void setTimestamp(long timestamp) {
        this._timestamp = timestamp;
    }

    @Override
    public void setVirtualPath(String virtualPath) {
        if (this._warFile && Validator.isNull(virtualPath)) {
            virtualPath = PropsValues.THEME_VIRTUAL_PATH;
        }
        this._virtualPath = virtualPath;
    }

    protected boolean isAvailable(ThemeCompanyLimit limit, long id) {
        boolean available = true;
        if (_log.isDebugEnabled()) {
            _log.debug(StringBundler.concat("Check if theme ", this.getThemeId(), " is available for ", id));
        }
        if (limit != null) {
            List<ThemeCompanyId> includes = limit.getIncludes();
            List<ThemeCompanyId> excludes = limit.getExcludes();
            if (!includes.isEmpty() && !excludes.isEmpty()) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Check includes and excludes");
                }
                if (available = limit.isIncluded(id)) {
                    available = !limit.isExcluded(id);
                }
            } else if (includes.isEmpty() && !excludes.isEmpty()) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Check excludes");
                }
                available = !limit.isExcluded(id);
            } else if (!includes.isEmpty() && excludes.isEmpty()) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Check includes");
                }
                available = limit.isIncluded(id);
            } else {
                if (_log.isDebugEnabled()) {
                    _log.debug("No includes or excludes set");
                }
                available = true;
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug(StringBundler.concat("Theme ", this.getThemeId(), " is ", !available ? "NOT " : "", "available for ", id));
        }
        return available;
    }

    private String _getResourcePath(ServletContext servletContext, String portletId, String path) {
        StringBundler sb = new StringBundler(11);
        String themeContextName = GetterUtil.getString(this.getServletContextName());
        sb.append(themeContextName);
        String servletContextName = "";
        String contextPath = servletContext.getContextPath();
        if (!Objects.equals(PortalUtil.getPathContext(contextPath), PortalUtil.getPathContext())) {
            servletContextName = GetterUtil.getString(servletContext.getServletContextName());
        }
        sb.append(this.getFreeMarkerTemplateLoader());
        sb.append(this.getTemplatesPath());
        if (Validator.isNotNull(servletContextName) && !path.startsWith("/".concat(servletContextName))) {
            sb.append("/");
            sb.append(servletContextName);
        }
        sb.append("/");
        int start = 0;
        if (path.startsWith("/")) {
            start = 1;
        }
        int end = path.lastIndexOf(46);
        sb.append(path.substring(start, end));
        sb.append(".");
        if (Validator.isNotNull(portletId)) {
            sb.append(portletId);
            sb.append(".");
        }
        sb.append("ftl");
        return sb.toString();
    }

    private boolean _resourceExists(ServletContext servletContext, String portletId, String path) throws Exception {
        if (Validator.isNull(path)) {
            return false;
        }
        Boolean exists = null;
        if (Validator.isNotNull(portletId)) {
            exists = TemplateResourceLoaderUtil.hasTemplateResource("ftl", this.getResourcePath(servletContext, portletId, path));
            if (!exists.booleanValue() && PortletIdCodec.hasInstanceId(portletId)) {
                String rootPortletId = PortletIdCodec.decodePortletName(portletId);
                exists = TemplateResourceLoaderUtil.hasTemplateResource("ftl", this.getResourcePath(servletContext, rootPortletId, path));
            }
            if (!exists.booleanValue()) {
                exists = TemplateResourceLoaderUtil.hasTemplateResource("ftl", this.getResourcePath(servletContext, null, path));
            }
        }
        if (exists == null) {
            exists = TemplateResourceLoaderUtil.hasTemplateResource("ftl", this.getResourcePath(servletContext, portletId, path));
        }
        return exists;
    }
}

