/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.RoleConstants;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.service.TeamLocalServiceUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.RoleBaseImpl;

public class RoleImpl
extends RoleBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(RoleImpl.class);

    @Override
    public String getDescriptiveName() throws PortalException {
        String name = this.getName();
        if (this.isTeam()) {
            Team team = TeamLocalServiceUtil.getTeam(this.getClassPK());
            name = team.getName();
        }
        return name;
    }

    @Override
    public String getTitle(String languageId) {
        String value = super.getTitle(languageId);
        if (Validator.isNull(value)) {
            try {
                value = this.getDescriptiveName();
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
        return value;
    }

    @Override
    public String getTitle(String languageId, boolean useDefault) {
        String value = super.getTitle(languageId, useDefault);
        if (Validator.isNull(value)) {
            try {
                value = this.getDescriptiveName();
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
        return value;
    }

    @Override
    public String getTypeLabel() {
        return RoleConstants.getTypeLabel(this.getType());
    }

    @Override
    public boolean isSystem() {
        return PortalUtil.isSystemRole(this.getName());
    }

    @Override
    public boolean isTeam() {
        return this.getClassNameId() == ClassNameIds._TEAM_CLASS_NAME_ID;
    }

    private static class ClassNameIds {
        private static final long _TEAM_CLASS_NAME_ID = PortalUtil.getClassNameId(Team.class);

        private ClassNameIds() {
        }
    }
}

