/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.model.EventDefinition;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.model.PortletFilter;
import com.liferay.portal.kernel.model.PortletURLListener;
import com.liferay.portal.kernel.model.PublicRenderParameter;
import com.liferay.portal.kernel.model.SpriteImage;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.model.impl.PublicRenderParameterImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;

public class PortletAppImpl
implements PortletApp {
    private final Map<String, String[]> _containerRuntimeOptions = new HashMap<String, String[]>();
    private String _contextPath = "";
    private final Map<String, String> _customUserAttributes = new LinkedHashMap<String, String>();
    private String _defaultNamespace = "";
    private final Set<EventDefinition> _eventDefinitions = new LinkedHashSet<EventDefinition>();
    private final Set<PortletFilter> _portletFilters = new LinkedHashSet<PortletFilter>();
    private final Map<String, PortletFilter> _portletFiltersMap = new HashMap<String, PortletFilter>();
    private final Set<Portlet> _portlets = new LinkedHashSet<Portlet>();
    private final Set<PortletURLListener> _portletURLListeners = new LinkedHashSet<PortletURLListener>();
    private final Map<String, PortletURLListener> _portletURLListenersMap = new HashMap<String, PortletURLListener>();
    private final Map<String, PublicRenderParameter> _publicRenderParametersMap = new HashMap<String, PublicRenderParameter>();
    private ServletContext _servletContext;
    private final String _servletContextName;
    private final Set<String> _servletURLPatterns = new LinkedHashSet<String>();
    private int _specMajorVersion = 2;
    private int _specMinorVersion;
    private final Map<String, SpriteImage> _spriteImagesMap = new HashMap<String, SpriteImage>();
    private final Set<String> _userAttributes = new LinkedHashSet<String>();
    private boolean _warFile;

    public PortletAppImpl(String servletContextName) {
        this._servletContextName = servletContextName;
        if (Validator.isNotNull(this._servletContextName)) {
            this._contextPath = "/".concat(this._servletContextName);
            this._warFile = true;
        } else {
            this._warFile = false;
        }
    }

    @Override
    public void addEventDefinition(EventDefinition eventDefinition) {
        this._eventDefinitions.add(eventDefinition);
    }

    @Override
    public void addPortlet(Portlet portlet) {
        this._portlets.add(portlet);
    }

    @Override
    public void addPortletFilter(PortletFilter portletFilter) {
        this._portletFilters.add(portletFilter);
        this._portletFiltersMap.put(portletFilter.getFilterName(), portletFilter);
    }

    @Override
    public void addPortletURLListener(PortletURLListener portletURLListener) {
        this._portletURLListeners.add(portletURLListener);
        this._portletURLListenersMap.put(portletURLListener.getListenerClass(), portletURLListener);
    }

    @Override
    public void addPublicRenderParameter(PublicRenderParameter publicRenderParameter) {
        this._publicRenderParametersMap.put(publicRenderParameter.getIdentifier(), publicRenderParameter);
    }

    @Override
    public void addPublicRenderParameter(String identifier, QName qName) {
        PublicRenderParameterImpl publicRenderParameter = new PublicRenderParameterImpl(identifier, qName, this);
        this.addPublicRenderParameter(publicRenderParameter);
    }

    @Override
    public void addServletURLPatterns(Set<String> servletURLPatterns) {
        this._servletURLPatterns.addAll(servletURLPatterns);
    }

    @Override
    public Map<String, String[]> getContainerRuntimeOptions() {
        return this._containerRuntimeOptions;
    }

    @Override
    public String getContextPath() {
        return this._contextPath;
    }

    @Override
    public Map<String, String> getCustomUserAttributes() {
        return this._customUserAttributes;
    }

    @Override
    public String getDefaultNamespace() {
        return this._defaultNamespace;
    }

    @Override
    public Set<EventDefinition> getEventDefinitions() {
        return this._eventDefinitions;
    }

    @Override
    public PortletFilter getPortletFilter(String filterName) {
        return this._portletFiltersMap.get(filterName);
    }

    @Override
    public Set<PortletFilter> getPortletFilters() {
        return this._portletFilters;
    }

    @Override
    public List<Portlet> getPortlets() {
        return new ArrayList<Portlet>(this._portlets);
    }

    @Override
    public PortletURLListener getPortletURLListener(String listenerClass) {
        return this._portletURLListenersMap.get(listenerClass);
    }

    @Override
    public Set<PortletURLListener> getPortletURLListeners() {
        return this._portletURLListeners;
    }

    @Override
    public PublicRenderParameter getPublicRenderParameter(String identifier) {
        return this._publicRenderParametersMap.get(identifier);
    }

    @Override
    public ServletContext getServletContext() {
        return this._servletContext;
    }

    @Override
    public String getServletContextName() {
        return this._servletContextName;
    }

    @Override
    public Set<String> getServletURLPatterns() {
        return this._servletURLPatterns;
    }

    @Override
    public int getSpecMajorVersion() {
        return this._specMajorVersion;
    }

    @Override
    public int getSpecMinorVersion() {
        return this._specMinorVersion;
    }

    @Override
    public SpriteImage getSpriteImage(String fileName) {
        return this._spriteImagesMap.get(fileName);
    }

    @Override
    public Set<String> getUserAttributes() {
        return this._userAttributes;
    }

    @Override
    public boolean isWARFile() {
        return this._warFile;
    }

    @Override
    public void removePortlet(Portlet portletModel) {
        this._portlets.remove(portletModel);
    }

    @Override
    public void setDefaultNamespace(String defaultNamespace) {
        this._defaultNamespace = defaultNamespace;
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
        this._contextPath = this._servletContext.getContextPath();
    }

    @Override
    public void setSpecMajorVersion(int specMajorVersion) {
        this._specMajorVersion = specMajorVersion;
    }

    @Override
    public void setSpecMinorVersion(int specMinorVersion) {
        this._specMinorVersion = specMinorVersion;
    }

    @Override
    public void setSpriteImages(String spriteFileName, Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            int[] values = StringUtil.split(value, 0);
            int offset = values[0];
            int height = values[1];
            int width = values[2];
            SpriteImage spriteImage = new SpriteImage(spriteFileName, key, offset, height, width);
            this._spriteImagesMap.put(key, spriteImage);
        }
    }

    @Override
    public void setWARFile(boolean warFile) {
        this._warFile = warFile;
    }
}

