/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.PluginSetting;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.impl.PluginSettingBaseImpl;

public class PluginSettingImpl
extends PluginSettingBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(PluginSettingImpl.class);
    private String[] _rolesArray;

    public PluginSettingImpl() {
    }

    public PluginSettingImpl(PluginSetting pluginSetting) {
        this.setCompanyId(pluginSetting.getCompanyId());
        this.setPluginId(pluginSetting.getPluginId());
        this.setPluginType(pluginSetting.getPluginType());
        this.setRoles(pluginSetting.getRoles());
        this.setActive(pluginSetting.isActive());
    }

    @Override
    public void addRole(String role) {
        this.setRolesArray(ArrayUtil.append(this._rolesArray, role));
    }

    @Override
    public String[] getRolesArray() {
        return this._rolesArray;
    }

    @Override
    public boolean hasPermission(long userId) {
        try {
            if (this._rolesArray.length == 0) {
                return true;
            }
            if (RoleLocalServiceUtil.hasUserRoles(userId, this.getCompanyId(), this._rolesArray, true)) {
                return true;
            }
            if (RoleLocalServiceUtil.hasUserRole(userId, this.getCompanyId(), "Administrator", true)) {
                return true;
            }
            User user = UserLocalServiceUtil.getUserById(userId);
            if (user.isDefaultUser() && this.hasRoleWithName("Guest")) {
                return true;
            }
        }
        catch (Exception e) {
            _log.error("Unable to check if user " + userId + " has permission", e);
        }
        return false;
    }

    @Override
    public boolean hasRoleWithName(String roleName) {
        for (String curRoleName : this._rolesArray) {
            if (!StringUtil.equalsIgnoreCase(curRoleName, roleName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setRoles(String roles) {
        this._rolesArray = StringUtil.split(roles);
        super.setRoles(roles);
    }

    @Override
    public void setRolesArray(String[] rolesArray) {
        this._rolesArray = rolesArray;
        super.setRoles(StringUtil.merge(rolesArray));
    }
}

