/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.service.AddressLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.PortalPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.AddressImpl;
import com.liferay.portal.model.impl.GroupImpl;
import com.liferay.portal.model.impl.OrganizationBaseImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.portlet.PortletPreferences;

public class OrganizationImpl
extends OrganizationBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(OrganizationImpl.class);

    public static String[] getChildrenTypes(String type) {
        return OrganizationLocalServiceUtil.getChildrenTypes(type);
    }

    public static String[] getParentTypes(String type) {
        String[] types = OrganizationLocalServiceUtil.getTypes();
        ArrayList<String> parentTypes = new ArrayList<String>();
        for (String curType : types) {
            if (!ArrayUtil.contains(OrganizationImpl.getChildrenTypes(curType), type)) continue;
            parentTypes.add(curType);
        }
        return parentTypes.toArray(new String[0]);
    }

    public static boolean isParentable(String type) {
        String[] childrenTypes = OrganizationImpl.getChildrenTypes(type);
        return childrenTypes.length > 0;
    }

    public static boolean isRootable(String type) {
        return OrganizationLocalServiceUtil.isRootable(type);
    }

    @Override
    public Address getAddress() {
        Address address = null;
        try {
            List<Address> addresses = this.getAddresses();
            if (!addresses.isEmpty()) {
                address = addresses.get(0);
            }
        }
        catch (Exception e) {
            _log.error("Unable to get address", e);
        }
        if (address == null) {
            address = new AddressImpl();
        }
        return address;
    }

    @Override
    public List<Address> getAddresses() {
        return AddressLocalServiceUtil.getAddresses(this.getCompanyId(), Organization.class.getName(), this.getOrganizationId());
    }

    @Override
    public long[] getAncestorOrganizationIds() throws PortalException {
        if (Validator.isNull(this.getTreePath())) {
            List<Organization> ancestorOrganizations = this.getAncestors();
            long[] ancestorOrganizationIds = new long[ancestorOrganizations.size()];
            for (int i = 0; i < ancestorOrganizations.size(); ++i) {
                Organization organization = ancestorOrganizations.get(i);
                ancestorOrganizationIds[ancestorOrganizations.size() - i - 1] = organization.getOrganizationId();
            }
            return ancestorOrganizationIds;
        }
        long[] primaryKeys = StringUtil.split(this.getTreePath(), "/", 0L);
        if (primaryKeys.length <= 2) {
            return new long[0];
        }
        long[] ancestorOrganizationIds = new long[primaryKeys.length - 2];
        System.arraycopy(primaryKeys, 1, ancestorOrganizationIds, 0, primaryKeys.length - 2);
        return ancestorOrganizationIds;
    }

    @Override
    public List<Organization> getAncestors() throws PortalException {
        ArrayList<Organization> ancestors = new ArrayList<Organization>();
        Organization organization = this;
        while (!organization.isRoot()) {
            organization = organization.getParentOrganization();
            ancestors.add(organization);
        }
        return ancestors;
    }

    @Override
    public String[] getChildrenTypes() {
        return OrganizationImpl.getChildrenTypes(this.getType());
    }

    @Override
    public List<Organization> getDescendants() {
        return OrganizationLocalServiceUtil.getOrganizations(this.getCompanyId(), this.getTreePath().concat("_%"));
    }

    @Override
    public Group getGroup() {
        if (this.getOrganizationId() > 0L) {
            try {
                return GroupLocalServiceUtil.getOrganizationGroup(this.getCompanyId(), this.getOrganizationId());
            }
            catch (Exception e) {
                _log.error("Unable to get organization group", e);
            }
        }
        return new GroupImpl();
    }

    @Override
    public long getGroupId() {
        Group group = this.getGroup();
        return group.getGroupId();
    }

    @Override
    public Organization getParentOrganization() throws PortalException {
        if (this.getParentOrganizationId() == 0L) {
            return null;
        }
        return OrganizationLocalServiceUtil.getOrganization(this.getParentOrganizationId());
    }

    @Override
    public String getParentOrganizationName() {
        if (this.getParentOrganizationId() == 0L) {
            return "";
        }
        Organization parentOrganization = OrganizationLocalServiceUtil.fetchOrganization(this.getParentOrganizationId());
        if (parentOrganization != null) {
            return parentOrganization.getName();
        }
        return "";
    }

    @Override
    public PortletPreferences getPreferences() {
        long ownerId = this.getOrganizationId();
        int ownerType = 6;
        return PortalPreferencesLocalServiceUtil.getPreferences(ownerId, ownerType);
    }

    @Override
    public int getPrivateLayoutsPageCount() {
        try {
            Group group = this.getGroup();
            if (group == null) {
                return 0;
            }
            return group.getPrivateLayoutsPageCount();
        }
        catch (Exception e) {
            _log.error(e, e);
            return 0;
        }
    }

    @Override
    public int getPublicLayoutsPageCount() {
        try {
            Group group = this.getGroup();
            if (group == null) {
                return 0;
            }
            return group.getPublicLayoutsPageCount();
        }
        catch (Exception e) {
            _log.error(e, e);
            return 0;
        }
    }

    @Override
    public Set<String> getReminderQueryQuestions(Locale locale) {
        return this.getReminderQueryQuestions(LanguageUtil.getLanguageId(locale));
    }

    @Override
    public Set<String> getReminderQueryQuestions(String languageId) {
        PortletPreferences preferences = this.getPreferences();
        String[] questions = StringUtil.splitLines(LocalizationUtil.getPreferencesValue(preferences, "reminderQueries", languageId, false));
        return SetUtil.fromArray(questions);
    }

    @Override
    public List<Organization> getSuborganizations() {
        return OrganizationLocalServiceUtil.getSuborganizations(this.getCompanyId(), this.getOrganizationId());
    }

    @Override
    public int getSuborganizationsSize() {
        return OrganizationLocalServiceUtil.getSuborganizationsCount(this.getCompanyId(), this.getOrganizationId());
    }

    @Override
    public int getTypeOrder() {
        String[] types = OrganizationLocalServiceUtil.getTypes();
        for (int i = 0; i < types.length; ++i) {
            String type = types[i];
            if (!type.equals(this.getType())) continue;
            return i + 1;
        }
        return 0;
    }

    @Override
    public boolean hasPrivateLayouts() {
        return this.getPrivateLayoutsPageCount() > 0;
    }

    @Override
    public boolean hasPublicLayouts() {
        return this.getPublicLayoutsPageCount() > 0;
    }

    @Override
    public boolean hasSuborganizations() {
        return this.getSuborganizationsSize() > 0;
    }

    @Override
    public boolean isParentable() {
        return OrganizationImpl.isParentable(this.getType());
    }

    @Override
    public boolean isRoot() {
        return this.getParentOrganizationId() == 0L;
    }
}

