/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.model.impl.OrganizationModelImpl;
import java.util.ArrayList;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class OrganizationBaseImpl
extends OrganizationModelImpl
implements Organization {
    @Override
    public void persist() {
        if (this.isNew()) {
            OrganizationLocalServiceUtil.addOrganization(this);
        } else {
            OrganizationLocalServiceUtil.updateOrganization(this);
        }
    }

    @Override
    public String buildTreePath() throws PortalException {
        ArrayList<OrganizationBaseImpl> organizations = new ArrayList<OrganizationBaseImpl>();
        Organization organization = this;
        while (organization != null) {
            organizations.add((OrganizationBaseImpl)organization);
            organization = OrganizationLocalServiceUtil.fetchOrganization(organization.getParentOrganizationId());
        }
        StringBundler sb = new StringBundler(organizations.size() * 2 + 1);
        sb.append("/");
        for (int i = organizations.size() - 1; i >= 0; --i) {
            organization = (Organization)organizations.get(i);
            sb.append(organization.getOrganizationId());
            sb.append("/");
        }
        return sb.toString();
    }

    @Override
    public void updateTreePath(String treePath) {
        OrganizationBaseImpl organization = this;
        organization.setTreePath(treePath);
        OrganizationLocalServiceUtil.updateOrganization(organization);
    }
}

