/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.counter.kernel.service.CounterLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.CustomizedPages;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutTemplate;
import com.liferay.portal.kernel.model.LayoutTypeAccessPolicy;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletPreferencesIds;
import com.liferay.portal.kernel.model.PortletWrapper;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletLayoutListener;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.LayoutTemplateLocalServiceUtil;
import com.liferay.portal.kernel.service.PluginSettingLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LayoutTypePortletFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.model.impl.LayoutTemplateImpl;
import com.liferay.portal.model.impl.LayoutTypeImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.sites.kernel.util.SitesUtil;
import com.liferay.util.JS;
import java.text.DateFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.portlet.PortletPreferences;

public class LayoutTypePortletImpl
extends LayoutTypeImpl
implements LayoutTypePortlet {
    private static final String _MODIFIED_DATE = "modifiedDate";
    private static final String _NESTED_PORTLETS_NAMESPACE = PortalUtil.getPortletNamespace("com_liferay_nested_portlets_web_portlet_NestedPortletsPortlet");
    private static final String _NULL_DATE = "00000000000000";
    private static final Log _log = LogFactoryUtil.getLog(LayoutTypePortletImpl.class);
    private static final Layout _nullLayout = new LayoutImpl();
    private String _addedCustomPortletMode;
    private boolean _customizedView;
    private final Format _dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat(PropsValues.INDEX_DATE_FORMAT_PATTERN);
    private boolean _enablePortletLayoutListener = true;
    private Group _group;
    private Layout _layoutSetPrototypeLayout;
    private PortalPreferences _portalPreferences;
    private boolean _updatePermission;

    public LayoutTypePortletImpl(Layout layout, LayoutTypeController layoutTypeController, LayoutTypeAccessPolicy layoutTypeAccessPolicy) {
        super(layout, layoutTypeController, layoutTypeAccessPolicy);
    }

    @Override
    public void addModeAboutPortletId(String portletId) {
        this.removeModesPortletId(portletId);
        this.setModeAbout(StringUtil.add(this.getModeAbout(), portletId));
    }

    @Override
    public void addModeConfigPortletId(String portletId) {
        this.removeModesPortletId(portletId);
        this.setModeConfig(StringUtil.add(this.getModeConfig(), portletId));
    }

    @Override
    public void addModeCustomPortletId(String portletId, String portletMode) {
        this.removeModesPortletId(portletId);
        this.setModeCustom(StringUtil.add(this.getModeCustom(portletMode), portletId), portletMode);
        this._addedCustomPortletMode = portletMode;
    }

    @Override
    public void addModeEditDefaultsPortletId(String portletId) {
        this.removeModesPortletId(portletId);
        this.setModeEditDefaults(StringUtil.add(this.getModeEditDefaults(), portletId));
    }

    @Override
    public void addModeEditGuestPortletId(String portletId) {
        this.removeModesPortletId(portletId);
        this.setModeEditGuest(StringUtil.add(this.getModeEditGuest(), portletId));
    }

    @Override
    public void addModeEditPortletId(String portletId) {
        this.removeModesPortletId(portletId);
        this.setModeEdit(StringUtil.add(this.getModeEdit(), portletId));
    }

    @Override
    public void addModeHelpPortletId(String portletId) {
        this.removeModesPortletId(portletId);
        this.setModeHelp(StringUtil.add(this.getModeHelp(), portletId));
    }

    @Override
    public void addModePreviewPortletId(String portletId) {
        this.removeModesPortletId(portletId);
        this.setModePreview(StringUtil.add(this.getModePreview(), portletId));
    }

    @Override
    public void addModePrintPortletId(String portletId) {
        this.removeModesPortletId(portletId);
        this.setModePrint(StringUtil.add(this.getModePrint(), portletId));
    }

    @Override
    public String addPortletId(long userId, String portletId) {
        return this.addPortletId(userId, portletId, true);
    }

    @Override
    public String addPortletId(long userId, String portletId, boolean checkPermission) {
        return this.addPortletId(userId, portletId, null, -1, checkPermission);
    }

    @Override
    public String addPortletId(long userId, String portletId, String columnId, int columnPos) {
        return this.addPortletId(userId, portletId, columnId, columnPos, true);
    }

    @Override
    public String addPortletId(long userId, String portletId, String columnId, int columnPos, boolean checkPermission) {
        return this.addPortletId(userId, portletId, columnId, columnPos, checkPermission, false);
    }

    @Override
    public void addPortletIds(long userId, String[] portletIds, boolean checkPermission) {
        for (String portletId : portletIds) {
            this.addPortletId(userId, portletId, checkPermission);
        }
    }

    @Override
    public void addPortletIds(long userId, String[] portletIds, String columnId, boolean checkPermission) {
        for (String portletId : portletIds) {
            this.addPortletId(userId, portletId, columnId, -1, checkPermission);
        }
    }

    @Override
    public void addStateMaxPortletId(String portletId) {
        this.removeStatesPortletId(portletId);
        this.setStateMax(StringUtil.add("", portletId));
    }

    @Override
    public void addStateMinPortletId(String portletId) {
        this.removeStateMaxPortletId(portletId);
        this.setStateMin(StringUtil.add(this.getStateMin(), portletId));
    }

    @Override
    public List<Portlet> addStaticPortlets(List<Portlet> portlets, List<Portlet> startPortlets, List<Portlet> endPortlets) {
        if (startPortlets == null) {
            startPortlets = new ArrayList<Portlet>();
        }
        if (endPortlets == null) {
            endPortlets = new ArrayList<Portlet>();
        }
        if (startPortlets.isEmpty() && endPortlets.isEmpty()) {
            return portlets;
        }
        ArrayList<Portlet> list = new ArrayList<Portlet>(portlets.size() + startPortlets.size() + endPortlets.size());
        if (!startPortlets.isEmpty()) {
            list.addAll(startPortlets);
        }
        for (Portlet portlet : portlets) {
            if (startPortlets.contains(portlet) || endPortlets.contains(portlet)) continue;
            list.add(portlet);
        }
        if (!endPortlets.isEmpty()) {
            list.addAll(endPortlets);
        }
        return list;
    }

    @Override
    public String getAddedCustomPortletMode() {
        return this._addedCustomPortletMode;
    }

    @Override
    public List<Portlet> getAllPortlets() {
        List<Portlet> explicitlyAddedPortlets = this.getExplicitlyAddedPortlets();
        List<Portlet> staticPortlets = this.getStaticPortlets("layout.static.portlets.all");
        List<Portlet> embeddedPortlets = this.getEmbeddedPortlets();
        return this.addStaticPortlets(explicitlyAddedPortlets, staticPortlets, embeddedPortlets);
    }

    @Override
    public List<Portlet> getAllPortlets(boolean includeSystem) {
        List<Portlet> portlets = this.getAllPortlets();
        if (includeSystem) {
            return portlets;
        }
        ArrayList<Portlet> filteredPortlets = new ArrayList<Portlet>();
        for (Portlet portlet : portlets) {
            if (portlet.isSystem() && !includeSystem) continue;
            filteredPortlets.add(portlet);
        }
        return filteredPortlets;
    }

    @Override
    public List<Portlet> getAllPortlets(String columnId) {
        String columnValue = this.getColumnValue(columnId);
        String[] portletIds = StringUtil.split(columnValue);
        ArrayList<Portlet> portlets = new ArrayList<Portlet>(portletIds.length);
        for (String portletId : portletIds) {
            Portlet portlet = PortletLocalServiceUtil.getPortletById(this.getCompanyId(), portletId);
            if (portlet == null) continue;
            portlets.add(portlet);
        }
        List<Portlet> startPortlets = this.getStaticPortlets("layout.static.portlets.start." + columnId);
        List<Portlet> endPortlets = this.getStaticPortlets("layout.static.portlets.end." + columnId);
        return this.addStaticPortlets(portlets, startPortlets, endPortlets);
    }

    @Override
    public List<Portlet> getEmbeddedPortlets() {
        Layout layout = this.getLayout();
        return layout.getEmbeddedPortlets();
    }

    @Override
    public List<Portlet> getExplicitlyAddedPortlets() {
        ArrayList<Portlet> portlets = new ArrayList<Portlet>();
        List<String> columns = this.getColumns();
        for (String columnId : columns) {
            portlets.addAll(this.getAllPortlets(columnId));
        }
        return portlets;
    }

    @Override
    public Layout getLayoutSetPrototypeLayout() {
        if (this._layoutSetPrototypeLayout == null) {
            this._layoutSetPrototypeLayout = SitesUtil.getLayoutSetPrototypeLayout(this.getLayout());
            if (this._layoutSetPrototypeLayout == null) {
                this._layoutSetPrototypeLayout = _nullLayout;
            }
        }
        if (this._layoutSetPrototypeLayout == _nullLayout) {
            return null;
        }
        return this._layoutSetPrototypeLayout;
    }

    @Override
    public String getLayoutSetPrototypeLayoutProperty(String key) {
        Layout layoutSetPrototypeLayout = this.getLayoutSetPrototypeLayout();
        if (layoutSetPrototypeLayout == null) {
            return "";
        }
        UnicodeProperties typeSettingsProperties = layoutSetPrototypeLayout.getTypeSettingsProperties();
        return typeSettingsProperties.getProperty(key);
    }

    @Override
    public LayoutTemplate getLayoutTemplate() {
        String themeId = this.getThemeId();
        LayoutTemplate layoutTemplate = LayoutTemplateLocalServiceUtil.getLayoutTemplate(this.getLayoutTemplateId(), false, themeId);
        if (layoutTemplate == null) {
            layoutTemplate = new LayoutTemplateImpl("", "");
            ArrayList<String> columns = new ArrayList<String>(10);
            for (int i = 1; i <= 10; ++i) {
                columns.add("column-" + i);
            }
            layoutTemplate.setColumns(columns);
        }
        return layoutTemplate;
    }

    @Override
    public String getLayoutTemplateId() {
        return GetterUtil.getString(this.getTypeSettingsProperty("layout-template-id"));
    }

    @Override
    public String getModeAbout() {
        return this.getTypeSettingsProperty("mode-about");
    }

    @Override
    public String getModeConfig() {
        return this.getTypeSettingsProperty("mode-config");
    }

    @Override
    public String getModeCustom(String portletMode) {
        return this.getTypeSettingsProperty("mode-" + portletMode);
    }

    @Override
    public String getModeEdit() {
        return this.getTypeSettingsProperty("mode-edit");
    }

    @Override
    public String getModeEditDefaults() {
        return this.getTypeSettingsProperty("mode-edit-defaults");
    }

    @Override
    public String getModeEditGuest() {
        return this.getTypeSettingsProperty("mode-edit-guest");
    }

    @Override
    public String getModeHelp() {
        return this.getTypeSettingsProperty("mode-help");
    }

    @Override
    public String getModePreview() {
        return this.getTypeSettingsProperty("mode-preview");
    }

    @Override
    public String getModePrint() {
        return this.getTypeSettingsProperty("mode-print");
    }

    @Override
    public int getNumOfColumns() {
        LayoutTemplate layoutTemplate = this.getLayoutTemplate();
        List<String> columns = layoutTemplate.getColumns();
        return columns.size();
    }

    @Override
    public PortalPreferences getPortalPreferences() {
        return this._portalPreferences;
    }

    @Override
    public List<String> getPortletIds() {
        ArrayList<String> portletIds = new ArrayList<String>();
        for (String column : this.getColumns()) {
            Collections.addAll(portletIds, StringUtil.split(this.getColumnValue(column)));
        }
        return portletIds;
    }

    @Override
    public List<Portlet> getPortlets() {
        List<String> portletIds = this.getPortletIds();
        ArrayList<Portlet> portlets = new ArrayList<Portlet>(portletIds.size());
        for (String portletId : portletIds) {
            Portlet portlet = PortletLocalServiceUtil.getPortletById(this.getCompanyId(), portletId);
            if (portlet == null) continue;
            portlets.add(portlet);
        }
        return portlets;
    }

    @Override
    public String getStateMax() {
        return this.getTypeSettingsProperty("state-max");
    }

    @Override
    public String getStateMaxPortletId() {
        String[] stateMax = StringUtil.split(this.getStateMax());
        if (stateMax.length > 0) {
            return stateMax[0];
        }
        return "";
    }

    @Override
    public String getStateMin() {
        return this.getTypeSettingsProperty("state-min");
    }

    @Override
    public boolean hasDefaultScopePortletId(long groupId, String portletId) {
        long scopeGroupId;
        return this.hasPortletId(portletId) && groupId == (scopeGroupId = PortalUtil.getScopeGroupId(this.getLayout(), portletId));
    }

    @Override
    public boolean hasModeAboutPortletId(String portletId) {
        return StringUtil.contains(this.getModeAbout(), portletId);
    }

    @Override
    public boolean hasModeConfigPortletId(String portletId) {
        return StringUtil.contains(this.getModeConfig(), portletId);
    }

    @Override
    public boolean hasModeCustomPortletId(String portletId, String portletMode) {
        return StringUtil.contains(this.getModeCustom(portletMode), portletId);
    }

    @Override
    public boolean hasModeEditDefaultsPortletId(String portletId) {
        return StringUtil.contains(this.getModeEditDefaults(), portletId);
    }

    @Override
    public boolean hasModeEditGuestPortletId(String portletId) {
        return StringUtil.contains(this.getModeEditGuest(), portletId);
    }

    @Override
    public boolean hasModeEditPortletId(String portletId) {
        return StringUtil.contains(this.getModeEdit(), portletId);
    }

    @Override
    public boolean hasModeHelpPortletId(String portletId) {
        return StringUtil.contains(this.getModeHelp(), portletId);
    }

    @Override
    public boolean hasModePreviewPortletId(String portletId) {
        return StringUtil.contains(this.getModePreview(), portletId);
    }

    @Override
    public boolean hasModePrintPortletId(String portletId) {
        return StringUtil.contains(this.getModePrint(), portletId);
    }

    @Override
    public boolean hasModeViewPortletId(String portletId) {
        return !this.hasModeAboutPortletId(portletId) && !this.hasModeConfigPortletId(portletId) && !this.hasModeEditPortletId(portletId) && !this.hasModeEditDefaultsPortletId(portletId) && !this.hasModeEditGuestPortletId(portletId) && !this.hasModeHelpPortletId(portletId) && !this.hasModePreviewPortletId(portletId) && !this.hasModePrintPortletId(portletId);
    }

    @Override
    public boolean hasPortletId(String portletId) {
        return this.hasPortletId(portletId, false);
    }

    @Override
    public boolean hasPortletId(String portletId, boolean strict) {
        LayoutTypePortletImpl defaultLayoutTypePortletImpl;
        List<String> columns = this.getColumns();
        for (String columnId : columns) {
            if (this.hasNonstaticPortletId(columnId, portletId)) {
                return true;
            }
            if (!this.hasStaticPortletId(columnId, portletId)) continue;
            return true;
        }
        Layout layout = this.getLayout();
        if (layout.isTypeControlPanel()) {
            return false;
        }
        if (this.isCustomizable() && this.isCustomizedView() && (defaultLayoutTypePortletImpl = this.getDefaultLayoutTypePortletImpl()).hasNonstaticPortletId(portletId)) {
            return false;
        }
        if (strict) {
            return false;
        }
        long count1 = PortletPreferencesLocalServiceUtil.getPortletPreferencesCount(3, layout.getPlid(), portletId);
        long count2 = PortletPreferencesLocalServiceUtil.getPortletPreferencesCount(4, layout.getPlid(), portletId);
        return count1 > 0L || count2 > 0L;
    }

    @Override
    public boolean hasStateMax() {
        String[] stateMax = StringUtil.split(this.getStateMax());
        return stateMax.length > 0;
    }

    @Override
    public boolean hasStateMaxPortletId(String portletId) {
        return StringUtil.contains(this.getStateMax(), portletId);
    }

    @Override
    public boolean hasStateMin() {
        String[] stateMin = StringUtil.split(this.getStateMin());
        return stateMin.length > 0;
    }

    @Override
    public boolean hasStateMinPortletId(String portletId) {
        return StringUtil.contains(this.getStateMin(), portletId);
    }

    @Override
    public boolean hasStateNormalPortletId(String portletId) {
        return !this.hasStateMaxPortletId(portletId) && !this.hasStateMinPortletId(portletId);
    }

    @Override
    public boolean hasUpdatePermission() {
        return this._updatePermission;
    }

    @Override
    public boolean isCacheable() {
        ArrayList<Portlet> portlets = new ArrayList<Portlet>();
        for (String string : this.getColumns()) {
            List<Portlet> columnPortlets = this.getAllPortlets(string);
            for (Portlet portlet : columnPortlets) {
                Portlet rootPortlet = portlet.getRootPortlet();
                if (rootPortlet.isLayoutCacheable()) continue;
                return false;
            }
            portlets.addAll(columnPortlets);
        }
        List<Portlet> staticPortlets = this.getStaticPortlets("layout.static.portlets.all");
        for (Portlet portlet : staticPortlets) {
            Portlet rootPortlet = portlet.getRootPortlet();
            if (rootPortlet.isLayoutCacheable()) continue;
            return false;
        }
        List<Portlet> list = this.getEmbeddedPortlets();
        for (Portlet portlet : list) {
            Portlet rootPortlet = portlet.getRootPortlet();
            if (rootPortlet.isLayoutCacheable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isColumnCustomizable(String columnId) {
        String columnValue;
        String customizableString = this.getTypeSettingsProperty(CustomizedPages.namespaceColumnId(columnId));
        boolean customizable = GetterUtil.getBoolean(customizableString);
        if (customizable) {
            return !this.isLayoutSetPrototype();
        }
        if (this.hasUserPreferences() && !Objects.equals(columnValue = this._portalPreferences.getValue(CustomizedPages.namespacePlid(this.getPlid()), columnId, "null"), "null")) {
            this.setUserPreference(columnId, null);
        }
        return false;
    }

    @Override
    public boolean isColumnDisabled(String columnId) {
        return this.isCustomizedView() && !this.isColumnCustomizable(columnId) || !this.isCustomizedView() && !this.hasUpdatePermission();
    }

    @Override
    public boolean isCustomizable() {
        for (String columnId : this.getColumns()) {
            if (!this.isColumnCustomizable(columnId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCustomizedView() {
        return this._customizedView;
    }

    @Override
    public boolean isDefaultUpdated() {
        if (!this.isCustomizedView() || !this.hasUserPreferences()) {
            return false;
        }
        String preferencesModifiedDateString = this._portalPreferences.getValue(CustomizedPages.namespacePlid(this.getPlid()), _MODIFIED_DATE, _NULL_DATE);
        DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat(PropsValues.INDEX_DATE_FORMAT_PATTERN);
        try {
            Date preferencesModifiedDate = dateFormat.parse(preferencesModifiedDateString);
            Layout layout = this.getLayout();
            String propertiesModifiedDateString = layout.getTypeSettingsProperty(_MODIFIED_DATE, _NULL_DATE);
            Date propertiesModifiedDate = dateFormat.parse(propertiesModifiedDateString);
            return propertiesModifiedDate.after(preferencesModifiedDate);
        }
        catch (Exception e) {
            _log.error(e, e);
            return false;
        }
    }

    @Override
    public boolean isPortletCustomizable(String portletId) {
        return this.isColumnCustomizable(this.getColumn(portletId));
    }

    @Override
    public boolean isPortletEmbedded(String portletId) {
        Layout layout = this.getLayout();
        return layout.isPortletEmbedded(portletId, layout.getGroupId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void movePortletId(long userId, String portletId, String columnId, int columnPos) {
        if (!this.hasPortletId(portletId)) {
            return;
        }
        this._enablePortletLayoutListener = false;
        try {
            this.removePortletId(userId, portletId, false);
            this.addPortletId(userId, portletId, columnId, columnPos, false, true);
        }
        finally {
            this._enablePortletLayoutListener = true;
        }
        Layout layout = this.getLayout();
        try {
            PortletLayoutListener portletLayoutListener;
            Portlet portlet = PortletLocalServiceUtil.getPortletById(layout.getCompanyId(), portletId);
            if (portlet != null && (portletLayoutListener = portlet.getPortletLayoutListenerInstance()) != null) {
                portletLayoutListener.onMoveInLayout(portletId, layout.getPlid());
            }
        }
        catch (Exception e) {
            _log.error("Unable to fire portlet layout listener event", e);
        }
    }

    @Override
    public void removeCustomization(UnicodeProperties typeSettingsProperties) {
        for (String columnId : this.getColumns()) {
            if (!this.isColumnCustomizable(columnId) || !GetterUtil.getBoolean(this.getTypeSettingsProperty(CustomizedPages.namespaceColumnId(columnId)))) continue;
            typeSettingsProperties.remove(CustomizedPages.namespaceColumnId(columnId));
        }
    }

    @Override
    public void removeModeAboutPortletId(String portletId) {
        this.setModeAbout(StringUtil.removeFromList(this.getModeAbout(), portletId));
    }

    @Override
    public void removeModeConfigPortletId(String portletId) {
        this.setModeConfig(StringUtil.removeFromList(this.getModeConfig(), portletId));
    }

    @Override
    public void removeModeEditDefaultsPortletId(String portletId) {
        this.setModeEditDefaults(StringUtil.removeFromList(this.getModeEditDefaults(), portletId));
    }

    @Override
    public void removeModeEditGuestPortletId(String portletId) {
        this.setModeEditGuest(StringUtil.removeFromList(this.getModeEditGuest(), portletId));
    }

    @Override
    public void removeModeEditPortletId(String portletId) {
        this.setModeEdit(StringUtil.removeFromList(this.getModeEdit(), portletId));
    }

    @Override
    public void removeModeHelpPortletId(String portletId) {
        this.setModeHelp(StringUtil.removeFromList(this.getModeHelp(), portletId));
    }

    @Override
    public void removeModePreviewPortletId(String portletId) {
        this.setModePreview(StringUtil.removeFromList(this.getModePreview(), portletId));
    }

    @Override
    public void removeModePrintPortletId(String portletId) {
        this.setModePrint(StringUtil.removeFromList(this.getModePrint(), portletId));
    }

    @Override
    public void removeModesPortletId(String portletId) {
        this.removeModeAboutPortletId(portletId);
        this.removeModeConfigPortletId(portletId);
        this.removeModeEditPortletId(portletId);
        this.removeModeEditDefaultsPortletId(portletId);
        this.removeModeEditGuestPortletId(portletId);
        this.removeModeHelpPortletId(portletId);
        this.removeModePreviewPortletId(portletId);
        this.removeModePrintPortletId(portletId);
    }

    @Override
    public void removeNestedColumns(String portletNamespace) {
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
        UnicodeProperties newTypeSettingsProperties = new UnicodeProperties();
        for (Map.Entry entry : typeSettingsProperties.entrySet()) {
            String key = (String)entry.getKey();
            if (key.startsWith(portletNamespace)) continue;
            newTypeSettingsProperties.setProperty(key, (String)entry.getValue());
        }
        Layout layout = this.getLayout();
        layout.setTypeSettingsProperties(newTypeSettingsProperties);
        String nestedColumnIds = GetterUtil.getString(this.getTypeSettingsProperty("nested-column-ids"));
        Object[] nestedColumnIdsArray = ArrayUtil.removeByPrefix(StringUtil.split(nestedColumnIds), portletNamespace);
        this.setTypeSettingsProperty("nested-column-ids", StringUtil.merge(nestedColumnIdsArray));
    }

    @Override
    public void removePortletId(long userId, String portletId) {
        this.removePortletId(userId, portletId, true);
    }

    @Override
    public void removePortletId(long userId, String portletId, boolean cleanUp) {
        try {
            Portlet portlet = PortletLocalServiceUtil.getPortletById(this.getCompanyId(), portletId);
            if (portlet == null) {
                _log.error("Portlet " + portletId + " cannot be removed because it is not registered");
                return;
            }
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            if (!LayoutPermissionUtil.contains(permissionChecker, this.getLayout(), "UPDATE") && !this.isCustomizable()) {
                return;
            }
        }
        catch (Exception e) {
            _log.error(e, e);
            return;
        }
        List<String> columns = this.getColumns();
        for (String columnId : columns) {
            if (this.isCustomizable() && this.isColumnDisabled(columnId)) continue;
            String columnValue = null;
            columnValue = this.hasUserPreferences() ? this.getUserPreference(columnId) : this.getTypeSettingsProperty(columnId);
            if (StringUtil.endsWith(columnValue = StringUtil.removeFromList(columnValue, portletId), ",")) {
                columnValue = columnValue.substring(0, columnValue.length() - 1);
            }
            if (this.hasUserPreferences()) {
                this.setUserPreference(columnId, columnValue);
                continue;
            }
            this.setTypeSettingsProperty(columnId, columnValue);
        }
        if (cleanUp) {
            try {
                this.onRemoveFromLayout(new String[]{portletId});
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
    }

    @Override
    public void removeStateMaxPortletId(String portletId) {
        this.setStateMax(StringUtil.removeFromList(this.getStateMax(), portletId));
    }

    @Override
    public void removeStateMinPortletId(String portletId) {
        this.setStateMin(StringUtil.removeFromList(this.getStateMin(), portletId));
    }

    @Override
    public void removeStatesPortletId(String portletId) {
        this.removeStateMaxPortletId(portletId);
        this.removeStateMinPortletId(portletId);
    }

    @Override
    public void reorganizePortlets(List<String> newColumns, List<String> oldColumns) {
        String lastNewColumnId = newColumns.get(newColumns.size() - 1);
        String lastNewColumnValue = this.getTypeSettingsProperty(lastNewColumnId);
        for (String oldColumnId : oldColumns) {
            String[] portletIds;
            if (newColumns.contains(oldColumnId)) continue;
            String oldColumnValue = this.getTypeSettingsProperties().remove(oldColumnId);
            for (String portletId : portletIds = StringUtil.split(oldColumnValue)) {
                lastNewColumnValue = StringUtil.add(lastNewColumnValue, portletId);
            }
        }
        this.setTypeSettingsProperty(lastNewColumnId, lastNewColumnValue);
    }

    @Override
    public void resetModes() {
        this.setModeAbout("");
        this.setModeConfig("");
        this.setModeEdit("");
        this.setModeEditDefaults("");
        this.setModeEditGuest("");
        this.setModeHelp("");
        this.setModePreview("");
        this.setModePrint("");
    }

    @Override
    public void resetStates() {
        this.setStateMax("");
        this.setStateMin("");
    }

    @Override
    public void resetUserPreferences() {
        if (!this.hasUserPreferences()) {
            return;
        }
        long plid = this.getPlid();
        HashSet<String> customPortletIds = new HashSet<String>();
        for (String columnId : this.getColumns()) {
            String value = this._portalPreferences.getValue(CustomizedPages.namespacePlid(plid), columnId);
            for (String customPortletId : StringUtil.split(value)) {
                customPortletIds.add(customPortletId);
            }
        }
        try {
            this.onRemoveFromLayout(customPortletIds.toArray(new String[0]));
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        this._portalPreferences.resetValues(CustomizedPages.namespacePlid(plid));
        this._portalPreferences.setValue(CustomizedPages.namespacePlid(plid), _MODIFIED_DATE, this._dateFormat.format(new Date()));
    }

    @Override
    public void setCustomizedView(boolean customizedView) {
        this._customizedView = customizedView;
    }

    @Override
    public void setLayoutTemplateId(long userId, String newLayoutTemplateId) {
        this.setLayoutTemplateId(userId, newLayoutTemplateId, true);
    }

    @Override
    public void setLayoutTemplateId(long userId, String newLayoutTemplateId, boolean checkPermission) {
        if (checkPermission && !PluginSettingLocalServiceUtil.hasPermission(userId, newLayoutTemplateId, "layouttpl")) {
            return;
        }
        String themeId = this.getThemeId();
        LayoutTemplate newLayoutTemplate = LayoutTemplateLocalServiceUtil.getLayoutTemplate(newLayoutTemplateId, false, themeId);
        if (newLayoutTemplate == null) {
            if (_log.isWarnEnabled()) {
                _log.warn("Unable to find layout template " + newLayoutTemplateId);
            }
            return;
        }
        List<String> newColumns = newLayoutTemplate.getColumns();
        LayoutTemplate oldLayoutTemplate = this.getLayoutTemplate();
        List<String> oldColumns = oldLayoutTemplate.getColumns();
        this.reorganizePortlets(newColumns, oldColumns);
        this.setTypeSettingsProperty("layout-template-id", newLayoutTemplateId);
    }

    @Override
    public void setModeAbout(String modeAbout) {
        this.setTypeSettingsProperty("mode-about", modeAbout);
    }

    @Override
    public void setModeConfig(String modeConfig) {
        this.setTypeSettingsProperty("mode-config", modeConfig);
    }

    @Override
    public void setModeCustom(String modeCustom, String portletMode) {
        this.setTypeSettingsProperty("mode-" + portletMode, modeCustom);
    }

    @Override
    public void setModeEdit(String modeEdit) {
        this.setTypeSettingsProperty("mode-edit", modeEdit);
    }

    @Override
    public void setModeEditDefaults(String modeEditDefaults) {
        this.setTypeSettingsProperty("mode-edit-defaults", modeEditDefaults);
    }

    @Override
    public void setModeEditGuest(String modeEditGuest) {
        this.setTypeSettingsProperty("mode-edit-guest", modeEditGuest);
    }

    @Override
    public void setModeHelp(String modeHelp) {
        this.setTypeSettingsProperty("mode-help", modeHelp);
    }

    @Override
    public void setModePreview(String modePreview) {
        this.setTypeSettingsProperty("mode-preview", modePreview);
    }

    @Override
    public void setModePrint(String modePrint) {
        this.setTypeSettingsProperty("mode-print", modePrint);
    }

    @Override
    public void setPortalPreferences(PortalPreferences portalPreferences) {
        this._portalPreferences = portalPreferences;
    }

    @Override
    public void setStateMax(String stateMax) {
        this.setTypeSettingsProperty("state-max", stateMax);
    }

    @Override
    public void setStateMin(String stateMin) {
        this.setTypeSettingsProperty("state-min", stateMin);
    }

    @Override
    public void setUpdatePermission(boolean updatePermission) {
        this._updatePermission = updatePermission;
    }

    protected void addNestedColumn(String columnId) {
        String nestedColumnIds = this.getTypeSettingsProperty("nested-column-ids", "");
        if (!nestedColumnIds.contains(columnId)) {
            nestedColumnIds = StringUtil.add(nestedColumnIds, columnId);
            this.setTypeSettingsProperty("nested-column-ids", nestedColumnIds);
        }
    }

    protected String addPortletId(long userId, String portletId, String columnId, int columnPos, boolean checkPermission, boolean strictHasPortlet) {
        LayoutTemplate layoutTemplate;
        List<String> columns;
        portletId = JS.getSafeName(portletId);
        Layout layout = this.getLayout();
        Portlet portlet = null;
        try {
            portlet = PortletLocalServiceUtil.getPortletById(layout.getCompanyId(), portletId);
            if (portlet == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn("Portlet " + portletId + " cannot be added because it is not registered");
                }
                return null;
            }
            if (checkPermission && !PortletPermissionUtil.contains(PermissionThreadLocal.getPermissionChecker(), layout, portlet, "ADD_TO_PAGE")) {
                return null;
            }
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        if (portlet.isSystem()) {
            return null;
        }
        if (portlet.isInstanceable() && !PortletIdCodec.hasInstanceId(portletId)) {
            PortletIdCodec.validatePortletName(portletId);
            portletId = PortletIdCodec.encode(portletId);
        }
        if (this.hasPortletId(portletId, strictHasPortlet)) {
            return null;
        }
        if (columnId == null && !(columns = (layoutTemplate = this.getLayoutTemplate()).getColumns()).isEmpty()) {
            columnId = columns.get(0);
        }
        if (columnId == null) {
            return null;
        }
        if (this.isCustomizable()) {
            if (this.isColumnDisabled(columnId)) {
                return null;
            }
            if (this.hasUserPreferences()) {
                portletId = PortletIdCodec.encode(PortletIdCodec.decodePortletName(portletId), userId, PortletIdCodec.decodeInstanceId(portletId));
            }
        }
        String columnValue = "";
        columnValue = this.hasUserPreferences() ? this.getUserPreference(columnId) : this.getTypeSettingsProperty(columnId);
        if (columnValue == null && columnId.startsWith(_NESTED_PORTLETS_NAMESPACE)) {
            this.addNestedColumn(columnId);
        }
        if (columnPos >= 0) {
            List<String> portletIds = ListUtil.fromArray(StringUtil.split(columnValue));
            if (columnPos <= portletIds.size()) {
                portletIds.add(columnPos, portletId);
            } else {
                portletIds.add(portletId);
            }
            columnValue = StringUtil.merge(portletIds);
        } else {
            columnValue = StringUtil.add(columnValue, portletId);
        }
        if (this.hasUserPreferences()) {
            this.setUserPreference(columnId, columnValue);
        } else {
            this.setTypeSettingsProperty(columnId, columnValue);
        }
        try {
            PortletLayoutListener portletLayoutListener;
            if (this._enablePortletLayoutListener && !portlet.isUndeployedPortlet() && (portletLayoutListener = portlet.getPortletLayoutListenerInstance()) != null) {
                portletLayoutListener.onAddToLayout(portletId, layout.getPlid());
            }
        }
        catch (Exception e) {
            _log.error("Unable to fire portlet layout listener event", e);
        }
        return portletId;
    }

    protected void copyPreferences(long userId, String sourcePortletId, String targetPortletId) {
        Layout layout = this.getLayout();
        try {
            PortletPreferencesIds portletPreferencesIds = PortletPreferencesFactoryUtil.getPortletPreferencesIds(layout.getGroupId(), 0L, layout, sourcePortletId, false);
            PortletPreferences sourcePortletPreferences = PortletPreferencesLocalServiceUtil.getStrictPreferences(portletPreferencesIds);
            portletPreferencesIds = PortletPreferencesFactoryUtil.getPortletPreferencesIds(layout.getGroupId(), userId, layout, targetPortletId, false);
            PortletPreferencesLocalServiceUtil.updatePreferences(portletPreferencesIds.getOwnerId(), portletPreferencesIds.getOwnerType(), portletPreferencesIds.getPlid(), portletPreferencesIds.getPortletId(), sourcePortletPreferences);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void copyResourcePermissions(String sourcePortletId, String targetPortletId) {
        Layout layout = this.getLayout();
        Portlet portlet = PortletLocalServiceUtil.getPortletById(this.getCompanyId(), sourcePortletId);
        String sourcePortletPrimaryKey = PortletPermissionUtil.getPrimaryKey(layout.getPlid(), sourcePortletId);
        List<ResourcePermission> resourcePermissions = ResourcePermissionLocalServiceUtil.getResourcePermissions(portlet.getCompanyId(), portlet.getPortletName(), 4, sourcePortletPrimaryKey);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            String targetPortletPrimaryKey = PortletPermissionUtil.getPrimaryKey(layout.getPlid(), targetPortletId);
            resourcePermission.setResourcePermissionId(CounterLocalServiceUtil.increment());
            resourcePermission.setPrimKey(targetPortletPrimaryKey);
            ResourcePermissionLocalServiceUtil.addResourcePermission(resourcePermission);
        }
    }

    protected String getColumn(String portletId) {
        String portletIdColumnId = "";
        List<String> columnIds = this.getColumns();
        for (String columnId : columnIds) {
            String[] portletIds;
            String columnValue = this.getColumnValue(columnId);
            for (String columnPortletId : portletIds = StringUtil.split(columnValue)) {
                if (columnPortletId.equals(portletId)) {
                    return columnId;
                }
                if (!Validator.isNull(portletIdColumnId) || !Objects.equals(PortletIdCodec.decodePortletName(columnPortletId), PortletIdCodec.decodePortletName(portletId))) continue;
                portletIdColumnId = columnId;
            }
        }
        return portletIdColumnId;
    }

    protected List<String> getColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        Layout layout = this.getLayout();
        if (layout.isTypePortlet()) {
            if (Objects.equals(layout.getType(), "full_page_application")) {
                columns.add("fullPageApplicationPortlet");
            } else {
                LayoutTemplate layoutTemplate = this.getLayoutTemplate();
                columns.addAll(layoutTemplate.getColumns());
                Collections.addAll(columns, this.getNestedColumns());
            }
        } else if (layout.isTypePanel()) {
            columns.add("panelSelectedPortlets");
        }
        return columns;
    }

    protected String getColumnValue(String columnId) {
        if (this.hasUserPreferences() && this.isCustomizable() && !this.isColumnDisabled(columnId)) {
            return this.getUserPreference(columnId);
        }
        return this.getTypeSettingsProperty(columnId);
    }

    protected long getCompanyId() {
        Layout layout = this.getLayout();
        return layout.getCompanyId();
    }

    protected LayoutTypePortletImpl getDefaultLayoutTypePortletImpl() {
        if (!this.isCustomizedView()) {
            return this;
        }
        LayoutTypePortletImpl defaultLayoutTypePortletImpl = (LayoutTypePortletImpl)LayoutTypePortletFactoryUtil.create(this.getLayout());
        defaultLayoutTypePortletImpl._layoutSetPrototypeLayout = this._layoutSetPrototypeLayout;
        defaultLayoutTypePortletImpl._updatePermission = this._updatePermission;
        return defaultLayoutTypePortletImpl;
    }

    protected String[] getNestedColumns() {
        String nestedColumnIds = this.getTypeSettingsProperty("nested-column-ids");
        return StringUtil.split(nestedColumnIds);
    }

    protected long getPlid() {
        Layout layout = this.getLayout();
        return layout.getPlid();
    }

    protected String[] getStaticPortletIds(String position) {
        Layout layout = this.getLayout();
        Group group = this._getGroup();
        if (group == null) {
            _log.error("Unable to get group " + layout.getGroupId());
            return new String[0];
        }
        String selector1 = "";
        if (group.isUser()) {
            selector1 = "user";
        } else if (group.isOrganization()) {
            selector1 = "organization";
        } else if (group.isRegularSite()) {
            selector1 = "regular-site";
        }
        String selector2 = layout.getFriendlyURL();
        String[] portletIds = PropsUtil.getArray(position, new Filter(selector1, selector2));
        for (int i = 0; i < portletIds.length; ++i) {
            portletIds[i] = JS.getSafeName(portletIds[i]);
        }
        return portletIds;
    }

    protected List<Portlet> getStaticPortlets(String position) {
        String[] portletIds = this.getStaticPortletIds(position);
        ArrayList<Portlet> portlets = new ArrayList<Portlet>();
        for (String portletId : portletIds) {
            Portlet portlet;
            if (Validator.isNull(portletId) || this.hasNonstaticPortletId(portletId) || (portlet = PortletLocalServiceUtil.getPortletById(this.getCompanyId(), portletId)) == null) continue;
            Portlet staticPortlet = portlet;
            if (!portlet.isInstanceable()) {
                staticPortlet = new PortletWrapper(portlet){
                    private boolean _staticPortlet;
                    private boolean _staticPortletStart;

                    @Override
                    public boolean getStatic() {
                        return this._staticPortlet;
                    }

                    @Override
                    public boolean getStaticStart() {
                        return this._staticPortletStart;
                    }

                    @Override
                    public boolean isStatic() {
                        return this._staticPortlet;
                    }

                    @Override
                    public boolean isStaticStart() {
                        return this._staticPortletStart;
                    }

                    @Override
                    public void setStatic(boolean staticPortlet) {
                        this._staticPortlet = staticPortlet;
                    }

                    @Override
                    public void setStaticStart(boolean staticPortletStart) {
                        this._staticPortletStart = staticPortletStart;
                    }
                };
            }
            staticPortlet.setStatic(true);
            if (position.startsWith("layout.static.portlets.start")) {
                staticPortlet.setStaticStart(true);
            }
            portlets.add(staticPortlet);
        }
        return portlets;
    }

    protected String getThemeId() {
        try {
            Layout layout = this.getLayout();
            if (!layout.isInheritLookAndFeel()) {
                return layout.getThemeId();
            }
            LayoutSet layoutSet = layout.getLayoutSet();
            return layoutSet.getThemeId();
        }
        catch (Exception e) {
            _log.error(e, e);
            return null;
        }
    }

    protected String getUserPreference(String key) {
        String[] portletIds;
        String value = "";
        if (!this.hasUserPreferences()) {
            return value;
        }
        value = this._portalPreferences.getValue(CustomizedPages.namespacePlid(this.getPlid()), key, "null");
        if (!value.equals("null")) {
            return value;
        }
        value = this.getTypeSettingsProperty(key);
        if (Validator.isNull(value)) {
            return value;
        }
        ArrayList<String> newPortletIds = new ArrayList<String>();
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        for (String portletId : portletIds = StringUtil.split(value)) {
            try {
                String rootPortletId;
                if (!PortletPermissionUtil.contains(permissionChecker, this.getLayout(), portletId, "VIEW", true) || !PortletPermissionUtil.contains(permissionChecker, rootPortletId = PortletIdCodec.decodePortletName(portletId), "ADD_TO_PAGE")) {
                    continue;
                }
            }
            catch (Exception e) {
                _log.error(e, e);
            }
            String newPortletId = null;
            boolean preferencesUniquePerLayout = false;
            try {
                Portlet portlet = PortletLocalServiceUtil.getPortletById(this.getCompanyId(), portletId);
                preferencesUniquePerLayout = portlet.isPreferencesUniquePerLayout();
            }
            catch (SystemException se) {
                _log.error(se, se);
            }
            if (PortletIdCodec.hasInstanceId(portletId) || preferencesUniquePerLayout) {
                String instanceId = null;
                if (PortletIdCodec.hasInstanceId(portletId)) {
                    instanceId = PortletIdCodec.generateInstanceId();
                }
                newPortletId = PortletIdCodec.encode(PortletIdCodec.decodePortletName(portletId), this._portalPreferences.getUserId(), instanceId);
                this.copyPreferences(this._portalPreferences.getUserId(), portletId, newPortletId);
                this.copyResourcePermissions(portletId, newPortletId);
            } else {
                newPortletId = portletId;
            }
            newPortletIds.add(newPortletId);
        }
        value = StringUtil.merge(newPortletIds);
        this.setUserPreference(key, value);
        return value;
    }

    protected boolean hasNonstaticPortletId(String portletId) {
        LayoutTemplate layoutTemplate = this.getLayoutTemplate();
        List<String> columns = layoutTemplate.getColumns();
        for (String columnId : columns) {
            if (!this.hasNonstaticPortletId(columnId, portletId)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasNonstaticPortletId(String columnId, String portletId) {
        String[] columnValues;
        String columnValue = this.getColumnValue(columnId);
        for (String nonstaticPortletId : columnValues = StringUtil.split(columnValue)) {
            String decodedNonStaticPortletName = PortletIdCodec.decodePortletName(nonstaticPortletId);
            if (!nonstaticPortletId.equals(portletId) && !decodedNonStaticPortletName.equals(portletId)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasStaticPortletId(String columnId, String portletId) {
        String[] staticPortletIdsEnd;
        String[] staticPortletIdsStart;
        for (String staticPortletId : staticPortletIdsStart = this.getStaticPortletIds("layout.static.portlets.start." + columnId)) {
            String decodedStaticPortletName = PortletIdCodec.decodePortletName(staticPortletId);
            if (!staticPortletId.equals(portletId) && !decodedStaticPortletName.equals(portletId)) continue;
            return true;
        }
        for (String staticPortletId : staticPortletIdsEnd = this.getStaticPortletIds("layout.static.portlets.end." + columnId)) {
            String decodedStaticPortletName = PortletIdCodec.decodePortletName(staticPortletId);
            if (!staticPortletId.equals(portletId) && !decodedStaticPortletName.equals(portletId)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasUserPreferences() {
        return this._portalPreferences != null;
    }

    protected boolean isLayoutSetPrototype() {
        try {
            Group group = this._getGroup();
            return group.isLayoutSetPrototype();
        }
        catch (Exception e) {
            _log.error(e, e);
            return false;
        }
    }

    protected void onRemoveFromLayout(String[] portletIds) {
        HashSet<String> portletIdList = new HashSet<String>();
        for (String portletId : portletIds) {
            PortletLayoutListener portletLayoutListener;
            Portlet portlet;
            this.removeModesPortletId(portletId);
            this.removeStatesPortletId(portletId);
            portletIdList.add(portletId);
            String rootPortletId = PortletIdCodec.decodePortletName(portletId);
            if (rootPortletId.equals("com_liferay_nested_portlets_web_portlet_NestedPortletsPortlet")) {
                String portletNamespace = PortalUtil.getPortletNamespace(portletId);
                this._removeNestedColumns(portletNamespace, portletIdList);
            }
            if ((portlet = PortletLocalServiceUtil.getPortletById(portletId)) == null || (portletLayoutListener = portlet.getPortletLayoutListenerInstance()) == null) continue;
            portletLayoutListener.updatePropertiesOnRemoveFromLayout(portletId, this.getTypeSettingsProperties());
        }
        try {
            PortletLocalServiceUtil.deletePortlets(this.getCompanyId(), portletIdList.toArray(new String[0]), this.getPlid());
        }
        catch (PortalException pe) {
            _log.error(pe, pe);
        }
    }

    protected void setUserPreference(String key, String value) {
        this._portalPreferences.setValue(CustomizedPages.namespacePlid(this.getPlid()), key, value);
        this._portalPreferences.setValue(CustomizedPages.namespacePlid(this.getPlid()), _MODIFIED_DATE, this._dateFormat.format(new Date()));
    }

    private Group _getGroup() {
        if (this._group == null) {
            Layout layout = this.getLayout();
            this._group = layout.getGroup();
        }
        return this._group;
    }

    private void _removeNestedColumns(String portletNamespace, Set<String> portletIdList) {
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
        UnicodeProperties newTypeSettingsProperties = new UnicodeProperties();
        StringBundler sb = new StringBundler(typeSettingsProperties.size() * 2);
        for (Map.Entry entry : typeSettingsProperties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(portletNamespace)) continue;
            sb.append((String)entry.getValue());
            sb.append(",");
        }
        if (sb.index() != 0) {
            sb.setIndex(sb.index() - 1);
            for (String nestedPortletId : StringUtil.split(sb.toString())) {
                String childNestedPortletNamespace = PortalUtil.getPortletNamespace(nestedPortletId);
                this._removeNestedColumns(childNestedPortletNamespace, portletIdList);
                this.removeModesPortletId(nestedPortletId);
                this.removeStatesPortletId(nestedPortletId);
                portletIdList.add(nestedPortletId);
            }
        }
        typeSettingsProperties = this.getTypeSettingsProperties();
        for (Map.Entry entry : typeSettingsProperties.entrySet()) {
            String key = (String)entry.getKey();
            if (key.startsWith(portletNamespace)) continue;
            newTypeSettingsProperties.setProperty(key, (String)entry.getValue());
        }
        Layout layout = this.getLayout();
        layout.setTypeSettingsProperties(newTypeSettingsProperties);
        String string = GetterUtil.getString(this.getTypeSettingsProperty("nested-column-ids"));
        Object[] nestedColumnIdsArray = ArrayUtil.removeByPrefix(StringUtil.split(string), portletNamespace);
        this.setTypeSettingsProperty("nested-column-ids", StringUtil.merge(nestedColumnIdsArray));
    }
}

