/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutType;
import com.liferay.portal.kernel.model.LayoutTypeAccessPolicy;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;

public class LayoutTypeImpl
implements LayoutType {
    private static final String _URL = "${liferay:mainPath}/portal/layout?p_l_id=${liferay:plid}&p_v_l_s_g_id=${liferay:pvlsgid}";
    private final Layout _layout;
    private final LayoutTypeAccessPolicy _layoutTypeAccessPolicy;
    private final LayoutTypeController _layoutTypeController;

    public static String getURL(String url, Map<String, String> variables) {
        if (Validator.isNull(url)) {
            url = LayoutTypeImpl.getDefaultURL();
        }
        return LayoutTypeImpl.replaceVariables(url, variables);
    }

    public LayoutTypeImpl(Layout layout, LayoutTypeController layoutTypeController, LayoutTypeAccessPolicy layoutTypeAccessPolicy) {
        this._layout = layout;
        this._layoutTypeController = layoutTypeController;
        this._layoutTypeAccessPolicy = layoutTypeAccessPolicy;
    }

    @Override
    public String[] getConfigurationActionDelete() {
        return this._layoutTypeController.getConfigurationActionDelete();
    }

    @Override
    public String[] getConfigurationActionUpdate() {
        return this._layoutTypeController.getConfigurationActionUpdate();
    }

    @Override
    public Layout getLayout() {
        return this._layout;
    }

    @Override
    public LayoutTypeAccessPolicy getLayoutTypeAccessPolicy() {
        return this._layoutTypeAccessPolicy;
    }

    @Override
    public LayoutTypeController getLayoutTypeController() {
        return this._layoutTypeController;
    }

    @Override
    public UnicodeProperties getTypeSettingsProperties() {
        return this._layout.getTypeSettingsProperties();
    }

    @Override
    public String getTypeSettingsProperty(String key) {
        return this.getTypeSettingsProperty(key, null);
    }

    @Override
    public String getTypeSettingsProperty(String key, String defaultValue) {
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
        return typeSettingsProperties.getProperty(key, defaultValue);
    }

    @Override
    public String getURL(Map<String, String> variables) {
        return LayoutTypeImpl.getURL(this._layoutTypeController.getURL(), variables);
    }

    @Override
    public boolean isBrowsable() {
        return this._layoutTypeController.isBrowsable();
    }

    @Override
    public boolean isFirstPageable() {
        return this._layoutTypeController.isFirstPageable();
    }

    @Override
    public boolean isParentable() {
        return this._layoutTypeController.isParentable();
    }

    @Override
    public boolean isSitemapable() {
        return this._layoutTypeController.isSitemapable();
    }

    @Override
    public boolean isURLFriendliable() {
        return this._layoutTypeController.isURLFriendliable();
    }

    @Override
    public void setTypeSettingsProperty(String key, String value) {
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
        typeSettingsProperties.setProperty(key, value);
    }

    protected static String getDefaultURL() {
        return _URL;
    }

    protected static String replaceVariables(String url, Map<String, String> variables) {
        return StringUtil.replace(url, "${", "}", variables);
    }
}

