/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.kernel.servlet.DirectRequestDispatcherFactoryUtil;
import com.liferay.portal.kernel.servlet.TransferHeadersHelperUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import com.liferay.taglib.servlet.PipingServletResponse;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LayoutTypeControllerImpl
implements LayoutTypeController {
    private final boolean _browsable;
    private final String[] _configurationActionDelete;
    private final String[] _configurationActionUpdate;
    private final String _editPage;
    private final boolean _firstPageable;
    private final boolean _fullPageDisplayable;
    private final boolean _parentable;
    private final boolean _sitemapable;
    private final String _type;
    private final String _url;
    private final boolean _urlFriendliable;
    private final String _viewPage;

    public LayoutTypeControllerImpl(String type) {
        this._type = type;
        Filter filter = new Filter(type);
        this._browsable = GetterUtil.getBoolean(PropsUtil.get("layout.browsable", filter), true);
        this._configurationActionDelete = StringUtil.split(GetterUtil.getString(PropsUtil.get("layout.configuration.action.delete", filter)));
        this._configurationActionUpdate = StringUtil.split(GetterUtil.getString(PropsUtil.get("layout.configuration.action.update", filter)));
        this._editPage = GetterUtil.getString(PropsUtil.get("layout.edit.page", filter));
        this._firstPageable = GetterUtil.getBoolean(PropsUtil.get("layout.first.pageable", filter));
        this._fullPageDisplayable = GetterUtil.getBoolean(PropsUtil.get("full.page.displayable", filter));
        this._parentable = GetterUtil.getBoolean(PropsUtil.get("layout.parentable", filter), true);
        this._sitemapable = GetterUtil.getBoolean(PropsUtil.get("layout.sitemapable", filter), true);
        this._url = GetterUtil.getString(PropsUtil.get("layout.url", filter));
        this._urlFriendliable = GetterUtil.getBoolean(PropsUtil.get("layout.url.friendliable", filter), true);
        String viewPage = GetterUtil.getString(PropsUtil.get("layout.view.page", filter));
        this._viewPage = "/html" + viewPage;
    }

    @Override
    public String[] getConfigurationActionDelete() {
        return this._configurationActionDelete;
    }

    @Override
    public String[] getConfigurationActionUpdate() {
        return this._configurationActionUpdate;
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public String getURL() {
        return this._url;
    }

    public String getViewPath(String portletId) {
        if (Validator.isNull(portletId)) {
            return this._viewPage;
        }
        if (this._type.equals("panel")) {
            return "/html/portal/layout/view/panel.jsp";
        }
        return "/html/portal/layout/view/portlet.jsp";
    }

    @Override
    public String includeEditContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Layout layout) throws Exception {
        httpServletRequest.setAttribute("SEL_LAYOUT", (Object)layout);
        ServletContext servletContext = (ServletContext)httpServletRequest.getAttribute("CTX");
        RequestDispatcher requestDispatcher = TransferHeadersHelperUtil.getTransferHeadersRequestDispatcher(DirectRequestDispatcherFactoryUtil.getRequestDispatcher(servletContext, this.getEditPage()));
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        PipingServletResponse pipingServletResponse = new PipingServletResponse(httpServletResponse, unsyncStringWriter);
        requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)pipingServletResponse);
        return unsyncStringWriter.toString();
    }

    @Override
    public boolean includeLayoutContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Layout layout) throws Exception {
        ServletContext servletContext = (ServletContext)httpServletRequest.getAttribute("CTX");
        String portletId = ParamUtil.getString(httpServletRequest, "p_p_id");
        String path = this.getViewPath(portletId);
        RequestDispatcher requestDispatcher = TransferHeadersHelperUtil.getTransferHeadersRequestDispatcher(DirectRequestDispatcherFactoryUtil.getRequestDispatcher(servletContext, path));
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        PipingServletResponse pipingServletResponse = new PipingServletResponse(httpServletResponse, unsyncStringWriter);
        String contentType = pipingServletResponse.getContentType();
        requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)pipingServletResponse);
        if (contentType != null) {
            httpServletResponse.setContentType(contentType);
        }
        httpServletRequest.setAttribute("LAYOUT_CONTENT", (Object)unsyncStringWriter.getStringBundler());
        return false;
    }

    @Override
    public boolean isBrowsable() {
        return this._browsable;
    }

    @Override
    public boolean isCheckLayoutViewPermission() {
        return true;
    }

    @Override
    public boolean isFirstPageable() {
        return this._firstPageable;
    }

    @Override
    public boolean isFullPageDisplayable() {
        return this._fullPageDisplayable;
    }

    @Override
    public boolean isInstanceable() {
        return true;
    }

    @Override
    public boolean isParentable() {
        return this._parentable;
    }

    @Override
    public boolean isPrimaryType() {
        return this._type.equals("portlet");
    }

    @Override
    public boolean isSitemapable() {
        return this._sitemapable;
    }

    @Override
    public boolean isURLFriendliable() {
        return this._urlFriendliable;
    }

    @Override
    public boolean isWorkflowEnabled() {
        return !this._type.equals("url");
    }

    @Override
    public boolean matches(HttpServletRequest httpServletRequest, String friendlyURL, Layout layout) {
        try {
            Map<Locale, String> friendlyURLMap = layout.getFriendlyURLMap();
            Collection<String> values = friendlyURLMap.values();
            return values.contains(friendlyURL);
        }
        catch (SystemException se) {
            throw new RuntimeException(se);
        }
    }

    protected String getEditPage() {
        return "/html" + this._editPage;
    }
}

