/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.LayoutTemplate;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.PluginBaseImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletContext;

public class LayoutTemplateImpl
extends PluginBaseImpl
implements LayoutTemplate {
    private static final Log _log = LogFactoryUtil.getLog(LayoutTemplateImpl.class);
    private List<String> _columns = new ArrayList<String>();
    private String _content;
    private final String _layoutTemplateId;
    private String _name;
    private transient ServletContext _servletContext;
    private String _servletContextName = "";
    private boolean _setContent;
    private boolean _standard;
    private String _templatePath;
    private String _themeId;
    private String _thumbnailPath;
    private boolean _warFile;

    public LayoutTemplateImpl() {
        this(null, null);
    }

    public LayoutTemplateImpl(String layoutTemplateId) {
        this(layoutTemplateId, null);
    }

    public LayoutTemplateImpl(String layoutTemplateId, String name) {
        this._layoutTemplateId = layoutTemplateId;
        this._name = name;
    }

    @Override
    public int compareTo(LayoutTemplate layoutTemplate) {
        if (layoutTemplate == null) {
            return -1;
        }
        return this.getName().compareTo(layoutTemplate.getName());
    }

    public boolean equals(LayoutTemplate layoutTemplate) {
        if (layoutTemplate == null) {
            return false;
        }
        String layoutTemplateId = layoutTemplate.getLayoutTemplateId();
        return this.getLayoutTemplateId().equals(layoutTemplateId);
    }

    @Override
    public List<String> getColumns() {
        return this._columns;
    }

    @Override
    public String getContent() {
        return this._content;
    }

    @Override
    public String getContextPath() {
        if (!this.isWARFile()) {
            return PortalUtil.getPathContext();
        }
        String servletContextName = this.getServletContextName();
        if (ServletContextPool.containsKey(servletContextName)) {
            ServletContext servletContext = ServletContextPool.get(servletContextName);
            return servletContext.getContextPath();
        }
        return "/".concat(servletContextName);
    }

    @Override
    public String getLayoutTemplateId() {
        return this._layoutTemplateId;
    }

    @Override
    public String getName() {
        return this.getName(LocaleUtil.getDefault());
    }

    @Override
    public String getName(Locale locale) {
        if (Validator.isNotNull(this._name)) {
            return this._name;
        }
        String layoutTemplateId = StringUtil.replace(this._layoutTemplateId, '_', '-');
        return LanguageUtil.get(locale, "layout-template-" + layoutTemplateId);
    }

    @Override
    public String getPluginId() {
        return this.getLayoutTemplateId();
    }

    @Override
    public String getPluginType() {
        return "layouttpl";
    }

    @Override
    public String getServletContextName() {
        return this._servletContextName;
    }

    @Override
    public boolean getStandard() {
        return this._standard;
    }

    @Override
    public String getStaticResourcePath() {
        String contextPath = this.getContextPath();
        if (!this.isWARFile()) {
            return contextPath;
        }
        String proxyPath = PortalUtil.getPathProxy();
        return proxyPath.concat(contextPath);
    }

    @Override
    public String getTemplatePath() {
        return this._templatePath;
    }

    @Override
    public String getThemeId() {
        return this._themeId;
    }

    @Override
    public String getThumbnailPath() {
        return this._thumbnailPath;
    }

    @Override
    public String getUncachedContent() throws IOException {
        if (this._servletContext == null) {
            if (_log.isDebugEnabled()) {
                _log.debug(StringBundler.concat("Cannot get latest content for ", this._servletContextName, " ", this.getTemplatePath(), " because the servlet context is null"));
            }
            return this._content;
        }
        if (_log.isDebugEnabled()) {
            _log.debug(StringBundler.concat("Getting latest content for ", this._servletContextName, " ", this.getTemplatePath()));
        }
        String content = HttpUtil.URLtoString(this._servletContext.getResource(this.getTemplatePath()));
        this.setContent(content);
        return content;
    }

    @Override
    public boolean getWARFile() {
        return this._warFile;
    }

    @Override
    public boolean hasSetContent() {
        return this._setContent;
    }

    @Override
    public boolean isStandard() {
        return this._standard;
    }

    @Override
    public boolean isWARFile() {
        return this._warFile;
    }

    @Override
    public void setColumns(List<String> columns) {
        this._columns = columns;
    }

    @Override
    public void setContent(String content) {
        this._setContent = true;
        this._content = content;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    @Override
    public void setServletContextName(String servletContextName) {
        this._servletContextName = servletContextName;
        this._warFile = Validator.isNotNull(this._servletContextName);
    }

    @Override
    public void setStandard(boolean standard) {
        this._standard = standard;
    }

    @Override
    public void setTemplatePath(String templatePath) {
        this._templatePath = templatePath;
    }

    @Override
    public void setThemeId(String themeId) {
        this._themeId = themeId;
    }

    @Override
    public void setThumbnailPath(String thumbnailPath) {
        this._thumbnailPath = thumbnailPath;
    }
}

