/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.impl.LayoutSetPrototypeBaseImpl;
import java.io.IOException;

public class LayoutSetPrototypeImpl
extends LayoutSetPrototypeBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(LayoutSetPrototypeImpl.class);
    private UnicodeProperties _settingsProperties;

    @Override
    public Group getGroup() throws PortalException {
        return GroupLocalServiceUtil.getLayoutSetPrototypeGroup(this.getCompanyId(), this.getLayoutSetPrototypeId());
    }

    @Override
    public long getGroupId() throws PortalException {
        Group group = this.getGroup();
        return group.getGroupId();
    }

    @Override
    public LayoutSet getLayoutSet() throws PortalException {
        return LayoutSetLocalServiceUtil.getLayoutSet(this.getGroup().getGroupId(), true);
    }

    @Override
    public UnicodeProperties getSettingsProperties() {
        if (this._settingsProperties == null) {
            this._settingsProperties = new UnicodeProperties(true);
            try {
                this._settingsProperties.load(super.getSettings());
            }
            catch (IOException ioe) {
                _log.error(ioe, ioe);
            }
        }
        return this._settingsProperties;
    }

    @Override
    public String getSettingsProperty(String key) {
        UnicodeProperties settingsProperties = this.getSettingsProperties();
        return settingsProperties.getProperty(key);
    }

    @Override
    public boolean hasSetModifiedDate() {
        return true;
    }

    @Override
    public void setSettings(String settings) {
        this._settingsProperties = null;
        super.setSettings(settings);
    }

    @Override
    public void setSettingsProperties(UnicodeProperties settingsProperties) {
        this._settingsProperties = settingsProperties;
        super.setSettings(settingsProperties.toString());
    }
}

