/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.service.ThemeLocalServiceUtil;
import com.liferay.portal.kernel.service.VirtualHostLocalServiceUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.LayoutSetBaseImpl;
import com.liferay.portal.model.impl.ThemeSettingImpl;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;

public class LayoutSetImpl
extends LayoutSetBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(LayoutSetImpl.class);
    private String _companyFallbackVirtualHostname;
    private UnicodeProperties _settingsProperties;
    private String _virtualHostname;

    @Override
    public ColorScheme getColorScheme() {
        return ThemeLocalServiceUtil.getColorScheme(this.getCompanyId(), this.getThemeId(), this.getColorSchemeId());
    }

    @Override
    public String getCompanyFallbackVirtualHostname() {
        Company company;
        Group group;
        if (this._companyFallbackVirtualHostname != null) {
            return this._companyFallbackVirtualHostname;
        }
        this._companyFallbackVirtualHostname = "";
        if (Validator.isNotNull(PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME) && !this.isPrivateLayout() && (group = GroupLocalServiceUtil.fetchGroup(this.getCompanyId(), PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME)) != null && this.getGroupId() == group.getGroupId() && (company = CompanyLocalServiceUtil.fetchCompany(this.getCompanyId())) != null) {
            this._companyFallbackVirtualHostname = company.getVirtualHostname();
        }
        return this._companyFallbackVirtualHostname;
    }

    @Override
    public Group getGroup() throws PortalException {
        return GroupLocalServiceUtil.getGroup(this.getGroupId());
    }

    @Override
    public long getLayoutSetPrototypeId() throws PortalException {
        String layoutSetPrototypeUuid = this.getLayoutSetPrototypeUuid();
        if (Validator.isNull(layoutSetPrototypeUuid)) {
            return 0L;
        }
        LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuidAndCompanyId(layoutSetPrototypeUuid, this.getCompanyId());
        return layoutSetPrototype.getLayoutSetPrototypeId();
    }

    @Override
    public long getLiveLogoId() {
        long logoId = 0L;
        Group group = null;
        try {
            group = this.getGroup();
            if (!group.isStagingGroup()) {
                return logoId;
            }
        }
        catch (Exception e) {
            return logoId;
        }
        Group liveGroup = group.getLiveGroup();
        LayoutSet liveLayoutSet = null;
        liveLayoutSet = this.isPrivateLayout() ? liveGroup.getPrivateLayoutSet() : liveGroup.getPublicLayoutSet();
        return liveLayoutSet.getLogoId();
    }

    @Override
    public boolean getLogo() {
        return this.getLogoId() > 0L;
    }

    @Override
    public String getSettings() {
        if (this._settingsProperties == null) {
            return super.getSettings();
        }
        return this._settingsProperties.toString();
    }

    @Override
    public UnicodeProperties getSettingsProperties() {
        if (this._settingsProperties == null) {
            this._settingsProperties = new UnicodeProperties(true);
            try {
                this._settingsProperties.load(super.getSettings());
            }
            catch (IOException ioe) {
                _log.error(ioe, ioe);
            }
        }
        return this._settingsProperties;
    }

    @Override
    public String getSettingsProperty(String key) {
        UnicodeProperties settingsProperties = this.getSettingsProperties();
        return settingsProperties.getProperty(key);
    }

    @Override
    public Theme getTheme() {
        return ThemeLocalServiceUtil.getTheme(this.getCompanyId(), this.getThemeId());
    }

    @Override
    public String getThemeSetting(String key, String device) {
        UnicodeProperties settingsProperties;
        String value;
        String settings = super.getSettings();
        if (!Validator.isBlank(settings) && (value = (settingsProperties = this.getSettingsProperties()).getProperty(ThemeSettingImpl.namespaceProperty(device, key))) != null) {
            return value;
        }
        Theme theme = this.getTheme(device);
        return theme.getSetting(key);
    }

    @Override
    public String getVirtualHostname() {
        if (this._virtualHostname != null) {
            return this._virtualHostname;
        }
        VirtualHost virtualHost = VirtualHostLocalServiceUtil.fetchVirtualHost(this.getCompanyId(), this.getLayoutSetId());
        this._virtualHostname = virtualHost == null ? "" : virtualHost.getHostname();
        return this._virtualHostname;
    }

    @Override
    public boolean hasSetModifiedDate() {
        return true;
    }

    @Override
    public boolean isLayoutSetPrototypeLinkActive() {
        return this.isLayoutSetPrototypeLinkEnabled() && Validator.isNotNull(this.getLayoutSetPrototypeUuid());
    }

    @Override
    public boolean isLogo() {
        return this.getLogo();
    }

    @Override
    public void setCompanyFallbackVirtualHostname(String companyFallbackVirtualHostname) {
        this._companyFallbackVirtualHostname = companyFallbackVirtualHostname;
    }

    @Override
    public void setSettings(String settings) {
        this._settingsProperties = null;
        super.setSettings(settings);
    }

    @Override
    public void setSettingsProperties(UnicodeProperties settingsProperties) {
        this._settingsProperties = settingsProperties;
        super.setSettings(this._settingsProperties.toString());
    }

    @Override
    public void setVirtualHostname(String virtualHostname) {
        this._virtualHostname = virtualHostname;
    }

    protected Theme getTheme(String device) {
        boolean controlPanel = false;
        try {
            Group group = this.getGroup();
            controlPanel = group.isControlPanel();
        }
        catch (Exception group) {
            // empty catch block
        }
        if (controlPanel) {
            String themeId = PrefsPropsUtil.getString(this.getCompanyId(), "control.panel.layout.regular.theme.id");
            return ThemeLocalServiceUtil.getTheme(this.getCompanyId(), themeId);
        }
        return this.getTheme();
    }
}

