/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutBranch;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.service.LayoutBranchLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutRevisionLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.ThemeLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.LayoutRevisionBaseImpl;
import com.liferay.portal.model.impl.ThemeSettingImpl;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class LayoutRevisionImpl
extends LayoutRevisionBaseImpl {
    private UnicodeProperties _typeSettingsProperties;

    @Override
    public List<LayoutRevision> getChildren() {
        return LayoutRevisionLocalServiceUtil.getChildLayoutRevisions(this.getLayoutSetBranchId(), this.getLayoutRevisionId(), this.getPlid());
    }

    @Override
    public ColorScheme getColorScheme() throws PortalException {
        if (this.isInheritLookAndFeel()) {
            return this.getLayoutSet().getColorScheme();
        }
        return ThemeLocalServiceUtil.getColorScheme(this.getCompanyId(), this.getTheme().getThemeId(), this.getColorSchemeId());
    }

    @Override
    public String getCssText() throws PortalException {
        if (this.isInheritLookAndFeel()) {
            return this.getLayoutSet().getCss();
        }
        return this.getCss();
    }

    @Override
    public String getHTMLTitle(Locale locale) {
        String localeLanguageId = LocaleUtil.toLanguageId(locale);
        return this.getHTMLTitle(localeLanguageId);
    }

    @Override
    public String getHTMLTitle(String localeLanguageId) {
        String htmlTitle = this.getTitle(localeLanguageId);
        if (Validator.isNull(htmlTitle)) {
            htmlTitle = this.getName(localeLanguageId);
        }
        return htmlTitle;
    }

    @Override
    public boolean getIconImage() {
        return this.getIconImageId() > 0L;
    }

    @Override
    public LayoutBranch getLayoutBranch() throws PortalException {
        return LayoutBranchLocalServiceUtil.getLayoutBranch(this.getLayoutBranchId());
    }

    @Override
    public LayoutSet getLayoutSet() throws PortalException {
        return LayoutSetLocalServiceUtil.getLayoutSet(this.getGroupId(), this.isPrivateLayout());
    }

    @Override
    public String getRegularURL(HttpServletRequest httpServletRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String portalURL = PortalUtil.getPortalURL(httpServletRequest);
        Layout layout = LayoutLocalServiceUtil.getLayout(this.getPlid());
        String url = PortalUtil.getLayoutURL(layout, themeDisplay);
        if (!CookieKeys.hasSessionId(httpServletRequest) && (url.startsWith(portalURL) || url.startsWith("/"))) {
            HttpSession session = httpServletRequest.getSession();
            url = PortalUtil.getURLWithSessionId(url, session.getId());
        }
        return url;
    }

    @Override
    public String getTarget() {
        String target = this.getTypeSettingsProperty("target");
        if (Validator.isNull(target)) {
            return "";
        }
        return "target=\"" + HtmlUtil.escapeAttribute(target) + "\"";
    }

    @Override
    public Theme getTheme() throws PortalException {
        if (this.isInheritLookAndFeel()) {
            return this.getLayoutSet().getTheme();
        }
        return ThemeLocalServiceUtil.getTheme(this.getCompanyId(), this.getThemeId());
    }

    @Override
    public String getThemeSetting(String key, String device) {
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
        String value = typeSettingsProperties.getProperty(ThemeSettingImpl.namespaceProperty(device, key));
        if (value != null) {
            return value;
        }
        if (!this.isInheritLookAndFeel()) {
            try {
                Theme theme = this.getTheme();
                return theme.getSetting(key);
            }
            catch (Exception theme) {
                // empty catch block
            }
        }
        try {
            LayoutSet layoutSet = this.getLayoutSet();
            value = layoutSet.getThemeSetting(key, device);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    @Override
    public String getTypeSettings() {
        if (this._typeSettingsProperties == null) {
            return super.getTypeSettings();
        }
        return this._typeSettingsProperties.toString();
    }

    @Override
    public UnicodeProperties getTypeSettingsProperties() {
        if (this._typeSettingsProperties == null) {
            this._typeSettingsProperties = new UnicodeProperties(true);
            this._typeSettingsProperties.fastLoad(super.getTypeSettings());
        }
        return this._typeSettingsProperties;
    }

    @Override
    public String getTypeSettingsProperty(String key) {
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
        return typeSettingsProperties.getProperty(key);
    }

    @Override
    public String getTypeSettingsProperty(String key, String defaultValue) {
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
        return typeSettingsProperties.getProperty(key, defaultValue);
    }

    @Override
    public boolean hasChildren() {
        return !this.getChildren().isEmpty();
    }

    @Override
    public boolean isContentDisplayPage() {
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
        String defaultAssetPublisherPortletId = typeSettingsProperties.getProperty("default-asset-publisher-portlet-id");
        return Validator.isNotNull(defaultAssetPublisherPortletId);
    }

    @Override
    public boolean isIconImage() {
        return this.getIconImage();
    }

    @Override
    public boolean isInheritLookAndFeel() {
        return Validator.isNull(this.getThemeId()) || Validator.isNull(this.getColorSchemeId());
    }

    @Override
    public void setTypeSettings(String typeSettings) {
        this._typeSettingsProperties = null;
        super.setTypeSettings(typeSettings);
    }

    @Override
    public void setTypeSettingsProperties(UnicodeProperties typeSettingsProperties) {
        this._typeSettingsProperties = typeSettingsProperties;
        super.setTypeSettings(this._typeSettingsProperties.toString());
    }
}

