/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.exception.LayoutFriendlyURLException;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutFriendlyURL;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutType;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.model.PortletWrapper;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutFriendlyURLLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.service.ThemeLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LayoutTypePortletFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.LayoutBaseImpl;
import com.liferay.portal.model.impl.ThemeSettingImpl;
import com.liferay.portal.util.LayoutClone;
import com.liferay.portal.util.LayoutCloneFactory;
import com.liferay.portal.util.LayoutTypeControllerTracker;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class LayoutImpl
extends LayoutBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(LayoutImpl.class);
    private static String[] _friendlyURLKeywords;
    private LayoutSet _layoutSet;
    private transient LayoutType _layoutType;
    private UnicodeProperties _typeSettingsProperties;

    public static boolean hasFriendlyURLKeyword(String friendlyURL) {
        String keyword = LayoutImpl._getFriendlyURLKeyword(friendlyURL);
        return Validator.isNotNull(keyword);
    }

    public static int validateFriendlyURL(String friendlyURL) {
        return LayoutImpl.validateFriendlyURL(friendlyURL, true);
    }

    public static int validateFriendlyURL(String friendlyURL, boolean checkMaxLength) {
        if (friendlyURL.length() < 2) {
            return 3;
        }
        if (checkMaxLength && friendlyURL.length() > 255) {
            return 10;
        }
        if (!friendlyURL.startsWith("/")) {
            return 1;
        }
        if (friendlyURL.endsWith("/")) {
            return 2;
        }
        if (friendlyURL.contains("//")) {
            return 4;
        }
        for (char c : friendlyURL.toCharArray()) {
            if (Validator.isChar(c) || Validator.isDigit(c) || c == '-' || c == '%' || c == '.' || c == '+' || c == '/' || c == '*' || c == '_') continue;
            return 5;
        }
        return -1;
    }

    public static void validateFriendlyURLKeyword(String friendlyURL) throws LayoutFriendlyURLException {
        String keyword = LayoutImpl._getFriendlyURLKeyword(friendlyURL);
        if (Validator.isNotNull(keyword)) {
            LayoutFriendlyURLException lfurle = new LayoutFriendlyURLException(7);
            lfurle.setKeywordConflict(keyword);
            throw lfurle;
        }
    }

    @Override
    public List<Layout> getAllChildren() {
        ArrayList<Layout> layouts = new ArrayList<Layout>();
        for (Layout layout : this.getChildren()) {
            layouts.add(layout);
            layouts.addAll(layout.getAllChildren());
        }
        return layouts;
    }

    @Override
    public long getAncestorLayoutId() throws PortalException {
        long layoutId = 0L;
        Layout layout = this;
        while (!layout.isRootLayout()) {
            layout = LayoutLocalServiceUtil.getLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId());
        }
        layoutId = layout.getLayoutId();
        return layoutId;
    }

    @Override
    public long getAncestorPlid() throws PortalException {
        long plid = 0L;
        Layout layout = this;
        while (!layout.isRootLayout()) {
            layout = LayoutLocalServiceUtil.getLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId());
        }
        plid = layout.getPlid();
        return plid;
    }

    @Override
    public List<Layout> getAncestors() throws PortalException {
        List<Layout> layouts = Collections.emptyList();
        Layout layout = this;
        while (!layout.isRootLayout()) {
            layout = LayoutLocalServiceUtil.getLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId());
            if (layouts.isEmpty()) {
                layouts = new ArrayList<Layout>();
            }
            layouts.add(layout);
        }
        return layouts;
    }

    @Override
    public List<Layout> getChildren() {
        return LayoutLocalServiceUtil.getLayouts(this.getGroupId(), this.isPrivateLayout(), this.getLayoutId());
    }

    @Override
    public List<Layout> getChildren(PermissionChecker permissionChecker) throws PortalException {
        List<Layout> layouts = ListUtil.copy(this.getChildren());
        Iterator<Layout> itr = layouts.iterator();
        while (itr.hasNext()) {
            Layout layout = itr.next();
            if (!layout.isHidden() && LayoutPermissionUtil.contains(permissionChecker, layout, "VIEW")) continue;
            itr.remove();
        }
        return layouts;
    }

    @Override
    public ColorScheme getColorScheme() throws PortalException {
        if (this.isInheritLookAndFeel()) {
            LayoutSet layoutSet = this.getLayoutSet();
            return layoutSet.getColorScheme();
        }
        Theme theme = this.getTheme();
        return ThemeLocalServiceUtil.getColorScheme(this.getCompanyId(), theme.getThemeId(), this.getColorSchemeId());
    }

    @Override
    public String getCssText() throws PortalException {
        if (this.isInheritLookAndFeel()) {
            LayoutSet layoutSet = this.getLayoutSet();
            return layoutSet.getCss();
        }
        return this.getCss();
    }

    @Override
    public String getDefaultThemeSetting(String key, String device, boolean inheritLookAndFeel) {
        if (!inheritLookAndFeel) {
            try {
                Theme theme = this.getTheme();
                return theme.getSetting(key);
            }
            catch (Exception theme) {
                // empty catch block
            }
        }
        try {
            LayoutSet layoutSet = this.getLayoutSet();
            return layoutSet.getThemeSetting(key, device);
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public List<Portlet> getEmbeddedPortlets() {
        return this.getEmbeddedPortlets(this.getGroupId());
    }

    @Override
    public List<Portlet> getEmbeddedPortlets(long groupId) {
        List<PortletPreferences> portletPreferences = this._getPortletPreferences(groupId);
        if (portletPreferences.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Portlet> portlets = new ArrayList<Portlet>();
        Set<String> layoutPortletIds = this._getLayoutPortletIds();
        for (PortletPreferences portletPreference : portletPreferences) {
            String portletId = portletPreference.getPortletId();
            Portlet portlet = PortletLocalServiceUtil.getPortletById(this.getCompanyId(), portletId);
            if (portlet == null || !portlet.isReady() || portlet.isUndeployedPortlet() || !portlet.isActive() || !layoutPortletIds.contains(portletId)) continue;
            Portlet embeddedPortlet = portlet;
            if (!portlet.isInstanceable()) {
                embeddedPortlet = new PortletWrapper(portlet){
                    private boolean _staticPortlet;

                    @Override
                    public boolean getStatic() {
                        return this._staticPortlet;
                    }

                    @Override
                    public boolean isStatic() {
                        return this._staticPortlet;
                    }

                    @Override
                    public void setStatic(boolean staticPortlet) {
                        this._staticPortlet = staticPortlet;
                    }
                };
            }
            embeddedPortlet.setStatic(true);
            portlets.add(embeddedPortlet);
        }
        return portlets;
    }

    @Override
    public String getFriendlyURL(Locale locale) {
        String friendlyURL = this.getFriendlyURL();
        try {
            Object[] locales;
            Group group = this.getGroup();
            UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
            if (!GetterUtil.getBoolean(typeSettingsProperties.getProperty("inheritLocales"), true) && !ArrayUtil.contains(locales = StringUtil.split(typeSettingsProperties.getProperty("locales")), LanguageUtil.getLanguageId(locale))) {
                return friendlyURL;
            }
            LayoutFriendlyURL layoutFriendlyURL = LayoutFriendlyURLLocalServiceUtil.getLayoutFriendlyURL(this.getPlid(), LocaleUtil.toLanguageId(locale));
            friendlyURL = layoutFriendlyURL.getFriendlyURL();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return friendlyURL;
    }

    @Override
    public Map<Locale, String> getFriendlyURLMap() {
        HashMap<Locale, String> friendlyURLMap = new HashMap<Locale, String>();
        List<LayoutFriendlyURL> layoutFriendlyURLs = LayoutFriendlyURLLocalServiceUtil.getLayoutFriendlyURLs(this.getPlid());
        for (LayoutFriendlyURL layoutFriendlyURL : layoutFriendlyURLs) {
            friendlyURLMap.put(LocaleUtil.fromLanguageId(layoutFriendlyURL.getLanguageId()), layoutFriendlyURL.getFriendlyURL());
        }
        Locale defaultSiteLocale = LocaleUtil.getSiteDefault();
        if (Validator.isNull((String)friendlyURLMap.get(defaultSiteLocale))) {
            Locale defaultLocale = LocaleUtil.fromLanguageId(this.getDefaultLanguageId());
            String defaultFriendlyURL = (String)friendlyURLMap.get(defaultLocale);
            friendlyURLMap.put(defaultSiteLocale, defaultFriendlyURL);
        }
        return friendlyURLMap;
    }

    @Override
    public String getFriendlyURLsXML() {
        Map<Locale, String> friendlyURLMap = this.getFriendlyURLMap();
        return LocalizationUtil.updateLocalization(friendlyURLMap, "", "FriendlyURL", LocaleUtil.toLanguageId(LocaleUtil.getSiteDefault()));
    }

    @Override
    public Group getGroup() {
        try {
            return GroupLocalServiceUtil.getGroup(this.getGroupId());
        }
        catch (PortalException pe) {
            return (Group)ReflectionUtil.throwException(pe);
        }
    }

    @Override
    public String getHTMLTitle(Locale locale) {
        String localeLanguageId = LocaleUtil.toLanguageId(locale);
        return this.getHTMLTitle(localeLanguageId);
    }

    @Override
    public String getHTMLTitle(String localeLanguageId) {
        String htmlTitle = this.getTitle(localeLanguageId);
        if (Validator.isNull(htmlTitle)) {
            htmlTitle = this.getName(localeLanguageId);
        }
        return htmlTitle;
    }

    @Override
    public boolean getIconImage() {
        return this.getIconImageId() > 0L;
    }

    @Override
    public LayoutSet getLayoutSet() {
        if (this._layoutSet == null) {
            try {
                this._layoutSet = LayoutSetLocalServiceUtil.getLayoutSet(this.getGroupId(), this.isPrivateLayout());
            }
            catch (PortalException pe) {
                ReflectionUtil.throwException(pe);
            }
        }
        return this._layoutSet;
    }

    @Override
    public LayoutType getLayoutType() {
        if (this._layoutType == null) {
            this._layoutType = LayoutTypePortletFactoryUtil.create(this);
        }
        return this._layoutType;
    }

    @Override
    public Layout getLinkedToLayout() {
        long linkToLayoutId = GetterUtil.getLong(this.getTypeSettingsProperty("linkToLayoutId"));
        if (linkToLayoutId <= 0L) {
            return null;
        }
        return LayoutLocalServiceUtil.fetchLayout(this.getGroupId(), this.isPrivateLayout(), linkToLayoutId);
    }

    @Override
    public String getRegularURL(HttpServletRequest httpServletRequest) throws PortalException {
        String url = this._getURL(httpServletRequest, false, false);
        if (!Validator.isUrl(url, true)) {
            return "/" + url;
        }
        return url;
    }

    @Override
    public String getResetLayoutURL(HttpServletRequest httpServletRequest) throws PortalException {
        return this._getURL(httpServletRequest, true, true);
    }

    @Override
    public String getResetMaxStateURL(HttpServletRequest httpServletRequest) throws PortalException {
        return this._getURL(httpServletRequest, true, false);
    }

    @Override
    public Group getScopeGroup() throws PortalException {
        Group group;
        block2: {
            group = null;
            try {
                group = GroupLocalServiceUtil.getLayoutGroup(this.getCompanyId(), this.getPlid());
            }
            catch (NoSuchGroupException nsge) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug(nsge, nsge);
            }
        }
        return group;
    }

    @Override
    public String getTarget() {
        return PortalUtil.getLayoutTarget(this);
    }

    @Override
    public Theme getTheme() throws PortalException {
        if (this.isInheritLookAndFeel()) {
            LayoutSet layoutSet = this.getLayoutSet();
            return layoutSet.getTheme();
        }
        return ThemeLocalServiceUtil.getTheme(this.getCompanyId(), this.getThemeId());
    }

    @Override
    public String getThemeSetting(String key, String device) {
        return this.getThemeSetting(key, device, this.isInheritLookAndFeel());
    }

    @Override
    public String getThemeSetting(String key, String device, boolean inheritLookAndFeel) {
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
        String value = typeSettingsProperties.getProperty(ThemeSettingImpl.namespaceProperty(device, key));
        if (value != null) {
            return value;
        }
        return this.getDefaultThemeSetting(key, device, inheritLookAndFeel);
    }

    @Override
    public String getTypeSettings() {
        if (this._typeSettingsProperties == null) {
            return super.getTypeSettings();
        }
        return this._typeSettingsProperties.toString();
    }

    @Override
    public UnicodeProperties getTypeSettingsProperties() {
        if (this._typeSettingsProperties == null) {
            this._typeSettingsProperties = new UnicodeProperties(true);
            this._typeSettingsProperties.fastLoad(super.getTypeSettings());
        }
        return this._typeSettingsProperties;
    }

    @Override
    public String getTypeSettingsProperty(String key) {
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
        return typeSettingsProperties.getProperty(key);
    }

    @Override
    public String getTypeSettingsProperty(String key, String defaultValue) {
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
        return typeSettingsProperties.getProperty(key, defaultValue);
    }

    @Override
    public boolean hasAncestor(long layoutId) throws PortalException {
        long parentLayoutId = this.getParentLayoutId();
        while (parentLayoutId != 0L) {
            if (parentLayoutId == layoutId) {
                return true;
            }
            Layout parentLayout = LayoutLocalServiceUtil.getLayout(this.getGroupId(), this.isPrivateLayout(), parentLayoutId);
            parentLayoutId = parentLayout.getParentLayoutId();
        }
        return false;
    }

    @Override
    public boolean hasChildren() {
        return LayoutLocalServiceUtil.hasLayouts(this.getGroupId(), this.isPrivateLayout(), this.getLayoutId());
    }

    @Override
    public boolean hasScopeGroup() throws PortalException {
        Group group = this.getScopeGroup();
        return group != null;
    }

    @Override
    public boolean hasSetModifiedDate() {
        return true;
    }

    @Override
    public boolean includeLayoutContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        LayoutTypeController layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController(this.getType());
        return layoutTypeController.includeLayoutContent(httpServletRequest, httpServletResponse, this);
    }

    @Override
    public boolean isChildSelected(boolean selectable, Layout layout) throws PortalException {
        if (selectable) {
            long plid = this.getPlid();
            List<Layout> ancestors = layout.getAncestors();
            for (Layout curLayout : ancestors) {
                if (plid != curLayout.getPlid()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isContentDisplayPage() {
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
        String defaultAssetPublisherPortletId = typeSettingsProperties.getProperty("default-asset-publisher-portlet-id");
        return Validator.isNotNull(defaultAssetPublisherPortletId);
    }

    @Override
    public boolean isCustomizable() {
        if (!this.isTypePortlet()) {
            return false;
        }
        if (GetterUtil.getBoolean(this.getTypeSettingsProperty("CUSTOMIZABLE_LAYOUT"))) {
            return true;
        }
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)this.getLayoutType();
        return layoutTypePortlet.isCustomizable();
    }

    @Override
    public boolean isFirstChild() {
        return this.getPriority() == 0;
    }

    @Override
    public boolean isFirstParent() {
        return this.isFirstChild() && this.isRootLayout();
    }

    @Override
    public boolean isIconImage() {
        return this.getIconImage();
    }

    @Override
    public boolean isInheritLookAndFeel() {
        return Validator.isNull(this.getThemeId()) || Validator.isNull(this.getColorSchemeId());
    }

    @Override
    public boolean isLayoutPrototypeLinkActive() {
        return this.isLayoutPrototypeLinkEnabled() && Validator.isNotNull(this.getLayoutPrototypeUuid());
    }

    @Override
    public boolean isPortletEmbedded(String portletId, long groupId) {
        LayoutTypePortlet layoutTypePortlet;
        PortalPreferences portalPreferences;
        PortletPreferences portletPreferences = PortletPreferencesLocalServiceUtil.fetchPortletPreferences(0L, 3, this.getPlid(), portletId);
        if (portletPreferences == null) {
            return false;
        }
        portletPreferences = PortletPreferencesLocalServiceUtil.fetchPortletPreferences(groupId, 3, 0L, portletId);
        if (portletPreferences == null && this.isTypePortlet() && (portalPreferences = (layoutTypePortlet = (LayoutTypePortlet)this.getLayoutType()).getPortalPreferences()) != null && layoutTypePortlet.isCustomizable()) {
            portletPreferences = PortletPreferencesLocalServiceUtil.fetchPortletPreferences(portalPreferences.getUserId(), 4, this.getPlid(), portletId);
        }
        if (portletPreferences == null) {
            return false;
        }
        Portlet portlet = PortletLocalServiceUtil.getPortletById(this.getCompanyId(), portletId);
        return portlet != null && portlet.isReady() && !portlet.isUndeployedPortlet() && portlet.isActive();
    }

    @Override
    public boolean isPublicLayout() {
        return !this.isPrivateLayout();
    }

    @Override
    public boolean isRootLayout() {
        return this.getParentLayoutId() == 0L;
    }

    @Override
    public boolean isSelected(boolean selectable, Layout layout, long ancestorPlid) {
        long plid;
        return selectable && ((plid = this.getPlid()) == layout.getPlid() || plid == ancestorPlid);
    }

    @Override
    public boolean isSupportsEmbeddedPortlets() {
        return this.isTypeEmbedded() || this.isTypePanel() || this.isTypePortlet();
    }

    @Override
    public boolean isTypeControlPanel() {
        return Objects.equals(this.getType(), "control_panel") || Objects.equals(this._getLayoutTypeControllerType(), "control_panel");
    }

    @Override
    public boolean isTypeEmbedded() {
        return Objects.equals(this.getType(), "embedded") || Objects.equals(this._getLayoutTypeControllerType(), "embedded");
    }

    @Override
    public boolean isTypeLinkToLayout() {
        return Objects.equals(this.getType(), "link_to_layout") || Objects.equals(this._getLayoutTypeControllerType(), "link_to_layout");
    }

    @Override
    public boolean isTypePanel() {
        return Objects.equals(this.getType(), "panel") || Objects.equals(this._getLayoutTypeControllerType(), "panel");
    }

    @Override
    public boolean isTypePortlet() {
        return Objects.equals(this.getType(), "portlet") || Objects.equals(this._getLayoutTypeControllerType(), "portlet");
    }

    @Override
    @Deprecated
    public boolean isTypeSharedPortlet() {
        return Objects.equals(this.getType(), "shared_portlet");
    }

    @Override
    public boolean isTypeURL() {
        return Objects.equals(this.getType(), "url");
    }

    @Override
    public boolean matches(HttpServletRequest httpServletRequest, String friendlyURL) {
        LayoutType layoutType = this.getLayoutType();
        LayoutTypeController layoutTypeController = layoutType.getLayoutTypeController();
        return layoutTypeController.matches(httpServletRequest, friendlyURL, this);
    }

    @Override
    public void setGroupId(long groupId) {
        super.setGroupId(groupId);
        this._layoutSet = null;
    }

    @Override
    public void setLayoutSet(LayoutSet layoutSet) {
        this._layoutSet = layoutSet;
    }

    @Override
    public void setPrivateLayout(boolean privateLayout) {
        super.setPrivateLayout(privateLayout);
        this._layoutSet = null;
    }

    @Override
    public void setTypeSettings(String typeSettings) {
        this._typeSettingsProperties = null;
        super.setTypeSettings(typeSettings);
    }

    @Override
    public void setTypeSettingsProperties(UnicodeProperties typeSettingsProperties) {
        this._typeSettingsProperties = typeSettingsProperties;
        super.setTypeSettings(this._typeSettingsProperties.toString());
    }

    private static String _getFriendlyURLKeyword(String friendlyURL) {
        friendlyURL = StringUtil.toLowerCase(friendlyURL);
        for (String keyword : _friendlyURLKeywords) {
            if (friendlyURL.startsWith(keyword)) {
                return keyword;
            }
            if (!keyword.equals(friendlyURL + "/")) continue;
            return friendlyURL;
        }
        return null;
    }

    private static void _initFriendlyURLKeywords() {
        _friendlyURLKeywords = new String[PropsValues.LAYOUT_FRIENDLY_URL_KEYWORDS.length];
        for (int i = 0; i < PropsValues.LAYOUT_FRIENDLY_URL_KEYWORDS.length; ++i) {
            String keyword = PropsValues.LAYOUT_FRIENDLY_URL_KEYWORDS[i];
            keyword = "/" + keyword;
            if (!keyword.contains(".")) {
                keyword = keyword.endsWith("*") ? keyword.substring(0, keyword.length() - 1) : keyword + "/";
            }
            LayoutImpl._friendlyURLKeywords[i] = StringUtil.toLowerCase(keyword);
        }
    }

    private Set<String> _getLayoutPortletIds() {
        HashSet<String> layoutPortletIds = new HashSet<String>();
        List<PortletPreferences> portletPreferences = PortletPreferencesLocalServiceUtil.getPortletPreferences(0L, 3, this.getPlid());
        for (PortletPreferences portletPreference : portletPreferences) {
            layoutPortletIds.add(portletPreference.getPortletId());
        }
        return layoutPortletIds;
    }

    private String _getLayoutTypeControllerType() {
        LayoutTypeController layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController(this.getType());
        return layoutTypeController.getType();
    }

    private LayoutTypePortlet _getLayoutTypePortletClone(HttpServletRequest httpServletRequest) throws IOException {
        String typeSettings;
        LayoutTypePortlet layoutTypePortlet = null;
        LayoutClone layoutClone = LayoutCloneFactory.getInstance();
        if (layoutClone != null && (typeSettings = layoutClone.get(httpServletRequest, this.getPlid())) != null) {
            UnicodeProperties typeSettingsProperties = new UnicodeProperties(true);
            typeSettingsProperties.load(typeSettings);
            String stateMax = typeSettingsProperties.getProperty("state-max");
            String stateMin = typeSettingsProperties.getProperty("state-min");
            Layout layout = (Layout)this.clone();
            layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            layoutTypePortlet.setStateMax(stateMax);
            layoutTypePortlet.setStateMin(stateMin);
        }
        if (layoutTypePortlet == null) {
            layoutTypePortlet = (LayoutTypePortlet)this.getLayoutType();
        }
        return layoutTypePortlet;
    }

    private List<PortletPreferences> _getPortletPreferences(long groupId) {
        LayoutTypePortlet layoutTypePortlet;
        PortalPreferences portalPreferences;
        List<PortletPreferences> portletPreferences = PortletPreferencesLocalServiceUtil.getPortletPreferences(groupId, 3, 0L);
        if (this.isTypePortlet() && (portalPreferences = (layoutTypePortlet = (LayoutTypePortlet)this.getLayoutType()).getPortalPreferences()) != null && layoutTypePortlet.isCustomizable()) {
            portletPreferences = ListUtil.copy(portletPreferences);
            portletPreferences.addAll(PortletPreferencesLocalServiceUtil.getPortletPreferences(portalPreferences.getUserId(), 4, this.getPlid()));
        }
        return portletPreferences;
    }

    private String _getURL(HttpServletRequest httpServletRequest, boolean resetMaxState, boolean resetRenderParameters) throws PortalException {
        String portalURL;
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (resetMaxState) {
            Layout layout = themeDisplay.getLayout();
            LayoutTypePortlet layoutTypePortlet = null;
            if (layout.equals(this)) {
                layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
            } else {
                try {
                    layoutTypePortlet = this._getLayoutTypePortletClone(httpServletRequest);
                }
                catch (IOException ioe) {
                    _log.error("Unable to clone layout settings", ioe);
                    layoutTypePortlet = (LayoutTypePortlet)this.getLayoutType();
                }
            }
            if (layoutTypePortlet.hasStateMax()) {
                String portletId = StringUtil.split(layoutTypePortlet.getStateMax())[0];
                LiferayPortletURL portletURL = PortletURLFactoryUtil.create(httpServletRequest, portletId, (Layout)this, "ACTION_PHASE");
                try {
                    portletURL.setWindowState(WindowState.NORMAL);
                    portletURL.setPortletMode(PortletMode.VIEW);
                }
                catch (PortletException pe) {
                    throw new SystemException(pe);
                }
                portletURL.setAnchor(false);
                if (PropsValues.LAYOUT_DEFAULT_P_L_RESET && !resetRenderParameters) {
                    portletURL.setParameter("p_l_reset", "0");
                } else if (!PropsValues.LAYOUT_DEFAULT_P_L_RESET && resetRenderParameters) {
                    portletURL.setParameter("p_l_reset", "1");
                }
                return portletURL.toString();
            }
        }
        String url = PortalUtil.getLayoutURL(this, themeDisplay);
        if (!CookieKeys.hasSessionId(httpServletRequest) && (url.startsWith(portalURL = PortalUtil.getPortalURL(httpServletRequest)) || url.startsWith("/"))) {
            HttpSession session = httpServletRequest.getSession();
            url = PortalUtil.getURLWithSessionId(url, session.getId());
        }
        if (!resetMaxState) {
            return url;
        }
        if (PropsValues.LAYOUT_DEFAULT_P_L_RESET && !resetRenderParameters) {
            url = HttpUtil.addParameter(url, "p_l_reset", 0);
        } else if (!PropsValues.LAYOUT_DEFAULT_P_L_RESET && resetRenderParameters) {
            url = HttpUtil.addParameter(url, "p_l_reset", 1);
        }
        return url;
    }

    static {
        LayoutImpl._initFriendlyURLKeywords();
    }
}

