/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.model.impl.GroupModelImpl;
import java.util.ArrayList;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class GroupBaseImpl
extends GroupModelImpl
implements Group {
    @Override
    public void persist() {
        if (this.isNew()) {
            GroupLocalServiceUtil.addGroup(this);
        } else {
            GroupLocalServiceUtil.updateGroup(this);
        }
    }

    @Override
    public String buildTreePath() throws PortalException {
        ArrayList<GroupBaseImpl> groups = new ArrayList<GroupBaseImpl>();
        Group group = this;
        while (group != null) {
            groups.add((GroupBaseImpl)group);
            group = GroupLocalServiceUtil.fetchGroup(group.getParentGroupId());
        }
        StringBundler sb = new StringBundler(groups.size() * 2 + 1);
        sb.append("/");
        for (int i = groups.size() - 1; i >= 0; --i) {
            group = (Group)groups.get(i);
            sb.append(group.getGroupId());
            sb.append("/");
        }
        return sb.toString();
    }

    @Override
    public void updateTreePath(String treePath) {
        GroupBaseImpl group = this;
        group.setTreePath(treePath);
        GroupLocalServiceUtil.updateGroup(group);
    }
}

